/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class GameStateMessage
extends AttributeMessage {
    public static final String TAG = "gameState";
    private static final String STATE_TAG = "state";

    public GameStateMessage() {
        super(TAG);
    }

    public GameStateMessage(FreeColServer.ServerState serverState) {
        super(TAG);
        if (serverState != null) {
            this.setStringAttribute(STATE_TAG, serverState.toString());
        }
    }

    public GameStateMessage(Game game, FreeColXMLReader xr) {
        this(xr.getAttribute(STATE_TAG, FreeColServer.ServerState.class, null));
    }

    private FreeColServer.ServerState getState() {
        return this.getEnumAttribute(STATE_TAG, FreeColServer.ServerState.class, null);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        FreeColServer.ServerState state = this.getState();
        if (state != null) {
            freeColClient.setServerState(state);
        }
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return this.igc(freeColServer).gameState();
    }
}

