/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import org.keycloak.config.TransactionOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public class TransactionPropertyMappers {
    private TransactionPropertyMappers() {
    }

    public static PropertyMapper<?>[] getTransactionPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(TransactionOptions.TRANSACTION_XA_ENABLED).to("quarkus.datasource.jdbc.transactions").transformer(TransactionPropertyMappers::getQuarkusTransactionsValue).build(), PropertyMapper.fromOption(TransactionOptions.TRANSACTION_XA_ENABLED_DATASOURCE).to("quarkus.datasource.\"<datasource>\".jdbc.transactions").transformer(TransactionPropertyMappers::getQuarkusTransactionsValue).build()};
    }

    private static String getQuarkusTransactionsValue(String txValue, ConfigSourceInterceptorContext context) {
        boolean isXaEnabled = Boolean.parseBoolean(txValue);
        if (isXaEnabled) {
            return "xa";
        }
        return "enabled";
    }
}

