/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.keycloak.client.cli.util.FilterUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.ReturnFields;

public interface GlobalOptionsCmdHelper {
    default public String composeAdminRoot(String server) {
        return HttpUtil.normalize(server) + "admin";
    }

    default public String extractTypeNameFromUri(String resourceUrl) {
        String type = this.extractLastComponentOfUri(resourceUrl);
        if (type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
        return type;
    }

    default public String extractLastComponentOfUri(String resourceUrl) {
        int endPos = resourceUrl.endsWith("/") ? resourceUrl.length() - 2 : resourceUrl.length() - 1;
        int pos = resourceUrl.lastIndexOf("/", endPos);
        pos = pos == -1 ? 0 : pos;
        return resourceUrl.substring(pos + 1, endPos + 1);
    }

    default public JsonNode applyFieldFilter(ObjectMapper mapper, JsonNode rootNode, ReturnFields returnFields) {
        try {
            return FilterUtil.copyFilteredObject(rootNode, returnFields);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to apply fields filter", e);
        }
    }
}

