/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.msad;

public class UserAccountControl {
    public static final long SCRIPT = 1L;
    public static final long ACCOUNTDISABLE = 2L;
    public static final long HOMEDIR_REQUIRED = 8L;
    public static final long LOCKOUT = 16L;
    public static final long PASSWD_NOTREQD = 32L;
    public static final long PASSWD_CANT_CHANGE = 64L;
    public static final long ENCRYPTED_TEXT_PWD_ALLOWED = 128L;
    public static final long TEMP_DUPLICATE_ACCOUNT = 256L;
    public static final long NORMAL_ACCOUNT = 512L;
    public static final long INTERDOMAIN_TRUST_ACCOUNT = 2048L;
    public static final long WORKSTATION_TRUST_ACCOUNT = 4096L;
    public static final long SERVER_TRUST_ACCOUNT = 8192L;
    public static final long DONT_EXPIRE_PASSWORD = 65536L;
    public static final long MNS_LOGON_ACCOUNT = 131072L;
    public static final long SMARTCARD_REQUIRED = 262144L;
    public static final long TRUSTED_FOR_DELEGATION = 524288L;
    public static final long NOT_DELEGATED = 0x100000L;
    public static final long USE_DES_KEY_ONLY = 0x200000L;
    public static final long DONT_REQ_PREAUTH = 0x400000L;
    public static final long PASSWORD_EXPIRED = 0x800000L;
    public static final long TRUSTED_TO_AUTH_FOR_DELEGATION = 0x1000000L;
    public static final long PARTIAL_SECRETS_ACCOUNT = 0x4000000L;
    private static final UserAccountControl EMPTY = new UserAccountControl(0L);
    private long value;

    public static UserAccountControl empty() {
        return EMPTY;
    }

    public static UserAccountControl of(String userAccountControl) {
        if (userAccountControl == null) {
            return UserAccountControl.empty();
        }
        return new UserAccountControl(Long.parseLong(userAccountControl));
    }

    private UserAccountControl(long value) {
        this.value = value;
    }

    public boolean has(long feature) {
        return (this.value & feature) > 0L;
    }

    public void add(long feature) {
        if (!this.has(feature)) {
            this.value += feature;
        }
    }

    public void remove(long feature) {
        if (this.has(feature)) {
            this.value -= feature;
        }
    }

    public long getValue() {
        return this.value;
    }

    public boolean isAnySet() {
        return this.value != 0L;
    }
}

