/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.runtime.StartupEvent;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Singleton;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.config.ConfigProvider;

@Singleton
public class ConfigStaticInitValues {
    private final List<InjectedValue> injectedValues = Collections.synchronizedList(new ArrayList());

    void recordConfigValue(InjectionPoint injectionPoint, String name, String value) {
        this.injectedValues.add(new InjectedValue(injectionPoint, name, value));
    }

    void onStart(@Observes @Priority(value=-2147483648) StartupEvent event) {
        if (this.injectedValues.isEmpty()) {
            return;
        }
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        ArrayList<CallSite> mismatches = new ArrayList<CallSite>();
        for (InjectedValue injectedValue : this.injectedValues) {
            ConfigValue currentValue = config.getConfigValue(injectedValue.name);
            if (currentValue.getValue() == null || Objects.equals(currentValue.getValue(), injectedValue.value)) continue;
            mismatches.add((CallSite)((Object)(" - the runtime value of '" + injectedValue.name + "' is [" + currentValue.getValue() + "] but the value [" + injectedValue.value + "] was injected into " + injectedValue.injectionPointInfo)));
        }
        this.injectedValues.clear();
        if (!mismatches.isEmpty()) {
            throw new IllegalStateException("A runtime config property value differs from the value that was injected during the static intialization phase:\n" + String.join((CharSequence)"\n", mismatches) + "\n\nIf that's intentional then annotate the injected field/parameter with @io.quarkus.runtime.annotations.StaticInitSafe to eliminate the false positive.");
        }
    }

    private static String injectionPointToString(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            AnnotatedField field = (AnnotatedField)annotated;
            return field.getDeclaringType().getJavaClass().getName() + "#" + field.getJavaMember().getName();
        }
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter param = (AnnotatedParameter)annotated;
            if (param.getDeclaringCallable() instanceof AnnotatedConstructor) {
                return param.getDeclaringCallable().getDeclaringType().getJavaClass().getName() + "()";
            }
            return param.getDeclaringCallable().getDeclaringType().getJavaClass().getName() + "#" + param.getDeclaringCallable().getJavaMember().getName() + "()";
        }
        return injectionPoint.toString();
    }

    private static class InjectedValue {
        private final String injectionPointInfo;
        private final String name;
        private final String value;

        private InjectedValue(InjectionPoint injectionPoint, String name, String value) {
            this.injectionPointInfo = ConfigStaticInitValues.injectionPointToString(injectionPoint);
            this.name = name;
            this.value = value;
        }
    }
}

