/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.EvalSectionHelper;
import io.quarkus.qute.FragmentSectionHelper;
import io.quarkus.qute.IfSectionHelper;
import io.quarkus.qute.IncludeSectionHelper;
import io.quarkus.qute.InsertSectionHelper;
import io.quarkus.qute.LoopSectionHelper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.Namespaces;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SetSectionHelper;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.WhenSectionHelper;
import io.quarkus.qute.WithSectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EngineBuilder {
    final Map<String, SectionHelperFactory<?>> sectionHelperFactories = new HashMap();
    final List<ValueResolver> valueResolvers = new ArrayList<ValueResolver>();
    final List<NamespaceResolver> namespaceResolvers = new ArrayList<NamespaceResolver>();
    final List<TemplateLocator> locators = new ArrayList<TemplateLocator>();
    final List<ResultMapper> resultMappers = new ArrayList<ResultMapper>();
    final List<TemplateInstance.Initializer> initializers;
    Function<String, SectionHelperFactory<?>> sectionHelperFunc;
    final List<ParserHook> parserHooks = new ArrayList<ParserHook>();
    boolean removeStandaloneLines = true;
    boolean strictRendering = true;
    String iterationMetadataPrefix = "<alias_>";
    long timeout = 10000L;
    boolean useAsyncTimeout = true;

    EngineBuilder() {
        this.initializers = new ArrayList<TemplateInstance.Initializer>();
    }

    public EngineBuilder addSectionHelper(SectionHelperFactory<?> factory) {
        factory = this.cachedFactory(factory);
        for (String alias : factory.getDefaultAliases()) {
            this.sectionHelperFactories.put(alias, factory);
        }
        return this;
    }

    public EngineBuilder addSectionHelpers(SectionHelperFactory<?> ... factories) {
        for (SectionHelperFactory<?> factory : factories) {
            this.addSectionHelper(factory);
        }
        return this;
    }

    public EngineBuilder addSectionHelper(String name, SectionHelperFactory<?> factory) {
        factory = this.cachedFactory(factory);
        this.addSectionHelper(factory);
        this.sectionHelperFactories.put(name, factory);
        return this;
    }

    public EngineBuilder addDefaultSectionHelpers() {
        return this.addSectionHelpers(new IfSectionHelper.Factory(), new LoopSectionHelper.Factory(this.iterationMetadataPrefix), new WithSectionHelper.Factory(), new IncludeSectionHelper.Factory(), new InsertSectionHelper.Factory(), new SetSectionHelper.Factory(), new WhenSectionHelper.Factory(), new EvalSectionHelper.Factory(), new FragmentSectionHelper.Factory());
    }

    public EngineBuilder addValueResolver(Supplier<ValueResolver> resolverSupplier) {
        return this.addValueResolver(resolverSupplier.get());
    }

    public EngineBuilder addValueResolvers(ValueResolver ... resolvers) {
        for (ValueResolver valueResolver : resolvers) {
            this.addValueResolver(valueResolver);
        }
        return this;
    }

    public EngineBuilder addValueResolver(ValueResolver resolver) {
        this.valueResolvers.add(resolver);
        return this;
    }

    public EngineBuilder addDefaultValueResolvers() {
        return this.addValueResolvers(ValueResolvers.mapResolver(), ValueResolvers.mapperResolver(), ValueResolvers.mapEntryResolver(), ValueResolvers.collectionResolver(), ValueResolvers.listResolver(), ValueResolvers.thisResolver(), ValueResolvers.orResolver(), ValueResolvers.trueResolver(), ValueResolvers.logicalAndResolver(), ValueResolvers.logicalOrResolver(), ValueResolvers.orEmpty(), ValueResolvers.arrayResolver(), ValueResolvers.plusResolver(), ValueResolvers.minusResolver(), ValueResolvers.modResolver(), ValueResolvers.numberValueResolver());
    }

    public EngineBuilder addDefaults() {
        return this.addDefaultSectionHelpers().addDefaultValueResolvers();
    }

    public EngineBuilder addNamespaceResolver(NamespaceResolver resolver) {
        String namespace = Namespaces.requireValid(resolver.getNamespace());
        for (NamespaceResolver nsResolver : this.namespaceResolvers) {
            if (!nsResolver.getNamespace().equals(namespace) || resolver.getPriority() != nsResolver.getPriority()) continue;
            throw new IllegalArgumentException(String.format("Namespace [%s] may not be handled by multiple resolvers of the same priority [%s]: %s and %s", namespace, resolver.getPriority(), nsResolver, resolver));
        }
        this.namespaceResolvers.add(resolver);
        return this;
    }

    public EngineBuilder addLocator(TemplateLocator locator) {
        this.locators.add(locator);
        return this;
    }

    public EngineBuilder addParserHook(ParserHook parserHook) {
        this.parserHooks.add(parserHook);
        return this;
    }

    public EngineBuilder addResultMapper(ResultMapper mapper) {
        this.resultMappers.add(mapper);
        return this;
    }

    public EngineBuilder addTemplateInstanceInitializer(TemplateInstance.Initializer initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public EngineBuilder computeSectionHelper(Function<String, SectionHelperFactory<?>> func) {
        this.sectionHelperFunc = func;
        return this;
    }

    public EngineBuilder removeStandaloneLines(boolean value) {
        this.removeStandaloneLines = value;
        return this;
    }

    public EngineBuilder strictRendering(boolean value) {
        this.strictRendering = value;
        return this;
    }

    public EngineBuilder iterationMetadataPrefix(String prefix) {
        if (!("<none>".equals(prefix) || "<alias_>".equals(prefix) || "<alias?>".equals(prefix) || Namespaces.NAMESPACE_PATTERN.matcher(prefix).matches())) {
            throw new TemplateException("[" + prefix + "] is not a valid iteration metadata prefix. The value can only consist of alphanumeric characters and underscores.");
        }
        this.iterationMetadataPrefix = prefix;
        return this;
    }

    public EngineBuilder timeout(long value) {
        this.timeout = value;
        return this;
    }

    public EngineBuilder useAsyncTimeout(boolean value) {
        this.useAsyncTimeout = value;
        return this;
    }

    public Engine build() {
        return new EngineImpl(this);
    }

    private SectionHelperFactory<?> cachedFactory(SectionHelperFactory<?> factory) {
        if (factory instanceof CachedConfigSectionHelperFactory || !factory.cacheFactoryConfig()) {
            return factory;
        }
        return new CachedConfigSectionHelperFactory(factory);
    }

    static class CachedConfigSectionHelperFactory<T extends SectionHelper>
    implements SectionHelperFactory<T> {
        private final SectionHelperFactory<T> delegate;
        private final List<String> defaultAliases;
        private final SectionHelperFactory.ParametersInfo parameters;
        private final List<String> blockLabels;

        public CachedConfigSectionHelperFactory(SectionHelperFactory<T> delegate) {
            this.delegate = delegate;
            this.defaultAliases = delegate.getDefaultAliases();
            this.parameters = delegate.getParameters();
            this.blockLabels = delegate.getBlockLabels();
        }

        @Override
        public List<String> getDefaultAliases() {
            return this.defaultAliases;
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return this.parameters;
        }

        @Override
        public List<String> getBlockLabels() {
            return this.blockLabels;
        }

        @Override
        public boolean cacheFactoryConfig() {
            return true;
        }

        @Override
        public T initialize(SectionHelperFactory.SectionInitContext context) {
            return this.delegate.initialize(context);
        }

        @Override
        public boolean treatUnknownSectionsAsBlocks() {
            return this.delegate.treatUnknownSectionsAsBlocks();
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            return this.delegate.initializeBlock(outerScope, block);
        }

        @Override
        public SectionHelperFactory.MissingEndTagStrategy missingEndTagStrategy() {
            return this.delegate.missingEndTagStrategy();
        }
    }
}

