/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 39842106089449L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1989511530 - (char)-16830, -1989511530 - -((char)-5258), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1989511530 - (char)-16831, 1989511530 - (char)-28076, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 14251053568934L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.I();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(352054020 + 7265, 352054020 + (char)-29656, (int)l2) + string + WindowsNamedPipeAgentIpc.b(352054020 + 7264, -352054020 + -30924, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(352054020 + 7263, -352054020 + -14078, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 21944254147446L;
                Object object = this.lock;
                String string = SshAgentIpcService.I();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1266267270 - 13524, 1266267270 - (char)-29458, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1266267270 - 13525, 1266267270 - 17223, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1266267270 - 13526, -1266267270 - -((char)-23377), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1266267270 - 13511, -1266267270 - -((char)-20537), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1266267270 - 13512, -1266267270 - -25848, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1266267270 - 13513, -1266267270 - -19538, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1266267270 - 13511, -1266267270 - -((char)-20537), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1266267270 - 13514, 1266267270 - 32587, (int)l2));
            if (ActionTimestamp.I() == null) {
                SshAgentIpcService.I("wfFfS");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 18641657009051L;
                    string = SshAgentIpcService.I();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 89387465772353L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            string = SshAgentIpcService.I();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(606460890 - (char)-32178, -606460890 - -((char)-16560), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32179, 606460890 - (char)-32047, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32180, 606460890 - (char)-16730, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(606460890 - (char)-32178, -606460890 - -((char)-16560), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32181, 606460890 - (char)-25488, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(606460890 - (char)-32178, -606460890 - -((char)-16560), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32182, 606460890 - (char)-12571, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32183, 606460890 - (char)-27098, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32180, 606460890 - (char)-16730, (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(606460890 - (char)-32178, -606460890 - -((char)-16560), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(606460890 - (char)-32174, -606460890 - -((char)-18096), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(606460890 - (char)-32184, -606460890 - -29180, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 44056226709098L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1547805630 + 5127, 1547805630 - 4157, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 42593223950980L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-33291780 - -18734, -33291780 - -2122, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00f7\u00c17\u00ec\u00ce\u00a1-\u00b9\u001c\u00a4\u009c\u00d4\u00e2\u001c\u00be\\\u00c9\u001a$\u0014\bf\u00c8\u001e*=\u00cc\u00af\u00a2`\u008e\u0098blo\u00d9\u001el\u00d9c";
                        var4_3 = "\u00f7\u00c17\u00ec\u00ce\u00a1-\u00b9\u001c\u00a4\u009c\u00d4\u00e2\u001c\u00be\\\u00c9\u001a$\u0014\bf\u00c8\u001e*=\u00cc\u00af\u00a2`\u008e\u0098blo\u00d9\u001el\u00d9c".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 6;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 77;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 54;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 114;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 84;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 96;
                                        break;
                                    }
                                    default: {
                                        v11 = 14;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFF89AF) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 64;
                            case 1 -> 66;
                            case 2 -> 95;
                            case 3 -> 118;
                            case 4 -> 219;
                            case 5 -> 209;
                            case 6 -> 15;
                            case 7 -> 121;
                            case 8 -> 59;
                            case 9 -> 205;
                            case 10 -> 20;
                            case 11 -> 52;
                            case 12 -> 222;
                            case 13 -> 180;
                            case 14 -> 248;
                            case 15 -> 246;
                            case 16 -> 221;
                            case 17 -> 33;
                            case 18 -> 96;
                            case 19 -> 173;
                            case 20 -> 6;
                            case 21 -> 167;
                            case 22 -> 172;
                            case 23 -> 93;
                            case 24 -> 213;
                            case 25 -> 40;
                            case 26 -> 80;
                            case 27 -> 127;
                            case 28 -> 154;
                            case 29 -> 231;
                            case 30 -> 70;
                            case 31 -> 44;
                            case 32 -> 240;
                            case 33 -> 171;
                            case 34 -> 94;
                            case 35 -> 108;
                            case 36 -> 216;
                            case 37 -> 147;
                            case 38 -> 184;
                            case 39 -> 119;
                            case 40 -> 143;
                            case 41 -> 174;
                            case 42 -> 177;
                            case 43 -> 236;
                            case 44 -> 155;
                            case 45 -> 19;
                            case 46 -> 137;
                            case 47 -> 239;
                            case 48 -> 253;
                            case 49 -> 104;
                            case 50 -> 17;
                            case 51 -> 163;
                            case 52 -> 74;
                            case 53 -> 151;
                            case 54 -> 68;
                            case 55 -> 130;
                            case 56 -> 161;
                            case 57 -> 191;
                            case 58 -> 60;
                            case 59 -> 192;
                            case 60 -> 139;
                            case 61 -> 63;
                            case 62 -> 8;
                            case 63 -> 141;
                            case 64 -> 175;
                            case 65 -> 176;
                            case 66 -> 132;
                            case 67 -> 149;
                            case 68 -> 49;
                            case 69 -> 112;
                            case 70 -> 123;
                            case 71 -> 39;
                            case 72 -> 5;
                            case 73 -> 217;
                            case 74 -> 56;
                            case 75 -> 115;
                            case 76 -> 71;
                            case 77 -> 102;
                            case 78 -> 204;
                            case 79 -> 46;
                            case 80 -> 36;
                            case 81 -> 38;
                            case 82 -> 37;
                            case 83 -> 34;
                            case 84 -> 152;
                            case 85 -> 111;
                            case 86 -> 83;
                            case 87 -> 57;
                            case 88 -> 99;
                            case 89 -> 2;
                            case 90 -> 224;
                            case 91 -> 14;
                            case 92 -> 251;
                            case 93 -> 178;
                            case 94 -> 69;
                            case 95 -> 200;
                            case 96 -> 170;
                            case 97 -> 53;
                            case 98 -> 122;
                            case 99 -> 82;
                            case 100 -> 241;
                            case 101 -> 244;
                            case 102 -> 235;
                            case 103 -> 148;
                            case 104 -> 223;
                            case 105 -> 186;
                            case 106 -> 202;
                            case 107 -> 228;
                            case 108 -> 86;
                            case 109 -> 87;
                            case 110 -> 249;
                            case 111 -> 24;
                            case 112 -> 72;
                            case 113 -> 48;
                            case 114 -> 32;
                            case 115 -> 85;
                            case 116 -> 214;
                            case 117 -> 188;
                            case 118 -> 212;
                            case 119 -> 73;
                            case 120 -> 199;
                            case 121 -> 110;
                            case 122 -> 109;
                            case 123 -> 3;
                            case 124 -> 140;
                            case 125 -> 31;
                            case 126 -> 153;
                            case 127 -> 254;
                            case 128 -> 18;
                            case 129 -> 103;
                            case 130 -> 113;
                            case 131 -> 125;
                            case 132 -> 238;
                            case 133 -> 23;
                            case 134 -> 47;
                            case 135 -> 225;
                            case 136 -> 77;
                            case 137 -> 55;
                            case 138 -> 91;
                            case 139 -> 26;
                            case 140 -> 193;
                            case 141 -> 116;
                            case 142 -> 7;
                            case 143 -> 105;
                            case 144 -> 75;
                            case 145 -> 27;
                            case 146 -> 76;
                            case 147 -> 227;
                            case 148 -> 30;
                            case 149 -> 129;
                            case 150 -> 181;
                            case 151 -> 107;
                            case 152 -> 51;
                            case 153 -> 183;
                            case 154 -> 89;
                            case 155 -> 61;
                            case 156 -> 203;
                            case 157 -> 196;
                            case 158 -> 10;
                            case 159 -> 185;
                            case 160 -> 29;
                            case 161 -> 189;
                            case 162 -> 201;
                            case 163 -> 252;
                            case 164 -> 230;
                            case 165 -> 206;
                            case 166 -> 65;
                            case 167 -> 197;
                            case 168 -> 211;
                            case 169 -> 13;
                            case 170 -> 233;
                            case 171 -> 90;
                            case 172 -> 42;
                            case 173 -> 215;
                            case 174 -> 145;
                            case 175 -> 45;
                            case 176 -> 101;
                            case 177 -> 207;
                            case 178 -> 41;
                            case 179 -> 179;
                            case 180 -> 50;
                            case 181 -> 243;
                            case 182 -> 117;
                            case 183 -> 67;
                            case 184 -> 220;
                            case 185 -> 88;
                            case 186 -> 150;
                            case 187 -> 135;
                            case 188 -> 25;
                            case 189 -> 22;
                            case 190 -> 245;
                            case 191 -> 142;
                            case 192 -> 12;
                            case 193 -> 242;
                            case 194 -> 229;
                            case 195 -> 195;
                            case 196 -> 237;
                            case 197 -> 84;
                            case 198 -> 21;
                            case 199 -> 28;
                            case 200 -> 255;
                            case 201 -> 232;
                            case 202 -> 81;
                            case 203 -> 164;
                            case 204 -> 131;
                            case 205 -> 144;
                            case 206 -> 9;
                            case 207 -> 97;
                            case 208 -> 54;
                            case 209 -> 182;
                            case 210 -> 190;
                            case 211 -> 198;
                            case 212 -> 234;
                            case 213 -> 250;
                            case 214 -> 79;
                            case 215 -> 157;
                            case 216 -> 124;
                            case 217 -> 187;
                            case 218 -> 156;
                            case 219 -> 0;
                            case 220 -> 62;
                            case 221 -> 136;
                            case 222 -> 226;
                            case 223 -> 43;
                            case 224 -> 92;
                            case 225 -> 165;
                            case 226 -> 166;
                            case 227 -> 194;
                            case 228 -> 146;
                            case 229 -> 78;
                            case 230 -> 160;
                            case 231 -> 4;
                            case 232 -> 1;
                            case 233 -> 210;
                            case 234 -> 168;
                            case 235 -> 100;
                            case 236 -> 162;
                            case 237 -> 35;
                            case 238 -> 218;
                            case 239 -> 16;
                            case 240 -> 128;
                            case 241 -> 159;
                            case 242 -> 106;
                            case 243 -> 133;
                            case 244 -> 247;
                            case 245 -> 158;
                            case 246 -> 138;
                            case 247 -> 126;
                            case 248 -> 169;
                            case 249 -> 98;
                            case 250 -> 208;
                            case 251 -> 58;
                            case 252 -> 134;
                            case 253 -> 120;
                            case 254 -> 114;
                            default -> 11;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.I(new String[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 37184590746327L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.I();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1236121170 - -31852, 1236121170 - 14706, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1236121170 - -31856, 1236121170 - 29554, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1236121170 - -31831, -1236121170 - -((char)-30988), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1236121170 - -31852, 1236121170 - 14706, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1236121170 - -31856, 1236121170 - 29554, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1236121170 - -31828, -1236121170 - -23244, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 48583748549698L;
                        String string3 = SshAgentIpcService.I();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-921553170 - -29096, -921553170 - -30898, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-921553170 - -29095, 921553170 - (char)-22090, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 75941244606899L;
                String string2 = SshAgentIpcService.I();
                this.assertConnectionThread();
                string = string2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16488, -1927777560 + -((char)-1180), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16484, -1927908630 - -((char)-10598), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16463, -1927908630 - -((char)-4716), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16484, -1927908630 - -((char)-10598), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16486, 1927777560 + (char)-850, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16488, -1927777560 + -((char)-1180), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16484, -1927908630 - -((char)-10598), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16468, -1927908630 - -((char)-8439), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16488, -1927777560 + -((char)-1180), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16484, -1927908630 - -((char)-10598), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16469, 1927908630 - (char)-14114, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16488, -1927777560 + -((char)-1180), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16484, -1927908630 - -((char)-10598), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927908630 - (char)-16466, 1927908630 - (char)-11345, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 94006728340715L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.I();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515824550 - -1484, 1515824550 + 13622, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1515824550 - -1480, 1515824550 + 16182, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515824550 - -1495, -1515824550 - -7853, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1515824550 - -1500, -1515824550 + -19745, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515824550 - -1484, 1515824550 + 13622, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1515824550 - -1480, 1515824550 + 16182, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515824550 - -1501, -1515824550 - -2728, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515824550 - -1484, 1515824550 + 13622, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1515824550 - -1480, 1515824550 + 16182, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515824550 - -1498, 1515824550 + 21709, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515824550 - -1484, 1515824550 + 13622, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1515824550 - -1480, 1515824550 + 16182, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515824550 - -1499, -1515824550 + -2065, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1515824550 - -1484, 1515824550 + 13622, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1515824550 - -1480, 1515824550 + 16182, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1515824550 - -1456, -1515824550 - -9460, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1515824550 - -1457, 1515824550 - 8106, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00d7\u00b7Bl\u008a\u00adS\u00b9\u0014\u0093l\u00f2\u00f0b\u00b6\u00e1\u00c0\u00b4[\"\u00aa\u0007\u00f0S\u00a9)^\u00f5\u00c3\u0006\u00c4\u00c6 B\u00ac)\u0018\u0095xRB\u00f4%1rfpw\u00bf\u00cb\u00ad\u0098\u0080\u00f9\u0012\u00c1\u00d7\u00a9\u00b9\u00a7u\t\u0088\u0013o\u009e8!\u00b0\u00baj\u0005=k\u001f\u00f7Q\bCK\u00d0\u0082\u008aVU$\u0014.\u00f2=\u00b8\u00f6\u00b7Fw.p\u00da{RiBw\u0019V\n\u0080\u0005\u00a8y\u00ad\u00b5\u0007\u001e`\u00b0\u00a1\u00e8\u001b\u00b4n:(m\u00f5\u009b\u00d7\t\u00b9p<\u009d\u00ab\u00d2H6\u0097I\u0011M5\u00d6\u00c1i\u0010\u00c3\u00a21o^v0\u009b\u009e\u00eb\u00ae\u00b6\u00ba\u00f9\u00bb\u00f1\tK\u0003\u00c1\u008d\u00bedF\u008dZ\u0010\u0000\u009aIhQ\u0096\u00d1\u0087\u00a2h)\u00c6J\u00f7\u00a50?\u001fhF\u00f3\u00ea\u00de\u00d5\u001b.\u0098p\u00de\u00d8We\u0082b\u00a6\u001dp\u00100\u00e7\u00ef\u000fq\u00fb\u00e5/Y\u00d4\u00c6\u00d4\u000f\u00fe\u00a8AH\u00e0\u00c6\u001b_\u0080\u00a2\u00c7\u00cc\u00d8\u00c6\u0095j\u00f9\u00d5\u00ee)\u00e8Y\u00ee\u00bf;0\u0005\u00a6K\b\u00df9C\u00cc\u00f8\u009f\u001b\u001d\f*^\u00ed;0\u0003\u00ec\u0089,\u00e1\u00aa\u00f3F\u009f+[\u0095\u00e6\u00d663w\u00ba\u00cb\\9\u000fF\u00af\u00fad\u000e\u0087`\u009c\u00eaH\u0098\u00ae\u00fa\u0015\u00b0n\u001d\u001c\u00d1\u00e2\u009c4\u00d7\u0096\u0099\u00d9\u00a7\u00a9\u009c\u0087\u009a\u00ed'\u009f\u008d\u00b9\u009c\u0005\u00ad\u00a5\u0096\u00d3\u00be\u009a\u00a7(\u00a5\u00cc\u0003ZDY\u00aaF\u00f7\u00c5\u001fse\u00c3RW\u00e3\u00e7\u00d0\u00190\u00d30\u0013a*\u00cc5\u00e2\u00f7\u00f7\b\u0012Hf\u008bxq\u00bcT\u00d5\u0083\u000b\u00d8\u00db\u00b3\u008b\u00fb\u0015\u0095K\u0003\u00b5E\u0015'#L\u0097\u0003\u00fefKCU\u0085Wg!\u00b9\u0092\u00bc\u00bd\u001be\u00a3)\u00c1M\u0095W\u009dC\u00be\u00c42\u00b2\u00b6`\u00bba\u00a1\u00c9\u001b\u00ca\u00e9U;>\u00e8\u00fb\u00f0\u0082\u00c9\u009bl\u00c5\u0006WL.I s\t\u0086\u0083\u00e7\u0007e\u0095\u000bVj>\u00db\u0007\u00fe\u00d8\u001c\u0093oim(\u008aV\u00b0\u0015\u0089a\u00ca\u00a7\u00cc\tC!&\u00c8P\u007f\"\u00b1`yk\u0085\u008dG\u00cc\u00a9\u00f8\u0085}f\u00ff:\u0088\u00e8OU\t\u00daZ\n\u000f\u0083\u0080\u00df\u00e6\u008cs\u00cf&\u0019\u00b4X\u00c7\u00e5@\u00b6\"\u007f\u00d6B$g-\u00e1\t\u00d9\u000b\u00cbW\u0017\u008bPZ\u00ce\u0091\u00d9|\u00d7\u001b\u00d5\u000f\u00c4H\u0082\u001c!\u0007\r\b\u00036\u000e\u0003\u00cc\u00cfo\u008eB\u008f\u0000\u0011pY_\u00c9Y\u001b\u00af7]\u0015'\u00b8/\u0003R\u0097\u00bc\u00a2%\u00d00'j\u0094\u00f0@\u00c9\u00a8e\u00df\u0099?|\n\u008dI\u00dd\u00dd#E|\u0096\u0093G\u0018\u0019\u00ca\u008b\u00a7\u00fcRu\u0000\u0007>\u00d4\b\u0091\u00d6Z\u00c6P\u00a9`\u009e\u00a38s\u009e)\u00e3\u00d6\u00d1$\u0015-\u00af\t\u0010\u000b\u00f2W7\u008e\u00afO\u00a4o\u00c1$\u0004\u0000F0Pi@\n\u000e\u00ab\u00f1\u000b\u0097{\u00e7\u001ex\u00ea\u00e7\u00ff\u00cb\t\u00c9~\u0091<\u00be\u009d\u0010\u00e9-";
                var4_3 = "\u00d7\u00b7Bl\u008a\u00adS\u00b9\u0014\u0093l\u00f2\u00f0b\u00b6\u00e1\u00c0\u00b4[\"\u00aa\u0007\u00f0S\u00a9)^\u00f5\u00c3\u0006\u00c4\u00c6 B\u00ac)\u0018\u0095xRB\u00f4%1rfpw\u00bf\u00cb\u00ad\u0098\u0080\u00f9\u0012\u00c1\u00d7\u00a9\u00b9\u00a7u\t\u0088\u0013o\u009e8!\u00b0\u00baj\u0005=k\u001f\u00f7Q\bCK\u00d0\u0082\u008aVU$\u0014.\u00f2=\u00b8\u00f6\u00b7Fw.p\u00da{RiBw\u0019V\n\u0080\u0005\u00a8y\u00ad\u00b5\u0007\u001e`\u00b0\u00a1\u00e8\u001b\u00b4n:(m\u00f5\u009b\u00d7\t\u00b9p<\u009d\u00ab\u00d2H6\u0097I\u0011M5\u00d6\u00c1i\u0010\u00c3\u00a21o^v0\u009b\u009e\u00eb\u00ae\u00b6\u00ba\u00f9\u00bb\u00f1\tK\u0003\u00c1\u008d\u00bedF\u008dZ\u0010\u0000\u009aIhQ\u0096\u00d1\u0087\u00a2h)\u00c6J\u00f7\u00a50?\u001fhF\u00f3\u00ea\u00de\u00d5\u001b.\u0098p\u00de\u00d8We\u0082b\u00a6\u001dp\u00100\u00e7\u00ef\u000fq\u00fb\u00e5/Y\u00d4\u00c6\u00d4\u000f\u00fe\u00a8AH\u00e0\u00c6\u001b_\u0080\u00a2\u00c7\u00cc\u00d8\u00c6\u0095j\u00f9\u00d5\u00ee)\u00e8Y\u00ee\u00bf;0\u0005\u00a6K\b\u00df9C\u00cc\u00f8\u009f\u001b\u001d\f*^\u00ed;0\u0003\u00ec\u0089,\u00e1\u00aa\u00f3F\u009f+[\u0095\u00e6\u00d663w\u00ba\u00cb\\9\u000fF\u00af\u00fad\u000e\u0087`\u009c\u00eaH\u0098\u00ae\u00fa\u0015\u00b0n\u001d\u001c\u00d1\u00e2\u009c4\u00d7\u0096\u0099\u00d9\u00a7\u00a9\u009c\u0087\u009a\u00ed'\u009f\u008d\u00b9\u009c\u0005\u00ad\u00a5\u0096\u00d3\u00be\u009a\u00a7(\u00a5\u00cc\u0003ZDY\u00aaF\u00f7\u00c5\u001fse\u00c3RW\u00e3\u00e7\u00d0\u00190\u00d30\u0013a*\u00cc5\u00e2\u00f7\u00f7\b\u0012Hf\u008bxq\u00bcT\u00d5\u0083\u000b\u00d8\u00db\u00b3\u008b\u00fb\u0015\u0095K\u0003\u00b5E\u0015'#L\u0097\u0003\u00fefKCU\u0085Wg!\u00b9\u0092\u00bc\u00bd\u001be\u00a3)\u00c1M\u0095W\u009dC\u00be\u00c42\u00b2\u00b6`\u00bba\u00a1\u00c9\u001b\u00ca\u00e9U;>\u00e8\u00fb\u00f0\u0082\u00c9\u009bl\u00c5\u0006WL.I s\t\u0086\u0083\u00e7\u0007e\u0095\u000bVj>\u00db\u0007\u00fe\u00d8\u001c\u0093oim(\u008aV\u00b0\u0015\u0089a\u00ca\u00a7\u00cc\tC!&\u00c8P\u007f\"\u00b1`yk\u0085\u008dG\u00cc\u00a9\u00f8\u0085}f\u00ff:\u0088\u00e8OU\t\u00daZ\n\u000f\u0083\u0080\u00df\u00e6\u008cs\u00cf&\u0019\u00b4X\u00c7\u00e5@\u00b6\"\u007f\u00d6B$g-\u00e1\t\u00d9\u000b\u00cbW\u0017\u008bPZ\u00ce\u0091\u00d9|\u00d7\u001b\u00d5\u000f\u00c4H\u0082\u001c!\u0007\r\b\u00036\u000e\u0003\u00cc\u00cfo\u008eB\u008f\u0000\u0011pY_\u00c9Y\u001b\u00af7]\u0015'\u00b8/\u0003R\u0097\u00bc\u00a2%\u00d00'j\u0094\u00f0@\u00c9\u00a8e\u00df\u0099?|\n\u008dI\u00dd\u00dd#E|\u0096\u0093G\u0018\u0019\u00ca\u008b\u00a7\u00fcRu\u0000\u0007>\u00d4\b\u0091\u00d6Z\u00c6P\u00a9`\u009e\u00a38s\u009e)\u00e3\u00d6\u00d1$\u0015-\u00af\t\u0010\u000b\u00f2W7\u008e\u00afO\u00a4o\u00c1$\u0004\u0000F0Pi@\n\u000e\u00ab\u00f1\u000b\u0097{\u00e7\u001ex\u00ea\u00e7\u00ff\u00cb\t\u00c9~\u0091<\u00be\u009d\u0010\u00e9-".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 127;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "r\u00efJ\u00aa\u00cfU]\u00af\u00e7v\u00a5Qt\u00e7n\u00cb5Z\n\u00af\u0081\u00e7\u00ac\u00bb\u000f\u00ad\u0093~M\u0014:\u00f2n\u008aXP\u000f\u00b5\u00c0\\\u0005\u00e3JpS\u0010\u0080\u00c0i\u00b9";
                    var4_3 = "r\u00efJ\u00aa\u00cfU]\u00af\u00e7v\u00a5Qt\u00e7n\u00cb5Z\n\u00af\u0081\u00e7\u00ac\u00bb\u000f\u00ad\u0093~M\u0014:\u00f2n\u008aXP\u000f\u00b5\u00c0\\\u0005\u00e3JpS\u0010\u0080\u00c0i\u00b9".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 83;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 59;
                            break;
                        }
                        case 1: {
                            v15 = 90;
                            break;
                        }
                        case 2: {
                            v15 = 65;
                            break;
                        }
                        case 3: {
                            v15 = 96;
                            break;
                        }
                        case 4: {
                            v15 = 84;
                            break;
                        }
                        case 5: {
                            v15 = 20;
                            break;
                        }
                        default: {
                            v15 = 54;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x54C1) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 5;
                case 1 -> 66;
                case 2 -> 6;
                case 3 -> 109;
                case 4 -> 8;
                case 5 -> 98;
                case 6 -> 214;
                case 7 -> 12;
                case 8 -> 121;
                case 9 -> 124;
                case 10 -> 143;
                case 11 -> 203;
                case 12 -> 144;
                case 13 -> 246;
                case 14 -> 102;
                case 15 -> 24;
                case 16 -> 156;
                case 17 -> 129;
                case 18 -> 190;
                case 19 -> 241;
                case 20 -> 126;
                case 21 -> 209;
                case 22 -> 216;
                case 23 -> 220;
                case 24 -> 176;
                case 25 -> 132;
                case 26 -> 133;
                case 27 -> 37;
                case 28 -> 68;
                case 29 -> 118;
                case 30 -> 233;
                case 31 -> 162;
                case 32 -> 170;
                case 33 -> 145;
                case 34 -> 152;
                case 35 -> 239;
                case 36 -> 230;
                case 37 -> 142;
                case 38 -> 245;
                case 39 -> 4;
                case 40 -> 140;
                case 41 -> 22;
                case 42 -> 157;
                case 43 -> 78;
                case 44 -> 171;
                case 45 -> 111;
                case 46 -> 227;
                case 47 -> 99;
                case 48 -> 134;
                case 49 -> 168;
                case 50 -> 139;
                case 51 -> 164;
                case 52 -> 222;
                case 53 -> 151;
                case 54 -> 75;
                case 55 -> 232;
                case 56 -> 242;
                case 57 -> 141;
                case 58 -> 153;
                case 59 -> 138;
                case 60 -> 169;
                case 61 -> 59;
                case 62 -> 217;
                case 63 -> 158;
                case 64 -> 208;
                case 65 -> 199;
                case 66 -> 204;
                case 67 -> 197;
                case 68 -> 20;
                case 69 -> 52;
                case 70 -> 213;
                case 71 -> 87;
                case 72 -> 122;
                case 73 -> 119;
                case 74 -> 188;
                case 75 -> 108;
                case 76 -> 13;
                case 77 -> 17;
                case 78 -> 185;
                case 79 -> 234;
                case 80 -> 181;
                case 81 -> 196;
                case 82 -> 252;
                case 83 -> 167;
                case 84 -> 70;
                case 85 -> 58;
                case 86 -> 0;
                case 87 -> 179;
                case 88 -> 43;
                case 89 -> 35;
                case 90 -> 82;
                case 91 -> 231;
                case 92 -> 1;
                case 93 -> 130;
                case 94 -> 247;
                case 95 -> 202;
                case 96 -> 163;
                case 97 -> 60;
                case 98 -> 36;
                case 99 -> 28;
                case 100 -> 123;
                case 101 -> 210;
                case 102 -> 253;
                case 103 -> 77;
                case 104 -> 51;
                case 105 -> 150;
                case 106 -> 54;
                case 107 -> 65;
                case 108 -> 7;
                case 109 -> 146;
                case 110 -> 215;
                case 111 -> 114;
                case 112 -> 115;
                case 113 -> 248;
                case 114 -> 103;
                case 115 -> 49;
                case 116 -> 86;
                case 117 -> 249;
                case 118 -> 221;
                case 119 -> 80;
                case 120 -> 136;
                case 121 -> 229;
                case 122 -> 88;
                case 123 -> 243;
                case 124 -> 61;
                case 125 -> 254;
                case 126 -> 3;
                case 127 -> 112;
                case 128 -> 154;
                case 129 -> 95;
                case 130 -> 105;
                case 131 -> 116;
                case 132 -> 31;
                case 133 -> 238;
                case 134 -> 47;
                case 135 -> 218;
                case 136 -> 100;
                case 137 -> 39;
                case 138 -> 93;
                case 139 -> 174;
                case 140 -> 83;
                case 141 -> 235;
                case 142 -> 182;
                case 143 -> 26;
                case 144 -> 110;
                case 145 -> 44;
                case 146 -> 56;
                case 147 -> 2;
                case 148 -> 19;
                case 149 -> 149;
                case 150 -> 42;
                case 151 -> 244;
                case 152 -> 219;
                case 153 -> 71;
                case 154 -> 148;
                case 155 -> 212;
                case 156 -> 189;
                case 157 -> 23;
                case 158 -> 187;
                case 159 -> 45;
                case 160 -> 50;
                case 161 -> 160;
                case 162 -> 131;
                case 163 -> 33;
                case 164 -> 191;
                case 165 -> 34;
                case 166 -> 41;
                case 167 -> 251;
                case 168 -> 228;
                case 169 -> 159;
                case 170 -> 106;
                case 171 -> 177;
                case 172 -> 225;
                case 173 -> 32;
                case 174 -> 107;
                case 175 -> 91;
                case 176 -> 55;
                case 177 -> 104;
                case 178 -> 53;
                case 179 -> 29;
                case 180 -> 72;
                case 181 -> 63;
                case 182 -> 11;
                case 183 -> 62;
                case 184 -> 240;
                case 185 -> 57;
                case 186 -> 85;
                case 187 -> 175;
                case 188 -> 101;
                case 189 -> 73;
                case 190 -> 194;
                case 191 -> 25;
                case 192 -> 173;
                case 193 -> 224;
                case 194 -> 166;
                case 195 -> 125;
                case 196 -> 193;
                case 197 -> 180;
                case 198 -> 192;
                case 199 -> 67;
                case 200 -> 226;
                case 201 -> 237;
                case 202 -> 64;
                case 203 -> 172;
                case 204 -> 120;
                case 205 -> 96;
                case 206 -> 223;
                case 207 -> 184;
                case 208 -> 205;
                case 209 -> 165;
                case 210 -> 69;
                case 211 -> 14;
                case 212 -> 206;
                case 213 -> 201;
                case 214 -> 79;
                case 215 -> 97;
                case 216 -> 113;
                case 217 -> 137;
                case 218 -> 89;
                case 219 -> 211;
                case 220 -> 74;
                case 221 -> 117;
                case 222 -> 207;
                case 223 -> 76;
                case 224 -> 135;
                case 225 -> 128;
                case 226 -> 94;
                case 227 -> 10;
                case 228 -> 127;
                case 229 -> 195;
                case 230 -> 183;
                case 231 -> 178;
                case 232 -> 16;
                case 233 -> 46;
                case 234 -> 38;
                case 235 -> 27;
                case 236 -> 155;
                case 237 -> 9;
                case 238 -> 48;
                case 239 -> 90;
                case 240 -> 21;
                case 241 -> 30;
                case 242 -> 18;
                case 243 -> 161;
                case 244 -> 255;
                case 245 -> 200;
                case 246 -> 198;
                case 247 -> 186;
                case 248 -> 250;
                case 249 -> 147;
                case 250 -> 40;
                case 251 -> 84;
                case 252 -> 81;
                case 253 -> 15;
                case 254 -> 92;
                default -> 236;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 56494602961532L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1396812990 + -((char)-27308), 1396812990 + (char)-26660, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 49715346805250L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.I();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1100332650 + (char)-20697, -1100332650 + -((char)-19427), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1100332650 + (char)-20696, -1100332650 + -27762, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1100332650 + (char)-20695, -1100332650 + -((char)-29573), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0093\u0080e\u0001\u00f0\u00070\u00d5\u0010\u00b6\u00fa0\u00ef\u00e0a\u00cb@[?\u009d\u00b2\u00dbU\u00ae\u00de";
                    var4_3 = "\u0093\u0080e\u0001\u00f0\u00070\u00d5\u0010\u00b6\u00fa0\u00ef\u00e0a\u00cb@[?\u009d\u00b2\u00dbU\u00ae\u00de".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 5;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e55\u00b0\u00ac!5\u00cd\u00cf\u00a2\u009f\u00b1M\u00e2u\u00129=\u00a9#\u00c7\u00af\u001d\u0091\fq\u00a8\u00b6\u008c>\u0098\u00c5\u00b5\u00a1`\u00d6x\u008e5\u00e6\u00d1\u008b\u0010\u008b\u00c1m\u0019\u0006\u00bc\u0096\u0097\u00e4\u0011\u00cb\u00f3t\u0018w\n\u00ea";
                        var4_3 = "\u00e55\u00b0\u00ac!5\u00cd\u00cf\u00a2\u009f\u00b1M\u00e2u\u00129=\u00a9#\u00c7\u00af\u001d\u0091\fq\u00a8\u00b6\u008c>\u0098\u00c5\u00b5\u00a1`\u00d6x\u008e5\u00e6\u00d1\u008b\u0010\u008b\u00c1m\u0019\u0006\u00bc\u0096\u0097\u00e4\u0011\u00cb\u00f3t\u0018w\n\u00ea".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 29;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 29;
                                break;
                            }
                            case 1: {
                                v15 = 119;
                                break;
                            }
                            case 2: {
                                v15 = 31;
                                break;
                            }
                            case 3: {
                                v15 = 123;
                                break;
                            }
                            case 4: {
                                v15 = 52;
                                break;
                            }
                            case 5: {
                                v15 = 69;
                                break;
                            }
                            default: {
                                v15 = 35;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7F92) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 146;
                    case 1 -> 153;
                    case 2 -> 10;
                    case 3 -> 30;
                    case 4 -> 176;
                    case 5 -> 202;
                    case 6 -> 98;
                    case 7 -> 90;
                    case 8 -> 71;
                    case 9 -> 99;
                    case 10 -> 15;
                    case 11 -> 0;
                    case 12 -> 144;
                    case 13 -> 236;
                    case 14 -> 180;
                    case 15 -> 224;
                    case 16 -> 183;
                    case 17 -> 22;
                    case 18 -> 119;
                    case 19 -> 197;
                    case 20 -> 163;
                    case 21 -> 201;
                    case 22 -> 102;
                    case 23 -> 230;
                    case 24 -> 210;
                    case 25 -> 93;
                    case 26 -> 53;
                    case 27 -> 11;
                    case 28 -> 49;
                    case 29 -> 85;
                    case 30 -> 44;
                    case 31 -> 254;
                    case 32 -> 140;
                    case 33 -> 113;
                    case 34 -> 205;
                    case 35 -> 232;
                    case 36 -> 59;
                    case 37 -> 215;
                    case 38 -> 149;
                    case 39 -> 247;
                    case 40 -> 46;
                    case 41 -> 238;
                    case 42 -> 221;
                    case 43 -> 65;
                    case 44 -> 222;
                    case 45 -> 172;
                    case 46 -> 203;
                    case 47 -> 250;
                    case 48 -> 89;
                    case 49 -> 134;
                    case 50 -> 150;
                    case 51 -> 173;
                    case 52 -> 2;
                    case 53 -> 151;
                    case 54 -> 8;
                    case 55 -> 100;
                    case 56 -> 125;
                    case 57 -> 127;
                    case 58 -> 94;
                    case 59 -> 5;
                    case 60 -> 108;
                    case 61 -> 43;
                    case 62 -> 209;
                    case 63 -> 244;
                    case 64 -> 122;
                    case 65 -> 154;
                    case 66 -> 249;
                    case 67 -> 121;
                    case 68 -> 155;
                    case 69 -> 87;
                    case 70 -> 79;
                    case 71 -> 147;
                    case 72 -> 17;
                    case 73 -> 72;
                    case 74 -> 181;
                    case 75 -> 83;
                    case 76 -> 252;
                    case 77 -> 61;
                    case 78 -> 124;
                    case 79 -> 66;
                    case 80 -> 27;
                    case 81 -> 95;
                    case 82 -> 185;
                    case 83 -> 253;
                    case 84 -> 162;
                    case 85 -> 111;
                    case 86 -> 54;
                    case 87 -> 226;
                    case 88 -> 165;
                    case 89 -> 216;
                    case 90 -> 40;
                    case 91 -> 13;
                    case 92 -> 41;
                    case 93 -> 105;
                    case 94 -> 114;
                    case 95 -> 126;
                    case 96 -> 109;
                    case 97 -> 168;
                    case 98 -> 6;
                    case 99 -> 237;
                    case 100 -> 36;
                    case 101 -> 170;
                    case 102 -> 158;
                    case 103 -> 73;
                    case 104 -> 191;
                    case 105 -> 213;
                    case 106 -> 245;
                    case 107 -> 14;
                    case 108 -> 219;
                    case 109 -> 64;
                    case 110 -> 148;
                    case 111 -> 118;
                    case 112 -> 231;
                    case 113 -> 106;
                    case 114 -> 68;
                    case 115 -> 211;
                    case 116 -> 31;
                    case 117 -> 42;
                    case 118 -> 84;
                    case 119 -> 242;
                    case 120 -> 192;
                    case 121 -> 195;
                    case 122 -> 229;
                    case 123 -> 50;
                    case 124 -> 217;
                    case 125 -> 117;
                    case 126 -> 24;
                    case 127 -> 57;
                    case 128 -> 92;
                    case 129 -> 131;
                    case 130 -> 39;
                    case 131 -> 77;
                    case 132 -> 160;
                    case 133 -> 12;
                    case 134 -> 251;
                    case 135 -> 182;
                    case 136 -> 29;
                    case 137 -> 193;
                    case 138 -> 63;
                    case 139 -> 235;
                    case 140 -> 51;
                    case 141 -> 96;
                    case 142 -> 207;
                    case 143 -> 81;
                    case 144 -> 143;
                    case 145 -> 116;
                    case 146 -> 130;
                    case 147 -> 190;
                    case 148 -> 161;
                    case 149 -> 184;
                    case 150 -> 52;
                    case 151 -> 157;
                    case 152 -> 104;
                    case 153 -> 167;
                    case 154 -> 23;
                    case 155 -> 136;
                    case 156 -> 115;
                    case 157 -> 188;
                    case 158 -> 175;
                    case 159 -> 243;
                    case 160 -> 3;
                    case 161 -> 60;
                    case 162 -> 248;
                    case 163 -> 16;
                    case 164 -> 33;
                    case 165 -> 137;
                    case 166 -> 240;
                    case 167 -> 189;
                    case 168 -> 9;
                    case 169 -> 234;
                    case 170 -> 171;
                    case 171 -> 177;
                    case 172 -> 112;
                    case 173 -> 169;
                    case 174 -> 178;
                    case 175 -> 186;
                    case 176 -> 74;
                    case 177 -> 45;
                    case 178 -> 156;
                    case 179 -> 101;
                    case 180 -> 133;
                    case 181 -> 208;
                    case 182 -> 67;
                    case 183 -> 141;
                    case 184 -> 103;
                    case 185 -> 70;
                    case 186 -> 21;
                    case 187 -> 241;
                    case 188 -> 198;
                    case 189 -> 142;
                    case 190 -> 246;
                    case 191 -> 78;
                    case 192 -> 47;
                    case 193 -> 152;
                    case 194 -> 179;
                    case 195 -> 204;
                    case 196 -> 37;
                    case 197 -> 200;
                    case 198 -> 56;
                    case 199 -> 196;
                    case 200 -> 55;
                    case 201 -> 194;
                    case 202 -> 199;
                    case 203 -> 4;
                    case 204 -> 212;
                    case 205 -> 34;
                    case 206 -> 1;
                    case 207 -> 233;
                    case 208 -> 26;
                    case 209 -> 206;
                    case 210 -> 35;
                    case 211 -> 159;
                    case 212 -> 32;
                    case 213 -> 228;
                    case 214 -> 110;
                    case 215 -> 107;
                    case 216 -> 255;
                    case 217 -> 91;
                    case 218 -> 135;
                    case 219 -> 239;
                    case 220 -> 62;
                    case 221 -> 164;
                    case 222 -> 214;
                    case 223 -> 220;
                    case 224 -> 227;
                    case 225 -> 166;
                    case 226 -> 28;
                    case 227 -> 139;
                    case 228 -> 75;
                    case 229 -> 145;
                    case 230 -> 7;
                    case 231 -> 218;
                    case 232 -> 82;
                    case 233 -> 187;
                    case 234 -> 174;
                    case 235 -> 18;
                    case 236 -> 20;
                    case 237 -> 38;
                    case 238 -> 69;
                    case 239 -> 97;
                    case 240 -> 129;
                    case 241 -> 132;
                    case 242 -> 25;
                    case 243 -> 48;
                    case 244 -> 120;
                    case 245 -> 19;
                    case 246 -> 58;
                    case 247 -> 80;
                    case 248 -> 76;
                    case 249 -> 123;
                    case 250 -> 138;
                    case 251 -> 223;
                    case 252 -> 88;
                    case 253 -> 128;
                    case 254 -> 225;
                    default -> 86;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 120700270377523L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = ",~}t\u001e~ou\t+tn~S<ri2";
                    var5_4 = ",~}t\u001e~ou\t+tn~S<ri2".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 97;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 38;
                                    break;
                                }
                                case 1: {
                                    v11 = 122;
                                    break;
                                }
                                case 2: {
                                    v11 = 110;
                                    break;
                                }
                                case 3: {
                                    v11 = 123;
                                    break;
                                }
                                case 4: {
                                    v11 = 26;
                                    break;
                                }
                                case 5: {
                                    v11 = 115;
                                    break;
                                }
                                default: {
                                    v11 = 61;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 83701362246985L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "t\u0011Y\u0017OV)\u0004r\u000fU\r\n~\u0010^\rCT1T\u0011W\t~\u0010^\rCT1X\u001b\ry\u0016C\u0000IY+X\u001cD\nHP";
                    var5_4 = "t\u0011Y\u0017OV)\u0004r\u000fU\r\n~\u0010^\rCT1T\u0011W\t~\u0010^\rCT1X\u001b\ry\u0016C\u0000IY+X\u001cD\nHP".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 94;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "]0|3lz\u0001\u0006]0|3`p";
                        var5_4 = "]0|3lz\u0001\u0006]0|3`p".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 125;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 99;
                                break;
                            }
                            case 1: {
                                v15 = 33;
                                break;
                            }
                            case 2: {
                                v15 = 110;
                                break;
                            }
                            case 3: {
                                v15 = 61;
                                break;
                            }
                            case 4: {
                                v15 = 120;
                                break;
                            }
                            case 5: {
                                v15 = 105;
                                break;
                            }
                            default: {
                                v15 = 27;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 135304190892975L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-163837500 - -8857, 163837500 - 5958, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 125175914522039L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u009aUm\u00f8\u00e7\u0003\u0001\u0087\u00aa\u0005\u007f3\u00f7\u00f0W\r$\u00e7\u00aa \t\u00026fEp:\u0093\u00c6\u0010\u0099_\u00da\u00dc8\b;\u001a-{\u00d4\u00bf\u00fd\u001f\u001d\u00ff\u0005\u009c\"\u008b\u00d2\u00d83,\u0083\u008c\u0091'\u00e5\u00e8\u00b3*\u00b3\u00bf\u008fVHD\n\u00c8i\u00b3\u0010\u00b9\u00f1\u00ca\u00ab\f\u00d2e*\u009c\u00f6\u00ec%\u00f5a\u00f9\u0001L\u00b5\u00b9\u0003\u0015U\u0089\u00ebbp\u00eb\u00e1\t\u0006[";
                    var4_3 = "\u009aUm\u00f8\u00e7\u0003\u0001\u0087\u00aa\u0005\u007f3\u00f7\u00f0W\r$\u00e7\u00aa \t\u00026fEp:\u0093\u00c6\u0010\u0099_\u00da\u00dc8\b;\u001a-{\u00d4\u00bf\u00fd\u001f\u001d\u00ff\u0005\u009c\"\u008b\u00d2\u00d83,\u0083\u008c\u0091'\u00e5\u00e8\u00b3*\u00b3\u00bf\u008fVHD\n\u00c8i\u00b3\u0010\u00b9\u00f1\u00ca\u00ab\f\u00d2e*\u009c\u00f6\u00ec%\u00f5a\u00f9\u0001L\u00b5\u00b9\u0003\u0015U\u0089\u00ebbp\u00eb\u00e1\t\u0006[".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 63;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "`\u0099h\u0089\u00e3/\u00cds~\u00db3&\u008c\u00a1\u00be\u00a5LJ_\u00da\u009b\u009f\u00a5,L\u00cb\u00af)\u0011\u00c1\u00c9\u0084\u00d1XN\u00d3\u008fP\u00ebP\u00c7\u00f19r\u001c\t\u00f4<\u0087rV\u00f5vr\b\u00c9_\u00a0\u00ae}dd\u00d2m\u0000\u00a6\u0083\u00cbt\u0006R\u008f\u008e\u00c5\u00ce\u00bc\u00a6W\u0089\u00e3Dr\u00b7\u0017ll\u009dg\u008b\u00cb:\u00ac\u0096";
                        var4_3 = "`\u0099h\u0089\u00e3/\u00cds~\u00db3&\u008c\u00a1\u00be\u00a5LJ_\u00da\u009b\u009f\u00a5,L\u00cb\u00af)\u0011\u00c1\u00c9\u0084\u00d1XN\u00d3\u008fP\u00ebP\u00c7\u00f19r\u001c\t\u00f4<\u0087rV\u00f5vr\b\u00c9_\u00a0\u00ae}dd\u00d2m\u0000\u00a6\u0083\u00cbt\u0006R\u008f\u008e\u00c5\u00ce\u00bc\u00a6W\u0089\u00e3Dr\u00b7\u0017ll\u009dg\u008b\u00cb:\u00ac\u0096".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 51;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 61;
                                break;
                            }
                            case 1: {
                                v15 = 104;
                                break;
                            }
                            case 2: {
                                v15 = 105;
                                break;
                            }
                            case 3: {
                                v15 = 98;
                                break;
                            }
                            case 4: {
                                v15 = 2;
                                break;
                            }
                            case 5: {
                                v15 = 20;
                                break;
                            }
                            default: {
                                v15 = 115;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x37F2) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 148;
                    case 1 -> 11;
                    case 2 -> 160;
                    case 3 -> 192;
                    case 4 -> 191;
                    case 5 -> 51;
                    case 6 -> 65;
                    case 7 -> 167;
                    case 8 -> 234;
                    case 9 -> 183;
                    case 10 -> 59;
                    case 11 -> 202;
                    case 12 -> 114;
                    case 13 -> 120;
                    case 14 -> 8;
                    case 15 -> 174;
                    case 16 -> 70;
                    case 17 -> 27;
                    case 18 -> 52;
                    case 19 -> 66;
                    case 20 -> 123;
                    case 21 -> 246;
                    case 22 -> 94;
                    case 23 -> 86;
                    case 24 -> 3;
                    case 25 -> 203;
                    case 26 -> 68;
                    case 27 -> 54;
                    case 28 -> 24;
                    case 29 -> 109;
                    case 30 -> 145;
                    case 31 -> 249;
                    case 32 -> 235;
                    case 33 -> 2;
                    case 34 -> 53;
                    case 35 -> 4;
                    case 36 -> 23;
                    case 37 -> 105;
                    case 38 -> 38;
                    case 39 -> 112;
                    case 40 -> 224;
                    case 41 -> 157;
                    case 42 -> 90;
                    case 43 -> 146;
                    case 44 -> 205;
                    case 45 -> 116;
                    case 46 -> 137;
                    case 47 -> 37;
                    case 48 -> 93;
                    case 49 -> 152;
                    case 50 -> 190;
                    case 51 -> 82;
                    case 52 -> 198;
                    case 53 -> 165;
                    case 54 -> 122;
                    case 55 -> 162;
                    case 56 -> 208;
                    case 57 -> 97;
                    case 58 -> 177;
                    case 59 -> 124;
                    case 60 -> 110;
                    case 61 -> 48;
                    case 62 -> 34;
                    case 63 -> 168;
                    case 64 -> 159;
                    case 65 -> 182;
                    case 66 -> 67;
                    case 67 -> 149;
                    case 68 -> 133;
                    case 69 -> 181;
                    case 70 -> 56;
                    case 71 -> 209;
                    case 72 -> 121;
                    case 73 -> 74;
                    case 74 -> 28;
                    case 75 -> 169;
                    case 76 -> 243;
                    case 77 -> 69;
                    case 78 -> 44;
                    case 79 -> 134;
                    case 80 -> 171;
                    case 81 -> 29;
                    case 82 -> 218;
                    case 83 -> 245;
                    case 84 -> 81;
                    case 85 -> 32;
                    case 86 -> 241;
                    case 87 -> 26;
                    case 88 -> 87;
                    case 89 -> 61;
                    case 90 -> 50;
                    case 91 -> 73;
                    case 92 -> 185;
                    case 93 -> 117;
                    case 94 -> 219;
                    case 95 -> 129;
                    case 96 -> 184;
                    case 97 -> 72;
                    case 98 -> 255;
                    case 99 -> 222;
                    case 100 -> 103;
                    case 101 -> 118;
                    case 102 -> 230;
                    case 103 -> 253;
                    case 104 -> 211;
                    case 105 -> 33;
                    case 106 -> 41;
                    case 107 -> 125;
                    case 108 -> 231;
                    case 109 -> 20;
                    case 110 -> 62;
                    case 111 -> 136;
                    case 112 -> 12;
                    case 113 -> 60;
                    case 114 -> 22;
                    case 115 -> 188;
                    case 116 -> 13;
                    case 117 -> 175;
                    case 118 -> 63;
                    case 119 -> 179;
                    case 120 -> 140;
                    case 121 -> 170;
                    case 122 -> 161;
                    case 123 -> 19;
                    case 124 -> 250;
                    case 125 -> 78;
                    case 126 -> 113;
                    case 127 -> 142;
                    case 128 -> 212;
                    case 129 -> 108;
                    case 130 -> 186;
                    case 131 -> 143;
                    case 132 -> 106;
                    case 133 -> 153;
                    case 134 -> 64;
                    case 135 -> 242;
                    case 136 -> 147;
                    case 137 -> 141;
                    case 138 -> 214;
                    case 139 -> 215;
                    case 140 -> 158;
                    case 141 -> 156;
                    case 142 -> 172;
                    case 143 -> 132;
                    case 144 -> 16;
                    case 145 -> 220;
                    case 146 -> 204;
                    case 147 -> 71;
                    case 148 -> 138;
                    case 149 -> 229;
                    case 150 -> 35;
                    case 151 -> 95;
                    case 152 -> 96;
                    case 153 -> 126;
                    case 154 -> 39;
                    case 155 -> 6;
                    case 156 -> 217;
                    case 157 -> 166;
                    case 158 -> 5;
                    case 159 -> 92;
                    case 160 -> 194;
                    case 161 -> 101;
                    case 162 -> 163;
                    case 163 -> 49;
                    case 164 -> 144;
                    case 165 -> 130;
                    case 166 -> 213;
                    case 167 -> 226;
                    case 168 -> 10;
                    case 169 -> 207;
                    case 170 -> 80;
                    case 171 -> 115;
                    case 172 -> 98;
                    case 173 -> 154;
                    case 174 -> 232;
                    case 175 -> 236;
                    case 176 -> 193;
                    case 177 -> 104;
                    case 178 -> 178;
                    case 179 -> 155;
                    case 180 -> 75;
                    case 181 -> 7;
                    case 182 -> 1;
                    case 183 -> 99;
                    case 184 -> 189;
                    case 185 -> 30;
                    case 186 -> 223;
                    case 187 -> 238;
                    case 188 -> 131;
                    case 189 -> 107;
                    case 190 -> 58;
                    case 191 -> 88;
                    case 192 -> 199;
                    case 193 -> 79;
                    case 194 -> 150;
                    case 195 -> 180;
                    case 196 -> 252;
                    case 197 -> 47;
                    case 198 -> 76;
                    case 199 -> 139;
                    case 200 -> 239;
                    case 201 -> 151;
                    case 202 -> 196;
                    case 203 -> 83;
                    case 204 -> 18;
                    case 205 -> 43;
                    case 206 -> 25;
                    case 207 -> 227;
                    case 208 -> 195;
                    case 209 -> 31;
                    case 210 -> 254;
                    case 211 -> 89;
                    case 212 -> 216;
                    case 213 -> 127;
                    case 214 -> 128;
                    case 215 -> 173;
                    case 216 -> 164;
                    case 217 -> 91;
                    case 218 -> 197;
                    case 219 -> 57;
                    case 220 -> 228;
                    case 221 -> 45;
                    case 222 -> 55;
                    case 223 -> 210;
                    case 224 -> 187;
                    case 225 -> 225;
                    case 226 -> 233;
                    case 227 -> 36;
                    case 228 -> 247;
                    case 229 -> 17;
                    case 230 -> 9;
                    case 231 -> 248;
                    case 232 -> 100;
                    case 233 -> 40;
                    case 234 -> 21;
                    case 235 -> 244;
                    case 236 -> 84;
                    case 237 -> 119;
                    case 238 -> 15;
                    case 239 -> 14;
                    case 240 -> 42;
                    case 241 -> 237;
                    case 242 -> 77;
                    case 243 -> 206;
                    case 244 -> 135;
                    case 245 -> 111;
                    case 246 -> 102;
                    case 247 -> 176;
                    case 248 -> 240;
                    case 249 -> 85;
                    case 250 -> 221;
                    case 251 -> 201;
                    case 252 -> 0;
                    case 253 -> 200;
                    case 254 -> 251;
                    default -> 46;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 69625163172099L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(551673630 - 7446, 551673630 - 23362, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 87074091787555L;
                    String string = SshAgentIpcService.I();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(2075231310 - (char)-27099, -2075231310 - -((char)-11384), (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 34745367910431L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u008f\u00db\u0019\u00d7\u00ee\u0003\u0004\u001b>";
                var4_3 = "\u008f\u00db\u0019\u00d7\u00ee\u0003\u0004\u001b>".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 19;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 84;
                                break;
                            }
                            case 1: {
                                v11 = 59;
                                break;
                            }
                            case 2: {
                                v11 = 59;
                                break;
                            }
                            case 3: {
                                v11 = 95;
                                break;
                            }
                            case 4: {
                                v11 = 102;
                                break;
                            }
                            case 5: {
                                v11 = 30;
                                break;
                            }
                            default: {
                                v11 = 34;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8B0B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 219;
                    case 1 -> 111;
                    case 2 -> 59;
                    case 3 -> 243;
                    case 4 -> 1;
                    case 5 -> 139;
                    case 6 -> 9;
                    case 7 -> 123;
                    case 8 -> 64;
                    case 9 -> 255;
                    case 10 -> 51;
                    case 11 -> 153;
                    case 12 -> 84;
                    case 13 -> 4;
                    case 14 -> 135;
                    case 15 -> 175;
                    case 16 -> 195;
                    case 17 -> 117;
                    case 18 -> 63;
                    case 19 -> 30;
                    case 20 -> 88;
                    case 21 -> 149;
                    case 22 -> 107;
                    case 23 -> 124;
                    case 24 -> 34;
                    case 25 -> 76;
                    case 26 -> 126;
                    case 27 -> 215;
                    case 28 -> 27;
                    case 29 -> 62;
                    case 30 -> 45;
                    case 31 -> 145;
                    case 32 -> 129;
                    case 33 -> 184;
                    case 34 -> 223;
                    case 35 -> 169;
                    case 36 -> 221;
                    case 37 -> 97;
                    case 38 -> 106;
                    case 39 -> 238;
                    case 40 -> 152;
                    case 41 -> 69;
                    case 42 -> 36;
                    case 43 -> 160;
                    case 44 -> 209;
                    case 45 -> 239;
                    case 46 -> 48;
                    case 47 -> 82;
                    case 48 -> 202;
                    case 49 -> 244;
                    case 50 -> 164;
                    case 51 -> 138;
                    case 52 -> 246;
                    case 53 -> 254;
                    case 54 -> 220;
                    case 55 -> 28;
                    case 56 -> 89;
                    case 57 -> 216;
                    case 58 -> 177;
                    case 59 -> 39;
                    case 60 -> 75;
                    case 61 -> 8;
                    case 62 -> 19;
                    case 63 -> 236;
                    case 64 -> 95;
                    case 65 -> 71;
                    case 66 -> 16;
                    case 67 -> 233;
                    case 68 -> 167;
                    case 69 -> 101;
                    case 70 -> 235;
                    case 71 -> 222;
                    case 72 -> 170;
                    case 73 -> 229;
                    case 74 -> 17;
                    case 75 -> 118;
                    case 76 -> 227;
                    case 77 -> 61;
                    case 78 -> 198;
                    case 79 -> 217;
                    case 80 -> 234;
                    case 81 -> 207;
                    case 82 -> 87;
                    case 83 -> 3;
                    case 84 -> 203;
                    case 85 -> 147;
                    case 86 -> 241;
                    case 87 -> 142;
                    case 88 -> 50;
                    case 89 -> 94;
                    case 90 -> 158;
                    case 91 -> 143;
                    case 92 -> 240;
                    case 93 -> 116;
                    case 94 -> 56;
                    case 95 -> 130;
                    case 96 -> 120;
                    case 97 -> 110;
                    case 98 -> 24;
                    case 99 -> 180;
                    case 100 -> 187;
                    case 101 -> 119;
                    case 102 -> 193;
                    case 103 -> 210;
                    case 104 -> 231;
                    case 105 -> 109;
                    case 106 -> 13;
                    case 107 -> 79;
                    case 108 -> 29;
                    case 109 -> 140;
                    case 110 -> 165;
                    case 111 -> 41;
                    case 112 -> 199;
                    case 113 -> 154;
                    case 114 -> 58;
                    case 115 -> 125;
                    case 116 -> 73;
                    case 117 -> 11;
                    case 118 -> 192;
                    case 119 -> 157;
                    case 120 -> 204;
                    case 121 -> 151;
                    case 122 -> 132;
                    case 123 -> 65;
                    case 124 -> 85;
                    case 125 -> 197;
                    case 126 -> 37;
                    case 127 -> 128;
                    case 128 -> 0;
                    case 129 -> 5;
                    case 130 -> 121;
                    case 131 -> 237;
                    case 132 -> 98;
                    case 133 -> 251;
                    case 134 -> 20;
                    case 135 -> 133;
                    case 136 -> 249;
                    case 137 -> 173;
                    case 138 -> 47;
                    case 139 -> 181;
                    case 140 -> 174;
                    case 141 -> 156;
                    case 142 -> 113;
                    case 143 -> 23;
                    case 144 -> 245;
                    case 145 -> 93;
                    case 146 -> 112;
                    case 147 -> 155;
                    case 148 -> 218;
                    case 149 -> 185;
                    case 150 -> 104;
                    case 151 -> 108;
                    case 152 -> 191;
                    case 153 -> 196;
                    case 154 -> 114;
                    case 155 -> 224;
                    case 156 -> 77;
                    case 157 -> 38;
                    case 158 -> 100;
                    case 159 -> 33;
                    case 160 -> 134;
                    case 161 -> 122;
                    case 162 -> 189;
                    case 163 -> 162;
                    case 164 -> 43;
                    case 165 -> 74;
                    case 166 -> 212;
                    case 167 -> 6;
                    case 168 -> 66;
                    case 169 -> 15;
                    case 170 -> 201;
                    case 171 -> 14;
                    case 172 -> 232;
                    case 173 -> 72;
                    case 174 -> 200;
                    case 175 -> 182;
                    case 176 -> 44;
                    case 177 -> 228;
                    case 178 -> 22;
                    case 179 -> 211;
                    case 180 -> 226;
                    case 181 -> 194;
                    case 182 -> 172;
                    case 183 -> 31;
                    case 184 -> 49;
                    case 185 -> 46;
                    case 186 -> 42;
                    case 187 -> 10;
                    case 188 -> 205;
                    case 189 -> 208;
                    case 190 -> 67;
                    case 191 -> 12;
                    case 192 -> 144;
                    case 193 -> 250;
                    case 194 -> 53;
                    case 195 -> 137;
                    case 196 -> 148;
                    case 197 -> 127;
                    case 198 -> 171;
                    case 199 -> 18;
                    case 200 -> 54;
                    case 201 -> 136;
                    case 202 -> 146;
                    case 203 -> 213;
                    case 204 -> 70;
                    case 205 -> 176;
                    case 206 -> 188;
                    case 207 -> 115;
                    case 208 -> 206;
                    case 209 -> 102;
                    case 210 -> 60;
                    case 211 -> 40;
                    case 212 -> 32;
                    case 213 -> 2;
                    case 214 -> 80;
                    case 215 -> 163;
                    case 216 -> 252;
                    case 217 -> 21;
                    case 218 -> 225;
                    case 219 -> 166;
                    case 220 -> 230;
                    case 221 -> 26;
                    case 222 -> 150;
                    case 223 -> 55;
                    case 224 -> 99;
                    case 225 -> 178;
                    case 226 -> 159;
                    case 227 -> 96;
                    case 228 -> 253;
                    case 229 -> 68;
                    case 230 -> 248;
                    case 231 -> 78;
                    case 232 -> 242;
                    case 233 -> 105;
                    case 234 -> 247;
                    case 235 -> 57;
                    case 236 -> 35;
                    case 237 -> 190;
                    case 238 -> 168;
                    case 239 -> 90;
                    case 240 -> 86;
                    case 241 -> 183;
                    case 242 -> 83;
                    case 243 -> 25;
                    case 244 -> 52;
                    case 245 -> 161;
                    case 246 -> 7;
                    case 247 -> 141;
                    case 248 -> 179;
                    case 249 -> 91;
                    case 250 -> 131;
                    case 251 -> 103;
                    case 252 -> 186;
                    case 253 -> 92;
                    case 254 -> 81;
                    default -> 214;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

