/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation;

import com.intellij.lang.Language;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.generation.RagRefactoringListenerProvider;
import org.jetbrains.completion.full.line.local.generation.SimilarContextRetriever;
import org.jetbrains.completion.full.line.services.FullLineServiceScope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/RagRefactoringListenerProvider;", "Lcom/intellij/refactoring/listeners/RefactoringElementListenerProvider;", "<init>", "()V", "getListener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "element", "Lcom/intellij/psi/PsiElement;", "Listener", "intellij.fullLine.local"})
final class RagRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(@Nullable PsiElement element) {
        VirtualFile virtualFile;
        PsiFile file;
        if (element == null || element.getProject().isDisposed() || !element.isValid()) {
            return null;
        }
        PsiFile psiFile = file = element.getContainingFile();
        Object object = virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (virtualFile != null) {
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            if (SimilarContextRetriever.Companion.isEnabledFor(language)) {
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return new Listener(project, virtualFile);
            }
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/RagRefactoringListenerProvider$Listener;", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "project", "Lcom/intellij/openapi/project/Project;", "oldFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOldFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "elementMoved", "", "newElement", "Lcom/intellij/psi/PsiElement;", "elementRenamed", "intellij.fullLine.local"})
    @SourceDebugExtension(value={"SMAP\nRagRefactoringListenerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagRefactoringListenerProvider.kt\norg/jetbrains/completion/full/line/local/generation/RagRefactoringListenerProvider$Listener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
    private static final class Listener
    implements RefactoringElementListener {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile oldFile;

        public Listener(@NotNull Project project, @NotNull VirtualFile oldFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
            this.project = project;
            this.oldFile = oldFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getOldFile() {
            return this.oldFile;
        }

        public void elementMoved(@NotNull PsiElement newElement) {
            block2: {
                VirtualFile newFile;
                Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
                SimilarContextRetriever retriever = SimilarContextRetriever.Companion.getInstance(this.project);
                retriever.dropChunksCache(this.oldFile);
                VirtualFile virtualFile = this.oldFile.getParent();
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    retriever.dropDirCache(it);
                }
                Project project = newElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SimilarContextRetriever newRetriever = SimilarContextRetriever.Companion.getInstance(project);
                PsiFile psiFile = newElement.getContainingFile();
                Object object = newFile = psiFile != null ? psiFile.getVirtualFile() : null;
                if (newFile == null || Intrinsics.areEqual((Object)newFile, (Object)this.oldFile)) {
                    return;
                }
                newRetriever.dropChunksCache(newFile);
                VirtualFile virtualFile2 = newFile.getParent();
                if (virtualFile2 == null) break block2;
                VirtualFile it = virtualFile2;
                boolean bl = false;
                newRetriever.dropDirCache(it);
            }
        }

        public void elementRenamed(@NotNull PsiElement newElement) {
            Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
            if (newElement.getProject().isDisposed() || !newElement.isValid()) {
                return;
            }
            Project project = newElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BuildersKt.launch$default((CoroutineScope)FullLineServiceScope.fullLineProjectScope((Project)project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newElement, this, null){
                int label;
                final /* synthetic */ PsiElement $newElement;
                final /* synthetic */ Listener this$0;
                {
                    this.$newElement = $newElement;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.readAction(() -> elementRenamed.1.invokeSuspend$lambda$2(this.$newElement, this.this$0), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$2(PsiElement $newElement, Listener this$0) {
                    void $this$mapNotNullTo$iv$iv;
                    Project project = $newElement.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    SimilarContextRetriever retriever = SimilarContextRetriever.Companion.getInstance(project);
                    if (this$0.getProject().isDisposed() || !$newElement.isValid()) {
                        return Unit.INSTANCE;
                    }
                    Iterable $this$mapNotNull$iv = ReferencesSearch.search((PsiElement)$newElement).asIterable();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        PsiReference it = (PsiReference)element$iv$iv;
                        boolean bl2 = false;
                        PsiFile psiFile = it.getElement().getContainingFile();
                        if ((psiFile != null ? psiFile.getVirtualFile() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv : $this$forEach$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl = false;
                        retriever.dropDirCache(it);
                    }
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        }
    }
}

