/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangeParser<T extends DHEServerKeyExchangeMessage>
extends ServerKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion version;
    private final KeyExchangeAlgorithm keyExchangeAlgorithm;

    public DHEServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, KeyExchangeAlgorithm keyExchangeAlgorithm, Config config) {
        super(pointer, array, HandshakeMessageType.SERVER_KEY_EXCHANGE, version, config);
        this.version = version;
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
    }

    public DHEServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        this(pointer, array, version, null, config);
    }

    @Override
    protected void parseHandshakeMessageContent(DHEServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing DHEServerKeyExchangeMessage");
        this.parsepLength(msg);
        this.parseP(msg);
        this.parsegLength(msg);
        this.parseG(msg);
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
        if (this.keyExchangeAlgorithm == null || !this.keyExchangeAlgorithm.isAnon()) {
            if (this.isTLS12() || this.isDTLS12()) {
                this.parseSignatureAndHashAlgorithm(msg);
            }
            this.parseSignatureLength(msg);
            this.parseSignature(msg);
        }
    }

    protected void parseDheParams(T msg) {
        this.parsepLength((DHEServerKeyExchangeMessage)msg);
        this.parseP((DHEServerKeyExchangeMessage)msg);
        this.parsegLength((DHEServerKeyExchangeMessage)msg);
        this.parseG((DHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKeyLength((DHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((DHEServerKeyExchangeMessage)msg);
    }

    @Override
    protected T createHandshakeMessage() {
        return (T)new DHEServerKeyExchangeMessage();
    }

    private void parsepLength(DHEServerKeyExchangeMessage msg) {
        msg.setModulusLength(this.parseIntField(2));
        LOGGER.debug("pLength: " + msg.getModulusLength().getValue());
    }

    private void parseP(DHEServerKeyExchangeMessage msg) {
        msg.setModulus(this.parseByteArrayField((Integer)msg.getModulusLength().getValue()));
        LOGGER.debug("P: " + Arrays.toString((byte[])msg.getModulus().getValue()));
    }

    private void parsegLength(DHEServerKeyExchangeMessage msg) {
        msg.setGeneratorLength(this.parseIntField(2));
        LOGGER.debug("gLength: " + msg.getGeneratorLength().getValue());
    }

    private void parseG(DHEServerKeyExchangeMessage msg) {
        msg.setGenerator(this.parseByteArrayField((Integer)msg.getGeneratorLength().getValue()));
        LOGGER.debug("G: " + Arrays.toString((byte[])msg.getGenerator().getValue()));
    }

    private void parseSerializedPublicKeyLength(DHEServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("SerializedPublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(DHEServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }

    private boolean isTLS12() {
        return this.version == ProtocolVersion.TLS12;
    }

    private boolean isDTLS12() {
        return this.version == ProtocolVersion.DTLS12;
    }

    private void parseSignatureAndHashAlgorithm(DHEServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureAndHashAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureAndHashAlgorithm().getValue())));
    }

    private void parseSignatureLength(DHEServerKeyExchangeMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: " + msg.getSignatureLength().getValue());
    }

    private void parseSignature(DHEServerKeyExchangeMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signature: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignature().getValue())));
    }
}

