" Vim syntax file
" Language:     Cucumber
" Maintainer:   Tim Pope <vimNOSPAM@tpope.org>
" Filenames:    *.feature
" Last Change:	2023 Dec 28

if exists("b:current_syntax")
    finish
endif
let s:keepcpo= &cpo
set cpo&vim

syn case match
syn sync minlines=20

let g:cucumber_languages = {
      \"en": {"and": "And\\>", "background": "Background", "but": "But\\>", "examples": "Scenarios\\|Examples", "feature": "Business Need\\|Feature\\|Ability", "given": "Given\\>", "rule": "Rule", "scenario": "Scenario\\|Example", "scenario_outline": "Scenario Template\\|Scenario Outline", "then": "Then\\>", "when": "When\\>"},
      \"af": {"and": "En\\>", "background": "Agtergrond", "but": "Maar\\>", "examples": "Voorbeelde", "feature": "Besigheid Behoefte\\|Funksie\\|Vermo\\%u00eb", "given": "Gegewe\\>", "rule": "Regel", "scenario": "Voorbeeld\\|Situasie", "scenario_outline": "Situasie Uiteensetting", "then": "Dan\\>", "when": "Wanneer\\>"},
      \"am": {"and": "\\%u0535\\%u057e\\>", "background": "\\%u053f\\%u0578\\%u0576\\%u057f\\%u0565\\%u0584\\%u057d\\%u057f", "but": "\\%u0532\\%u0561\\%u0575\\%u0581\\>", "examples": "\\%u0555\\%u0580\\%u056b\\%u0576\\%u0561\\%u056f\\%u0576\\%u0565\\%u0580", "feature": "\\%u0556\\%u0578\\%u0582\\%u0576\\%u056f\\%u0581\\%u056b\\%u0578\\%u0576\\%u0561\\%u056c\\%u0578\\%u0582\\%u0569\\%u0575\\%u0578\\%u0582\\%u0576\\|\\%u0540\\%u0561\\%u057f\\%u056f\\%u0578\\%u0582\\%u0569\\%u0575\\%u0578\\%u0582\\%u0576", "given": "\\%u0534\\%u056b\\%u0581\\%u0578\\%u0582\\%u0584\\>", "rule": "Rule", "scenario": "\\%u0555\\%u0580\\%u056b\\%u0576\\%u0561\\%u056f\\|\\%u054d\\%u0581\\%u0565\\%u0576\\%u0561\\%u0580", "scenario_outline": "\\%u054d\\%u0581\\%u0565\\%u0576\\%u0561\\%u0580\\%u056b \\%u056f\\%u0561\\%u057c\\%u0578\\%u0582\\%u0581\\%u057e\\%u0561\\%u0581\\%u0584\\%u0568", "then": "\\%u0531\\%u057a\\%u0561\\>", "when": "\\%u0535\\%u0569\\%u0565\\>\\|\\%u0535\\%u0580\\%u0562\\>"},
      \"amh": {"and": "\\%u12a5\\%u1293\\>", "background": "\\%u1245\\%u12f5\\%u1218 \\%u1201\\%u1294\\%u1273\\|\\%u1218\\%u1290\\%u123b \\%u1200\\%u1233\\%u1265\\|\\%u1218\\%u1290\\%u123b", "but": "\\%u130d\\%u1295\\>", "examples": "\\%u121d\\%u1233\\%u120c\\%u12ce\\%u127d\\|\\%u1201\\%u1293\\%u1274\\%u12ce\\%u127d", "feature": "\\%u12e8\\%u121a\\%u1348\\%u1208\\%u1308\\%u12cd \\%u12f5\\%u122d\\%u130a\\%u1275\\|\\%u12e8\\%u1270\\%u1348\\%u1208\\%u1308\\%u12cd \\%u1235\\%u122b\\|\\%u1235\\%u122b", "given": "\\%u12e8\\%u1270\\%u1230\\%u1320\\>", "rule": "\\%u1205\\%u130d", "scenario": "\\%u121d\\%u1233\\%u120c\\|\\%u1201\\%u1293\\%u1274", "scenario_outline": "\\%u1201\\%u1293\\%u1274 \\%u12dd\\%u122d\\%u12dd\\%u122d\\|\\%u1201\\%u1293\\%u1274 \\%u12a0\\%u1265\\%u1290\\%u1275", "then": "\\%u12a8\\%u12da\\%u12eb\\>", "when": "\\%u1218\\%u127c\\>"},
      \"an": {"and": "Y\\>\\|E\\>", "background": "Antecedents", "but": "Pero\\>", "examples": "Eixemplos", "feature": "Caracteristica", "given": "Dadas\\>\\|Dada\\>\\|Daus\\>\\|Dau\\>", "rule": "Rule", "scenario": "Eixemplo\\|Caso", "scenario_outline": "Esquema del caso", "then": "Antonces\\>\\|Alavez\\>\\|Allora\\>", "when": "Cuan\\>"},
      \"ar": {"and": "\\%u0648\\>", "background": "\\%u0627\\%u0644\\%u062e\\%u0644\\%u0641\\%u064a\\%u0629", "but": "\\%u0644\\%u0643\\%u0646\\>", "examples": "\\%u0627\\%u0645\\%u062b\\%u0644\\%u0629", "feature": "\\%u062e\\%u0627\\%u0635\\%u064a\\%u0629", "given": "\\%u0628\\%u0641\\%u0631\\%u0636\\>", "rule": "Rule", "scenario": "\\%u0633\\%u064a\\%u0646\\%u0627\\%u0631\\%u064a\\%u0648\\|\\%u0645\\%u062b\\%u0627\\%u0644", "scenario_outline": "\\%u0633\\%u064a\\%u0646\\%u0627\\%u0631\\%u064a\\%u0648 \\%u0645\\%u062e\\%u0637\\%u0637", "then": "\\%u0627\\%u0630\\%u0627\\%u064b\\>\\|\\%u062b\\%u0645\\>", "when": "\\%u0639\\%u0646\\%u062f\\%u0645\\%u0627\\>\\|\\%u0645\\%u062a\\%u0649\\>"},
      \"ast": {"and": "Ya\\>\\|Y\\>", "background": "Antecedentes", "but": "Peru\\>", "examples": "Exemplos", "feature": "Carauter\\%u00edstica", "given": "Dada\\>\\|Daos\\>\\|Daes\\>\\|D\\%u00e1u\\>", "rule": "Rule", "scenario": "Exemplo\\|Casu", "scenario_outline": "Esbozu del casu", "then": "Ent\\%u00f3s\\>", "when": "Cuando\\>"},
      \"az": {"and": "H\\%u0259m\\>\\|V\\%u0259\\>", "background": "Kontekst\\|Ke\\%u00e7mi\\%u015f", "but": "Ancaq\\>\\|Amma\\>", "examples": "N\\%u00fcmun\\%u0259l\\%u0259r", "feature": "\\%u00d6z\\%u0259llik", "given": "Tutaq ki\\>\\|Verilir\\>", "rule": "Rule", "scenario": "Ssenari\\|N\\%u00fcmun\\%u0259", "scenario_outline": "Ssenarinin strukturu", "then": "O halda\\>", "when": "N\\%u0259 vaxt ki\\>\\|\\%u018fg\\%u0259r\\>"},
      \"bg": {"and": "\\%u0418\\>", "background": "\\%u041f\\%u0440\\%u0435\\%u0434\\%u0438\\%u0441\\%u0442\\%u043e\\%u0440\\%u0438\\%u044f", "but": "\\%u041d\\%u043e\\>", "examples": "\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440\\%u0438", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b\\%u043d\\%u043e\\%u0441\\%u0442", "given": "\\%u0414\\%u0430\\%u0434\\%u0435\\%u043d\\%u043e\\>", "rule": "\\%u041f\\%u0440\\%u0430\\%u0432\\%u0438\\%u043b\\%u043e", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440", "scenario_outline": "\\%u0420\\%u0430\\%u043c\\%u043a\\%u0430 \\%u043d\\%u0430 \\%u0441\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439", "then": "\\%u0422\\%u043e\\>", "when": "\\%u041a\\%u043e\\%u0433\\%u0430\\%u0442\\%u043e\\>"},
      \"bm": {"and": "Dan\\>", "background": "Latar Belakang", "but": "Tetapi\\>\\|Tapi\\>", "examples": "Contoh", "feature": "Fungsi", "given": "Diberi\\>\\|Bagi\\>", "rule": "Rule", "scenario": "Senario\\|Situasi\\|Keadaan", "scenario_outline": "Garis Panduan Senario\\|Kerangka Senario\\|Kerangka Situasi\\|Kerangka Keadaan", "then": "Kemudian\\>\\|Maka\\>", "when": "Apabila\\>"},
      \"bs": {"and": "I\\>\\|A\\>", "background": "Pozadina", "but": "Ali\\>", "examples": "Primjeri", "feature": "Karakteristika", "given": "Dato\\>", "rule": "Rule", "scenario": "Scenariju\\|Scenario\\|Primjer", "scenario_outline": "Scenario-outline\\|Scenariju-obris", "then": "Zatim\\>", "when": "Kada\\>"},
      \"ca": {"and": "I\\>", "background": "Antecedents\\|Rerefons", "but": "Per\\%u00f2\\>", "examples": "Exemples", "feature": "Caracter\\%u00edstica\\|Funcionalitat", "given": "Donada\\>\\|Donat\\>\\|Atesa\\>\\|At\\%u00e8s\\>", "rule": "Rule", "scenario": "Escenari\\|Exemple", "scenario_outline": "Esquema de l'escenari", "then": "Aleshores\\>\\|Cal\\>", "when": "Quan\\>"},
      \"cs": {"and": "A tak\\%u00e9\\>\\|A\\>", "background": "Kontext\\|Pozad\\%u00ed", "but": "Ale\\>", "examples": "P\\%u0159\\%u00edklady", "feature": "Po\\%u017eadavek", "given": "Za p\\%u0159edpokladu\\>\\|Pokud\\>", "rule": "Pravidlo", "scenario": "P\\%u0159\\%u00edklad\\|Sc\\%u00e9n\\%u00e1\\%u0159", "scenario_outline": "Osnova sc\\%u00e9n\\%u00e1\\%u0159e\\|N\\%u00e1\\%u010drt Sc\\%u00e9n\\%u00e1\\%u0159e", "then": "Pak\\>", "when": "Kdy\\%u017e\\>"},
      \"cy-GB": {"and": "A\\>", "background": "Cefndir", "but": "Ond\\>", "examples": "Enghreifftiau", "feature": "Arwedd", "given": "Anrhegedig a\\>", "rule": "Rule", "scenario": "Enghraifft\\|Scenario", "scenario_outline": "Scenario Amlinellol", "then": "Yna\\>", "when": "Pryd\\>"},
      \"da": {"and": "Og\\>", "background": "Baggrund", "but": "Men\\>", "examples": "Eksempler", "feature": "Egenskab", "given": "Givet\\>", "rule": "Rule", "scenario": "Eksempel\\|Scenarie", "scenario_outline": "Abstrakt Scenario", "then": "S\\%u00e5\\>", "when": "N\\%u00e5r\\>"},
      \"de": {"and": "Und\\>", "background": "Voraussetzungen\\|Vorbedingungen\\|Hintergrund\\|Grundlage", "but": "Aber\\>", "examples": "Beispiele", "feature": "Funktionalit\\%u00e4t\\|Funktion", "given": "Gegeben seien\\>\\|Gegeben sei\\>\\|Angenommen\\>", "rule": "Regel\\|Rule", "scenario": "Beispiel\\|Szenario", "scenario_outline": "Szenariogrundriss\\|Szenarien", "then": "Dann\\>", "when": "Wenn\\>"},
      \"el": {"and": "\\%u039a\\%u03b1\\%u03b9\\>", "background": "\\%u03a5\\%u03c0\\%u03cc\\%u03b2\\%u03b1\\%u03b8\\%u03c1\\%u03bf", "but": "\\%u0391\\%u03bb\\%u03bb\\%u03ac\\>", "examples": "\\%u03a0\\%u03b1\\%u03c1\\%u03b1\\%u03b4\\%u03b5\\%u03af\\%u03b3\\%u03bc\\%u03b1\\%u03c4\\%u03b1\\|\\%u03a3\\%u03b5\\%u03bd\\%u03ac\\%u03c1\\%u03b9\\%u03b1", "feature": "\\%u0394\\%u03c5\\%u03bd\\%u03b1\\%u03c4\\%u03cc\\%u03c4\\%u03b7\\%u03c4\\%u03b1\\|\\%u039b\\%u03b5\\%u03b9\\%u03c4\\%u03bf\\%u03c5\\%u03c1\\%u03b3\\%u03af\\%u03b1", "given": "\\%u0394\\%u03b5\\%u03b4\\%u03bf\\%u03bc\\%u03ad\\%u03bd\\%u03bf\\%u03c5\\>", "rule": "Rule", "scenario": "\\%u03a0\\%u03b1\\%u03c1\\%u03ac\\%u03b4\\%u03b5\\%u03b9\\%u03b3\\%u03bc\\%u03b1\\|\\%u03a3\\%u03b5\\%u03bd\\%u03ac\\%u03c1\\%u03b9\\%u03bf", "scenario_outline": "\\%u03a0\\%u03b5\\%u03c1\\%u03af\\%u03b3\\%u03c1\\%u03b1\\%u03bc\\%u03bc\\%u03b1 \\%u03a3\\%u03b5\\%u03bd\\%u03b1\\%u03c1\\%u03af\\%u03bf\\%u03c5\\|\\%u03a0\\%u03b5\\%u03c1\\%u03b9\\%u03b3\\%u03c1\\%u03b1\\%u03c6\\%u03ae \\%u03a3\\%u03b5\\%u03bd\\%u03b1\\%u03c1\\%u03af\\%u03bf\\%u03c5", "then": "\\%u03a4\\%u03cc\\%u03c4\\%u03b5\\>", "when": "\\%u038c\\%u03c4\\%u03b1\\%u03bd\\>"},
      \"em": {"and": "\\%u1f602", "background": "\\%u1f4a4", "but": "\\%u1f614", "examples": "\\%u1f4d3", "feature": "\\%u1f4da", "given": "\\%u1f610", "rule": "Rule", "scenario": "\\%u1f952\\|\\%u1f4d5", "scenario_outline": "\\%u1f4d6", "then": "\\%u1f64f", "when": "\\%u1f3ac"},
      \"en-Scouse": {"and": "An\\>", "background": "Dis is what went down", "but": "Buh\\>", "examples": "Examples", "feature": "Feature", "given": "Youse know when youse got\\>\\|Givun\\>", "rule": "Rule", "scenario": "The thing of it is", "scenario_outline": "Wharrimean is", "then": "Den youse gotta\\>\\|Dun\\>", "when": "Youse know like when\\>\\|Wun\\>"},
      \"en-au": {"and": "Too right\\>", "background": "First off", "but": "Yeah nah\\>", "examples": "You'll wanna", "feature": "Pretty much", "given": "Y'know\\>", "rule": "Rule", "scenario": "Awww, look mate", "scenario_outline": "Reckon it's like", "then": "But at the end of the day I reckon\\>", "when": "It's just unbelievable\\>"},
      \"en-lol": {"and": "AN\\>", "background": "B4", "but": "BUT\\>", "examples": "EXAMPLZ", "feature": "OH HAI", "given": "I CAN HAZ\\>", "rule": "Rule", "scenario": "MISHUN", "scenario_outline": "MISHUN SRSLY", "then": "DEN\\>", "when": "WEN\\>"},
      \"en-old": {"and": "Ond\\>\\|7\\>", "background": "Aer\\|\\%u00c6r", "but": "Ac\\>", "examples": "Se the\\|Se \\%u00fee\\|Se \\%u00f0e", "feature": "Hwaet\\|Hw\\%u00e6t", "given": "Thurh\\>\\|\\%u00deurh\\>\\|\\%u00d0urh\\>", "rule": "Rule", "scenario": "Swa", "scenario_outline": "Swa hwaer swa\\|Swa hw\\%u00e6r swa", "then": "Tha the\\>\\|\\%u00dea \\%u00fee\\>\\|\\%u00d0a \\%u00f0e\\>\\|Tha\\>\\|\\%u00dea\\>\\|\\%u00d0a\\>", "when": "B\\%u00e6\\%u00fesealfa\\>\\|B\\%u00e6\\%u00fesealfe\\>\\|B\\%u00e6\\%u00fesealf\\>\\|Ciric\\%u00e6we\\>\\|Ciric\\%u00e6wa\\>\\|Ciric\\%u00e6w\\>"},
      \"en-pirate": {"and": "Aye\\>", "background": "Yo-ho-ho", "but": "Avast!\\>", "examples": "Dead men tell no tales", "feature": "Ahoy matey!", "given": "Gangway!\\>", "rule": "Rule", "scenario": "Heave to", "scenario_outline": "Shiver me timbers", "then": "Let go and haul\\>", "when": "Blimey!\\>"},
      \"en-tx": {"and": "Come hell or high water\\>", "background": "Lemme tell y'all a story", "but": "Well now hold on, I'll you what\\>", "examples": "Now that's a story longer than a cattle drive in July", "feature": "This ain\\%u2019t my first rodeo\\|All gussied up", "given": "All git out\\>\\|Fixin' to\\>", "rule": "Rule\\>", "scenario": "All hat and no cattle", "scenario_outline": "Busy as a hound in flea season\\|Serious as a snake bite", "then": "There\\%u2019s no tree but bears some fruit\\>", "when": "Quick out of the chute\\>"},
      \"eo": {"and": "Kaj\\>", "background": "Fono", "but": "Sed\\>", "examples": "Ekzemploj", "feature": "Trajto", "given": "Donita\\%u0135o\\>\\|Komence\\>", "rule": "Rule", "scenario": "Ekzemplo\\|Scenaro\\|Kazo", "scenario_outline": "Konturo de la scenaro\\|Kazo-skizo\\|Skizo", "then": "Do\\>", "when": "Se\\>"},
      \"es": {"and": "Y\\>\\|E\\>", "background": "Antecedentes", "but": "Pero\\>", "examples": "Ejemplos", "feature": "Necesidad del negocio\\|Caracter\\%u00edstica\\|Requisito", "given": "Dados\\>\\|Dadas\\>\\|Dado\\>\\|Dada\\>", "rule": "Regla de negocio\\|Regla", "scenario": "Escenario\\|Ejemplo", "scenario_outline": "Esquema del escenario", "then": "Entonces\\>", "when": "Cuando\\>"},
      \"et": {"and": "Ja\\>", "background": "Taust", "but": "Kuid\\>", "examples": "Juhtumid", "feature": "Omadus", "given": "Eeldades\\>", "rule": "Reegel", "scenario": "Stsenaarium\\|Juhtum", "scenario_outline": "Raamstsenaarium\\|Raamjuhtum", "then": "Siis\\>", "when": "Kui\\>"},
      \"fa": {"and": "\\%u0648\\>", "background": "\\%u0632\\%u0645\\%u06cc\\%u0646\\%u0647", "but": "\\%u0627\\%u0645\\%u0627\\>", "examples": "\\%u0646\\%u0645\\%u0648\\%u0646\\%u0647 \\%u0647\\%u0627", "feature": "\\%u0648\\%u0650\\%u06cc\\%u0698\\%u06af\\%u06cc", "given": "\\%u0628\\%u0627 \\%u0641\\%u0631\\%u0636\\>", "rule": "Rule", "scenario": "\\%u0633\\%u0646\\%u0627\\%u0631\\%u06cc\\%u0648\\|\\%u0645\\%u062b\\%u0627\\%u0644", "scenario_outline": "\\%u0627\\%u0644\\%u06af\\%u0648\\%u06cc \\%u0633\\%u0646\\%u0627\\%u0631\\%u06cc\\%u0648", "then": "\\%u0622\\%u0646\\%u06af\\%u0627\\%u0647\\>", "when": "\\%u0647\\%u0646\\%u06af\\%u0627\\%u0645\\%u06cc\\>"},
      \"fi": {"and": "Ja\\>", "background": "Tausta", "but": "Mutta\\>", "examples": "Tapaukset", "feature": "Ominaisuus", "given": "Oletetaan\\>", "rule": "Rule", "scenario": "Tapaus", "scenario_outline": "Tapausaihio", "then": "Niin\\>", "when": "Kun\\>"},
      \"fr": {"and": "Et que\\>\\|Et qu'\\|Et\\>", "background": "Contexte", "but": "Mais que\\>\\|Mais qu'\\|Mais\\>", "examples": "Exemples", "feature": "Fonctionnalit\\%u00e9", "given": "Etant donn\\%u00e9 que\\>\\|\\%u00c9tant donn\\%u00e9 que\\>\\|Etant donn\\%u00e9 qu'\\|\\%u00c9tant donn\\%u00e9 qu'\\|Etant donn\\%u00e9es\\>\\|\\%u00c9tant donn\\%u00e9es\\>\\|Etant donn\\%u00e9e\\>\\|Etant donn\\%u00e9s\\>\\|\\%u00c9tant donn\\%u00e9e\\>\\|\\%u00c9tant donn\\%u00e9s\\>\\|Sachant que\\>\\|Etant donn\\%u00e9\\>\\|\\%u00c9tant donn\\%u00e9\\>\\|Sachant qu'\\|Sachant\\>\\|Soit\\>", "rule": "R\\%u00e8gle", "scenario": "Sc\\%u00e9nario\\|Exemple", "scenario_outline": "Plan du sc\\%u00e9nario\\|Plan du Sc\\%u00e9nario", "then": "Alors\\>\\|Donc\\>", "when": "Lorsque\\>\\|Lorsqu'\\|Quand\\>"},
      \"ga": {"and": "Agus", "background": "C\\%u00falra", "but": "Ach", "examples": "Sampla\\%u00ed", "feature": "Gn\\%u00e9", "given": "Cuir i gc\\%u00e1s nach\\|Cuir i gc\\%u00e1s gur\\|Cuir i gc\\%u00e1s n\\%u00e1r\\|Cuir i gc\\%u00e1s go", "rule": "Rule", "scenario": "Sampla\\|C\\%u00e1s", "scenario_outline": "C\\%u00e1s Achomair", "then": "Ansin", "when": "Nuair nach\\|Nuair n\\%u00e1r\\|Nuair ba\\|Nuair a"},
      \"gj": {"and": "\\%u0a85\\%u0aa8\\%u0ac7\\>", "background": "\\%u0aac\\%u0ac7\\%u0a95\\%u0a97\\%u0acd\\%u0ab0\\%u0abe\\%u0a89\\%u0aa8\\%u0acd\\%u0aa1", "but": "\\%u0aaa\\%u0aa3\\>", "examples": "\\%u0a89\\%u0aa6\\%u0abe\\%u0ab9\\%u0ab0\\%u0aa3\\%u0acb", "feature": "\\%u0ab5\\%u0acd\\%u0aaf\\%u0abe\\%u0aaa\\%u0abe\\%u0ab0 \\%u0a9c\\%u0ab0\\%u0ac2\\%u0ab0\\|\\%u0a95\\%u0acd\\%u0ab7\\%u0aae\\%u0aa4\\%u0abe\\|\\%u0ab2\\%u0a95\\%u0acd\\%u0ab7\\%u0aa3", "given": "\\%u0a86\\%u0aaa\\%u0ac7\\%u0ab2 \\%u0a9b\\%u0ac7\\>", "rule": "Rule", "scenario": "\\%u0a89\\%u0aa6\\%u0abe\\%u0ab9\\%u0ab0\\%u0aa3\\|\\%u0ab8\\%u0acd\\%u0aa5\\%u0abf\\%u0aa4\\%u0abf", "scenario_outline": "\\%u0aaa\\%u0ab0\\%u0abf\\%u0aa6\\%u0acd\\%u0aa6\\%u0ab6\\%u0acd\\%u0aaf \\%u0ab0\\%u0ac2\\%u0aaa\\%u0ab0\\%u0ac7\\%u0a96\\%u0abe\\|\\%u0aaa\\%u0ab0\\%u0abf\\%u0aa6\\%u0acd\\%u0aa6\\%u0ab6\\%u0acd\\%u0aaf \\%u0aa2\\%u0abe\\%u0a82\\%u0a9a\\%u0acb", "then": "\\%u0aaa\\%u0a9b\\%u0ac0\\>", "when": "\\%u0a95\\%u0acd\\%u0aaf\\%u0abe\\%u0ab0\\%u0ac7\\>"},
      \"gl": {"and": "E\\>", "background": "Contexto", "but": "Mais\\>\\|Pero\\>", "examples": "Exemplos", "feature": "Caracter\\%u00edstica", "given": "Dados\\>\\|Dadas\\>\\|Dado\\>\\|Dada\\>", "rule": "Rule", "scenario": "Escenario\\|Exemplo", "scenario_outline": "Esbozo do escenario", "then": "Ent\\%u00f3n\\>\\|Logo\\>", "when": "Cando\\>"},
      \"he": {"and": "\\%u05d5\\%u05d2\\%u05dd\\>", "background": "\\%u05e8\\%u05e7\\%u05e2", "but": "\\%u05d0\\%u05d1\\%u05dc\\>", "examples": "\\%u05d3\\%u05d5\\%u05d2\\%u05de\\%u05d0\\%u05d5\\%u05ea", "feature": "\\%u05ea\\%u05db\\%u05d5\\%u05e0\\%u05d4", "given": "\\%u05d1\\%u05d4\\%u05d9\\%u05e0\\%u05ea\\%u05df\\>", "rule": "\\%u05db\\%u05dc\\%u05dc", "scenario": "\\%u05d3\\%u05d5\\%u05d2\\%u05de\\%u05d0\\|\\%u05ea\\%u05e8\\%u05d7\\%u05d9\\%u05e9", "scenario_outline": "\\%u05ea\\%u05d1\\%u05e0\\%u05d9\\%u05ea \\%u05ea\\%u05e8\\%u05d7\\%u05d9\\%u05e9", "then": "\\%u05d0\\%u05d6\\%u05d9\\>\\|\\%u05d0\\%u05d6\\>", "when": "\\%u05db\\%u05d0\\%u05e9\\%u05e8\\>"},
      \"hi": {"and": "\\%u0924\\%u0925\\%u093e\\>\\|\\%u0914\\%u0930\\>", "background": "\\%u092a\\%u0943\\%u0937\\%u094d\\%u0920\\%u092d\\%u0942\\%u092e\\%u093f", "but": "\\%u092a\\%u0930\\%u0928\\%u094d\\%u0924\\%u0941\\>\\|\\%u0915\\%u093f\\%u0928\\%u094d\\%u0924\\%u0941\\>\\|\\%u092a\\%u0930\\>", "examples": "\\%u0909\\%u0926\\%u093e\\%u0939\\%u0930\\%u0923", "feature": "\\%u0930\\%u0942\\%u092a \\%u0932\\%u0947\\%u0916", "given": "\\%u091a\\%u0942\\%u0902\\%u0915\\%u093f\\>\\|\\%u0905\\%u0917\\%u0930\\>\\|\\%u092f\\%u0926\\%u093f\\>", "rule": "\\%u0928\\%u093f\\%u092f\\%u092e", "scenario": "\\%u092a\\%u0930\\%u093f\\%u0926\\%u0943\\%u0936\\%u094d\\%u092f", "scenario_outline": "\\%u092a\\%u0930\\%u093f\\%u0926\\%u0943\\%u0936\\%u094d\\%u092f \\%u0930\\%u0942\\%u092a\\%u0930\\%u0947\\%u0916\\%u093e", "then": "\\%u0924\\%u0926\\%u093e\\>\\|\\%u0924\\%u092c\\>", "when": "\\%u0915\\%u0926\\%u093e\\>\\|\\%u091c\\%u092c\\>"},
      \"hr": {"and": "I\\>", "background": "Pozadina", "but": "Ali\\>", "examples": "Scenariji\\|Primjeri", "feature": "Mogu\\%u0107nost\\|Mogucnost\\|Osobina", "given": "Ukoliko\\>\\|Zadani\\>\\|Zadano\\>\\|Zadan\\>", "rule": "Rule", "scenario": "Scenarij\\|Primjer", "scenario_outline": "Koncept\\|Skica", "then": "Onda\\>", "when": "Kada\\>\\|Kad\\>"},
      \"ht": {"and": "Epi\\>\\|Ak\\>\\|E\\>", "background": "Kont\\%u00e8ks\\|Istorik", "but": "Men\\>", "examples": "Egzanp", "feature": "Karakteristik\\|Fonksyonalite\\|Mak", "given": "Sipoze ke\\>\\|Sipoze Ke\\>\\|Sipoze\\>", "rule": "Rule", "scenario": "Senaryo", "scenario_outline": "Senaryo deskripsyon\\|Senaryo Deskripsyon\\|Dyagram senaryo\\|Dyagram Senaryo\\|Plan senaryo\\|Plan Senaryo", "then": "L\\%u00e8 sa a\\>\\|Le sa a\\>", "when": "L\\%u00e8\\>\\|Le\\>"},
      \"hu": {"and": "\\%u00c9s\\>", "background": "H\\%u00e1tt\\%u00e9r", "but": "De\\>", "examples": "P\\%u00e9ld\\%u00e1k", "feature": "Jellemz\\%u0151", "given": "Amennyiben\\>\\|Adott\\>", "rule": "Szab\\%u00e1ly", "scenario": "Forgat\\%u00f3k\\%u00f6nyv\\|P\\%u00e9lda", "scenario_outline": "Forgat\\%u00f3k\\%u00f6nyv v\\%u00e1zlat", "then": "Akkor\\>", "when": "Amikor\\>\\|Majd\\>\\|Ha\\>"},
      \"id": {"and": "Dan\\>", "background": "Latar Belakang\\|Dasar", "but": "Tetapi\\>\\|Tapi\\>", "examples": "Contoh\\|Misal", "feature": "Fitur", "given": "Diasumsikan\\>\\|Diketahui\\>\\|Dengan\\>\\|Bila\\>\\|Jika\\>", "rule": "Aturan\\|Rule", "scenario": "Skenario", "scenario_outline": "Garis-Besar Skenario\\|Skenario konsep", "then": "Kemudian\\>\\|Maka\\>", "when": "Ketika\\>"},
      \"is": {"and": "Og\\>", "background": "Bakgrunnur", "but": "En\\>", "examples": "Atbur\\%u00f0ar\\%u00e1sir\\|D\\%u00e6mi", "feature": "Eiginleiki", "given": "Ef\\>", "rule": "Rule", "scenario": "Atbur\\%u00f0ar\\%u00e1s", "scenario_outline": "L\\%u00fdsing Atbur\\%u00f0ar\\%u00e1sar\\|L\\%u00fdsing D\\%u00e6ma", "then": "\\%u00de\\%u00e1\\>", "when": "\\%u00deegar\\>"},
      \"it": {"and": "E\\>", "background": "Contesto", "but": "Ma\\>", "examples": "Esempi", "feature": "Esigenza di Business\\|Funzionalit\\%u00e0\\|Abilit\\%u00e0", "given": "Dato\\>\\|Data\\>\\|Dati\\>\\|Date\\>", "rule": "Regola", "scenario": "Scenario\\|Esempio", "scenario_outline": "Schema dello scenario", "then": "Allora\\>", "when": "Quando\\>"},
      \"ja": {"and": "\\%u4e14\\%u3064\\|\\%u304b\\%u3064", "background": "\\%u80cc\\%u666f", "but": "\\%u3057\\%u304b\\%u3057\\|\\%u305f\\%u3060\\%u3057\\|\\%u7136\\%u3057\\|\\%u4f46\\%u3057", "examples": "\\%u30b5\\%u30f3\\%u30d7\\%u30eb\\|\\%u4f8b", "feature": "\\%u30d5\\%u30a3\\%u30fc\\%u30c1\\%u30e3\\|\\%u6a5f\\%u80fd", "given": "\\%u524d\\%u63d0", "rule": "\\%u30eb\\%u30fc\\%u30eb", "scenario": "\\%u30b7\\%u30ca\\%u30ea\\%u30aa", "scenario_outline": "\\%u30b7\\%u30ca\\%u30ea\\%u30aa\\%u30a2\\%u30a6\\%u30c8\\%u30e9\\%u30a4\\%u30f3\\|\\%u30b7\\%u30ca\\%u30ea\\%u30aa\\%u30c6\\%u30f3\\%u30d7\\%u30ec\\%u30fc\\%u30c8\\|\\%u30b7\\%u30ca\\%u30ea\\%u30aa\\%u30c6\\%u30f3\\%u30d7\\%u30ec\\|\\%u30c6\\%u30f3\\%u30d7\\%u30ec", "then": "\\%u306a\\%u3089\\%u3070", "when": "\\%u3082\\%u3057"},
      \"jv": {"and": "Lan\\>", "background": "Dasar", "but": "Ananging\\>\\|Nanging\\>\\|Tapi\\>", "examples": "Contone\\|Conto", "feature": "Fitur", "given": "Nalikaning\\>\\|Nalika\\>", "rule": "Rule", "scenario": "Skenario", "scenario_outline": "Konsep skenario", "then": "Banjur\\>\\|Njuk\\>", "when": "Manawa\\>\\|Menawa\\>"},
      \"ka": {"and": "\\%u10d0\\%u10e1\\%u10d4\\%u10d5\\%u10d4\\>\\|\\%u10d3\\%u10d0\\>", "background": "\\%u10d9\\%u10dd\\%u10dc\\%u10e2\\%u10d4\\%u10e5\\%u10e1\\%u10e2\\%u10d8", "but": "\\%u10db\\%u10d0\\%u10d2\\%u10e0\\%u10d0\\%u10db\\>\\|\\%u10d7\\%u10e3\\%u10db\\%u10ea\\%u10d0\\>", "examples": "\\%u10db\\%u10d0\\%u10d2\\%u10d0\\%u10da\\%u10d8\\%u10d7\\%u10d4\\%u10d1\\%u10d8", "feature": "\\%u10db\\%u10dd\\%u10d7\\%u10ee\\%u10dd\\%u10d5\\%u10dc\\%u10d0\\|\\%u10d7\\%u10d5\\%u10d8\\%u10e1\\%u10d4\\%u10d1\\%u10d0", "given": "\\%u10db\\%u10dd\\%u10ea\\%u10d4\\%u10db\\%u10e3\\%u10da\\%u10d8\\%u10d0\\>\\|\\%u10db\\%u10dd\\%u10ea\\%u10d4\\%u10db\\%u10e3\\%u10da\\%u10d8\\>\\|\\%u10d5\\%u10d7\\%u10e5\\%u10d5\\%u10d0\\%u10d7\\>", "rule": "\\%u10ec\\%u10d4\\%u10e1\\%u10d8", "scenario": "\\%u10db\\%u10d0\\%u10d2\\%u10d0\\%u10da\\%u10d8\\%u10d7\\%u10d0\\%u10d3\\|\\%u10db\\%u10d0\\%u10d2\\%u10d0\\%u10da\\%u10d8\\%u10d7\\%u10d8\\|\\%u10e1\\%u10ea\\%u10d4\\%u10dc\\%u10d0\\%u10e0\\%u10d8\\|\\%u10db\\%u10d0\\%u10d2", "scenario_outline": "\\%u10e1\\%u10ea\\%u10d4\\%u10dc\\%u10d0\\%u10e0\\%u10d8\\%u10e1 \\%u10e8\\%u10d0\\%u10d1\\%u10da\\%u10dd\\%u10dc\\%u10d8\\|\\%u10e1\\%u10ea\\%u10d4\\%u10dc\\%u10d0\\%u10e0\\%u10d8\\%u10e1 \\%u10dc\\%u10d8\\%u10db\\%u10e3\\%u10e8\\%u10d8\\|\\%u10e8\\%u10d0\\%u10d1\\%u10da\\%u10dd\\%u10dc\\%u10d8\\|\\%u10dc\\%u10d8\\%u10db\\%u10e3\\%u10e8\\%u10d8", "then": "\\%u10db\\%u10d0\\%u10e8\\%u10d8\\%u10dc\\>", "when": "\\%u10e0\\%u10dd\\%u10d2\\%u10dd\\%u10e0\\%u10ea \\%u10d9\\%u10d8\\>\\|\\%u10e0\\%u10dd\\%u10d3\\%u10d4\\%u10e1\\%u10d0\\%u10ea\\>\\|\\%u10e0\\%u10dd\\%u10ea\\%u10d0\\>\\|\\%u10d7\\%u10e3\\>"},
      \"kn": {"and": "\\%u0cae\\%u0ca4\\%u0ccd\\%u0ca4\\%u0cc1\\>", "background": "\\%u0cb9\\%u0cbf\\%u0ca8\\%u0ccd\\%u0ca8\\%u0cc6\\%u0cb2\\%u0cc6", "but": "\\%u0c86\\%u0ca6\\%u0cb0\\%u0cc6\\>", "examples": "\\%u0c89\\%u0ca6\\%u0cbe\\%u0cb9\\%u0cb0\\%u0ca3\\%u0cc6\\%u0c97\\%u0cb3\\%u0cc1", "feature": "\\%u0cb9\\%u0cc6\\%u0c9a\\%u0ccd\\%u0c9a\\%u0cb3", "given": "\\%u0ca8\\%u0cbf\\%u0cd5\\%u0ca1\\%u0cbf\\%u0ca6\\>", "rule": "Rule", "scenario": "\\%u0c95\\%u0ca5\\%u0cbe\\%u0cb8\\%u0cbe\\%u0cb0\\%u0cbe\\%u0c82\\%u0cb6\\|\\%u0c89\\%u0ca6\\%u0cbe\\%u0cb9\\%u0cb0\\%u0ca3\\%u0cc6", "scenario_outline": "\\%u0cb5\\%u0cbf\\%u0cb5\\%u0cb0\\%u0ca3\\%u0cc6", "then": "\\%u0ca8\\%u0c82\\%u0ca4\\%u0cb0\\>", "when": "\\%u0cb8\\%u0ccd\\%u0ca5\\%u0cbf\\%u0ca4\\%u0cbf\\%u0caf\\%u0ca8\\%u0ccd\\%u0ca8\\%u0cc1\\>"},
      \"ko": {"and": "\\%uadf8\\%ub9ac\\%uace0", "background": "\\%ubc30\\%uacbd", "but": "\\%ud558\\%uc9c0\\%ub9cc\\|\\%ub2e8", "examples": "\\%uc608", "feature": "\\%uae30\\%ub2a5", "given": "\\%uc870\\%uac74\\|\\%uba3c\\%uc800", "rule": "Rule", "scenario": "\\%uc2dc\\%ub098\\%ub9ac\\%uc624", "scenario_outline": "\\%uc2dc\\%ub098\\%ub9ac\\%uc624 \\%uac1c\\%uc694", "then": "\\%uadf8\\%ub7ec\\%uba74", "when": "\\%ub9cc\\%uc77c\\|\\%ub9cc\\%uc57d"},
      \"lt": {"and": "Ir\\>", "background": "Kontekstas", "but": "Bet\\>", "examples": "Pavyzd\\%u017eiai\\|Scenarijai\\|Variantai", "feature": "Savyb\\%u0117", "given": "Duota\\>", "rule": "Rule", "scenario": "Scenarijus\\|Pavyzdys", "scenario_outline": "Scenarijaus \\%u0161ablonas", "then": "Tada\\>", "when": "Kai\\>"},
      \"lu": {"and": "an\\>\\|a\\>", "background": "Hannergrond", "but": "awer\\>\\|m\\%u00e4\\>", "examples": "Beispiller", "feature": "Funktionalit\\%u00e9it", "given": "ugeholl\\>", "rule": "Rule", "scenario": "Beispill\\|Szenario", "scenario_outline": "Plang vum Szenario", "then": "dann\\>", "when": "wann\\>"},
      \"lv": {"and": "Un\\>", "background": "Konteksts\\|Situ\\%u0101cija", "but": "Bet\\>", "examples": "Piem\\%u0113ri\\|Paraugs", "feature": "Funkcionalit\\%u0101te\\|F\\%u012b\\%u010da", "given": "Kad\\>", "rule": "Rule", "scenario": "Scen\\%u0101rijs\\|Piem\\%u0113rs", "scenario_outline": "Scen\\%u0101rijs p\\%u0113c parauga", "then": "Tad\\>", "when": "Ja\\>"},
      \"mk-Cyrl": {"and": "\\%u0418\\>", "background": "\\%u041a\\%u043e\\%u043d\\%u0442\\%u0435\\%u043a\\%u0441\\%u0442\\|\\%u0421\\%u043e\\%u0434\\%u0440\\%u0436\\%u0438\\%u043d\\%u0430", "but": "\\%u041d\\%u043e\\>", "examples": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0458\\%u0430\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440\\%u0438", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b\\%u043d\\%u043e\\%u0441\\%u0442\\|\\%u0411\\%u0438\\%u0437\\%u043d\\%u0438\\%u0441 \\%u043f\\%u043e\\%u0442\\%u0440\\%u0435\\%u0431\\%u0430\\|\\%u041c\\%u043e\\%u0436\\%u043d\\%u043e\\%u0441\\%u0442", "given": "\\%u0414\\%u0430\\%u0434\\%u0435\\%u043d\\%u043e\\>\\|\\%u0414\\%u0430\\%u0434\\%u0435\\%u043d\\%u0430\\>", "rule": "Rule", "scenario": "\\%u041d\\%u0430 \\%u043f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440\\|\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u043e\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440", "scenario_outline": "\\%u041f\\%u0440\\%u0435\\%u0433\\%u043b\\%u0435\\%u0434 \\%u043d\\%u0430 \\%u0441\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0458\\%u0430\\|\\%u041a\\%u043e\\%u043d\\%u0446\\%u0435\\%u043f\\%u0442\\|\\%u0421\\%u043a\\%u0438\\%u0446\\%u0430", "then": "\\%u0422\\%u043e\\%u0433\\%u0430\\%u0448\\>", "when": "\\%u041a\\%u043e\\%u0433\\%u0430\\>"},
      \"mk-Latn": {"and": "I\\>", "background": "Sodrzhina\\|Kontekst", "but": "No\\>", "examples": "Scenaria\\|Primeri", "feature": "Funkcionalnost\\|Biznis potreba\\|Mozhnost", "given": "Dadeno\\>\\|Dadena\\>", "rule": "Rule", "scenario": "Na primer\\|Scenario", "scenario_outline": "Pregled na scenarija\\|Koncept\\|Skica", "then": "Togash\\>", "when": "Koga\\>"},
      \"mn": {"and": "\\%u0422\\%u044d\\%u0433\\%u044d\\%u044d\\%u0434\\>\\|\\%u041c\\%u04e9\\%u043d\\>", "background": "\\%u0410\\%u0433\\%u0443\\%u0443\\%u043b\\%u0433\\%u0430", "but": "\\%u0413\\%u044d\\%u0445\\%u0434\\%u044d\\%u044d\\>\\|\\%u0425\\%u0430\\%u0440\\%u0438\\%u043d\\>", "examples": "\\%u0422\\%u0443\\%u0445\\%u0430\\%u0439\\%u043b\\%u0431\\%u0430\\%u043b", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b\\|\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446", "given": "\\%u04e8\\%u0433\\%u04e9\\%u0433\\%u0434\\%u0441\\%u04e9\\%u043d \\%u043d\\%u044c\\>\\|\\%u0410\\%u043d\\%u0445\\>", "rule": "Rule", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440", "scenario_outline": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u044b\\%u043d \\%u0442\\%u04e9\\%u043b\\%u04e9\\%u0432\\%u043b\\%u04e9\\%u0433\\%u04e9\\%u04e9", "then": "\\%u04ae\\%u04af\\%u043d\\%u0438\\%u0439 \\%u0434\\%u0430\\%u0440\\%u0430\\%u0430\\>\\|\\%u0422\\%u044d\\%u0433\\%u044d\\%u0445\\%u044d\\%u0434\\>", "when": "\\%u0425\\%u044d\\%u0440\\%u044d\\%u0432\\>"},
      \"mr": {"and": "\\%u0924\\%u0938\\%u0947\\%u091a\\>\\|\\%u0906\\%u0923\\%u093f\\>", "background": "\\%u092a\\%u093e\\%u0930\\%u094d\\%u0936\\%u094d\\%u0935\\%u092d\\%u0942\\%u092e\\%u0940", "but": "\\%u092a\\%u0930\\%u0902\\%u0924\\%u0941\\>\\|\\%u092a\\%u0923\\>", "examples": "\\%u0909\\%u0926\\%u093e\\%u0939\\%u0930\\%u0923", "feature": "\\%u0935\\%u0948\\%u0936\\%u093f\\%u0937\\%u094d\\%u091f\\%u094d\\%u092f\\|\\%u0938\\%u0941\\%u0935\\%u093f\\%u0927\\%u093e", "given": "\\%u0926\\%u093f\\%u0932\\%u0947\\%u0932\\%u094d\\%u092f\\%u093e \\%u092a\\%u094d\\%u0930\\%u092e\\%u093e\\%u0923\\%u0947\\>\\|\\%u091c\\%u0930", "rule": "\\%u0928\\%u093f\\%u092f\\%u092e", "scenario": "\\%u092a\\%u0930\\%u093f\\%u0926\\%u0943\\%u0936\\%u094d\\%u092f", "scenario_outline": "\\%u092a\\%u0930\\%u093f\\%u0926\\%u0943\\%u0936\\%u094d\\%u092f \\%u0930\\%u0942\\%u092a\\%u0930\\%u0947\\%u0916\\%u093e", "then": "\\%u0924\\%u0947\\%u0935\\%u094d\\%u0939\\%u093e\\>\\|\\%u092e\\%u0917\\>", "when": "\\%u091c\\%u0947\\%u0935\\%u094d\\%u0939\\%u093e\\>"},
      \"ne": {"and": "\\%u0905\\%u0928\\%u093f\\>\\|\\%u0930\\>", "background": "\\%u092a\\%u0943\\%u0937\\%u094d\\%u0920\\%u092d\\%u0942\\%u092e\\%u0940", "but": "\\%u0924\\%u0930\\>", "examples": "\\%u0909\\%u0926\\%u093e\\%u0939\\%u0930\\%u0923\\%u0939\\%u0930\\%u0941\\|\\%u0909\\%u0926\\%u093e\\%u0939\\%u0930\\%u0923", "feature": "\\%u0935\\%u093f\\%u0936\\%u0947\\%u0937\\%u0924\\%u093e\\|\\%u0938\\%u0941\\%u0935\\%u093f\\%u0927\\%u093e", "given": "\\%u0926\\%u093f\\%u0907\\%u090f\\%u0915\\%u094b\\>\\|\\%u0926\\%u093f\\%u090f\\%u0915\\%u094b\\>\\|\\%u092f\\%u0926\\%u093f\\>", "rule": "\\%u0928\\%u093f\\%u092f\\%u092e", "scenario": "\\%u092a\\%u0930\\%u093f\\%u0926\\%u0943\\%u0936\\%u094d\\%u092f", "scenario_outline": "\\%u092a\\%u0930\\%u093f\\%u0926\\%u0943\\%u0936\\%u094d\\%u092f \\%u0930\\%u0942\\%u092a\\%u0930\\%u0947\\%u0916\\%u093e", "then": "\\%u0924\\%u094d\\%u092f\\%u0938\\%u092a\\%u091b\\%u093f\\>\\|\\%u0905\\%u0928\\%u0940\\>", "when": "\\%u091c\\%u092c\\>"},
      \"nl": {"and": "En\\>", "background": "Achtergrond", "but": "Maar\\>", "examples": "Voorbeelden", "feature": "Functionaliteit", "given": "Gegeven\\>\\|Stel\\>", "rule": "Rule", "scenario": "Voorbeeld\\|Scenario", "scenario_outline": "Abstract Scenario", "then": "Dan\\>", "when": "Wanneer\\>\\|Als\\>"},
      \"no": {"and": "Og\\>", "background": "Bakgrunn", "but": "Men\\>", "examples": "Eksempler", "feature": "Egenskap", "given": "Gitt\\>", "rule": "Regel", "scenario": "Eksempel\\|Scenario", "scenario_outline": "Abstrakt Scenario\\|Scenariomal", "then": "S\\%u00e5\\>", "when": "N\\%u00e5r\\>"},
      \"pa": {"and": "\\%u0a05\\%u0a24\\%u0a47\\>", "background": "\\%u0a2a\\%u0a3f\\%u0a1b\\%u0a4b\\%u0a15\\%u0a5c", "but": "\\%u0a2a\\%u0a30\\>", "examples": "\\%u0a09\\%u0a26\\%u0a3e\\%u0a39\\%u0a30\\%u0a28\\%u0a3e\\%u0a02", "feature": "\\%u0a28\\%u0a15\\%u0a36 \\%u0a28\\%u0a41\\%u0a39\\%u0a3e\\%u0a30\\|\\%u0a2e\\%u0a41\\%u0a39\\%u0a3e\\%u0a02\\%u0a26\\%u0a30\\%u0a3e\\|\\%u0a16\\%u0a3e\\%u0a38\\%u0a40\\%u0a05\\%u0a24", "given": "\\%u0a1c\\%u0a3f\\%u0a35\\%u0a47\\%u0a02 \\%u0a15\\%u0a3f\\>\\|\\%u0a1c\\%u0a47\\%u0a15\\%u0a30\\>", "rule": "Rule", "scenario": "\\%u0a09\\%u0a26\\%u0a3e\\%u0a39\\%u0a30\\%u0a28\\|\\%u0a2a\\%u0a1f\\%u0a15\\%u0a25\\%u0a3e", "scenario_outline": "\\%u0a2a\\%u0a1f\\%u0a15\\%u0a25\\%u0a3e \\%u0a30\\%u0a42\\%u0a2a \\%u0a30\\%u0a47\\%u0a16\\%u0a3e\\|\\%u0a2a\\%u0a1f\\%u0a15\\%u0a25\\%u0a3e \\%u0a22\\%u0a3e\\%u0a02\\%u0a1a\\%u0a3e", "then": "\\%u0a24\\%u0a26\\>", "when": "\\%u0a1c\\%u0a26\\%u0a4b\\%u0a02\\>"},
      \"pl": {"and": "Oraz\\>\\|I\\>", "background": "Za\\%u0142o\\%u017cenia", "but": "Ale\\>", "examples": "Przyk\\%u0142ady", "feature": "Potrzeba biznesowa\\|W\\%u0142a\\%u015bciwo\\%u015b\\%u0107\\|Funkcja\\|Aspekt", "given": "Zak\\%u0142adaj\\%u0105c, \\%u017ce\\>\\|Zak\\%u0142adaj\\%u0105c\\>\\|Maj\\%u0105c\\>", "rule": "Zasada\\|Regu\\%u0142a", "scenario": "Scenariusz\\|Przyk\\%u0142ad", "scenario_outline": "Szablon scenariusza", "then": "Wtedy\\>", "when": "Je\\%u017celi\\>\\|Je\\%u015bli\\>\\|Kiedy\\>\\|Gdy\\>"},
      \"pt": {"and": "E\\>", "background": "Cen\\%u00e1rio de Fundo\\|Cenario de Fundo\\|Contexto\\|Fundo", "but": "Mas\\>", "examples": "Exemplos\\|Cen\\%u00e1rios\\|Cenarios", "feature": "Funcionalidade\\|Caracter\\%u00edstica\\|Caracteristica", "given": "Dados\\>\\|Dadas\\>\\|Dado\\>\\|Dada\\>", "rule": "Regra", "scenario": "Exemplo\\|Cen\\%u00e1rio\\|Cenario", "scenario_outline": "Delinea\\%u00e7\\%u00e3o do Cen\\%u00e1rio\\|Delineacao do Cenario\\|Esquema do Cen\\%u00e1rio\\|Esquema do Cenario", "then": "Ent\\%u00e3o\\>\\|Entao\\>", "when": "Quando\\>"},
      \"ro": {"and": "Si\\>\\|\\%u0218i\\>\\|\\%u015ei\\>", "background": "Context", "but": "Dar\\>", "examples": "Exemple", "feature": "Functionalitate\\|Func\\%u021bionalitate\\|Func\\%u0163ionalitate", "given": "Date fiind\\>\\|Dati fiind\\>\\|Da\\%u021bi fiind\\>\\|Da\\%u0163i fiind\\>\\|Dat fiind\\>\\|Dat\\%u0103 fiind", "rule": "Rule", "scenario": "Scenariu\\|Exemplu", "scenario_outline": "Structura scenariu\\|Structur\\%u0103 scenariu", "then": "Atunci\\>", "when": "Cand\\>\\|C\\%u00e2nd\\>"},
      \"ru": {"and": "\\%u041a \\%u0442\\%u043e\\%u043c\\%u0443 \\%u0436\\%u0435\\>\\|\\%u0422\\%u0430\\%u043a\\%u0436\\%u0435\\>\\|\\%u0418\\>", "background": "\\%u041f\\%u0440\\%u0435\\%u0434\\%u044b\\%u0441\\%u0442\\%u043e\\%u0440\\%u0438\\%u044f\\|\\%u041a\\%u043e\\%u043d\\%u0442\\%u0435\\%u043a\\%u0441\\%u0442", "but": "\\%u0418\\%u043d\\%u0430\\%u0447\\%u0435\\>\\|\\%u041d\\%u043e\\>\\|\\%u0410\\>", "examples": "\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440\\%u044b", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b\\%u044c\\%u043d\\%u043e\\%u0441\\%u0442\\%u044c\\|\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b\\|\\%u0421\\%u0432\\%u043e\\%u0439\\%u0441\\%u0442\\%u0432\\%u043e\\|\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u044f\\|\\%u0424\\%u0438\\%u0447\\%u0430", "given": "\\%u0414\\%u043e\\%u043f\\%u0443\\%u0441\\%u0442\\%u0438\\%u043c\\>\\|\\%u041f\\%u0443\\%u0441\\%u0442\\%u044c\\>\\|\\%u0414\\%u0430\\%u043d\\%u043e\\>", "rule": "\\%u041f\\%u0440\\%u0430\\%u0432\\%u0438\\%u043b\\%u043e", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440", "scenario_outline": "\\%u0421\\%u0442\\%u0440\\%u0443\\%u043a\\%u0442\\%u0443\\%u0440\\%u0430 \\%u0441\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u044f\\|\\%u0428\\%u0430\\%u0431\\%u043b\\%u043e\\%u043d \\%u0441\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u044f", "then": "\\%u0417\\%u0430\\%u0442\\%u0435\\%u043c\\>\\|\\%u0422\\%u043e\\%u0433\\%u0434\\%u0430\\>\\|\\%u0422\\%u043e\\>", "when": "\\%u041a\\%u043e\\%u0433\\%u0434\\%u0430\\>\\|\\%u0415\\%u0441\\%u043b\\%u0438\\>"},
      \"sk": {"and": "A taktie\\%u017e\\>\\|A z\\%u00e1rove\\%u0148\\>\\|A tie\\%u017e\\>\\|A\\>", "background": "Pozadie", "but": "Ale\\>", "examples": "Pr\\%u00edklady", "feature": "Po\\%u017eiadavka\\|Vlastnos\\%u0165\\|Funkcia", "given": "Za predpokladu\\>\\|Pokia\\%u013e\\>", "rule": "Rule", "scenario": "Pr\\%u00edklad\\|Scen\\%u00e1r", "scenario_outline": "Osnova Scen\\%u00e1ra\\|N\\%u00e1\\%u010drt Scen\\%u00e1ru\\|N\\%u00e1\\%u010drt Scen\\%u00e1ra", "then": "Potom\\>\\|Tak\\>", "when": "Ke\\%u010f\\>\\|Ak\\>"},
      \"sl": {"and": "Ter\\>\\|In\\>", "background": "Kontekst\\|Osnova\\|Ozadje", "but": "Vendar\\>\\|Ampak\\>\\|Toda\\>", "examples": "Scenariji\\|Primeri", "feature": "Funkcionalnost\\|Zna\\%u010dilnost\\|Funkcija\\|Mo\\%u017enosti\\|Moznosti\\|Lastnost", "given": "Privzeto\\>\\|Podano\\>\\|Zaradi\\>\\|Dano\\>", "rule": "Rule", "scenario": "Scenarij\\|Primer", "scenario_outline": "Struktura scenarija\\|Oris scenarija\\|Koncept\\|Osnutek\\|Skica", "then": "Takrat\\>\\|Potem\\>\\|Nato\\>", "when": "Kadar\\>\\|Ko\\>\\|Ce\\>\\|\\%u010ce\\>"},
      \"sr-Cyrl": {"and": "\\%u0418\\>", "background": "\\%u041a\\%u043e\\%u043d\\%u0442\\%u0435\\%u043a\\%u0441\\%u0442\\|\\%u041f\\%u043e\\%u0437\\%u0430\\%u0434\\%u0438\\%u043d\\%u0430\\|\\%u041e\\%u0441\\%u043d\\%u043e\\%u0432\\%u0430", "but": "\\%u0410\\%u043b\\%u0438\\>", "examples": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0458\\%u0438\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440\\%u0438", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b\\%u043d\\%u043e\\%u0441\\%u0442\\|\\%u041c\\%u043e\\%u0433\\%u0443\\%u045b\\%u043d\\%u043e\\%u0441\\%u0442\\|\\%u041e\\%u0441\\%u043e\\%u0431\\%u0438\\%u043d\\%u0430", "given": "\\%u0417\\%u0430 \\%u0434\\%u0430\\%u0442\\%u043e\\>\\|\\%u0417\\%u0430 \\%u0434\\%u0430\\%u0442\\%u0435\\>\\|\\%u0417\\%u0430 \\%u0434\\%u0430\\%u0442\\%u0438\\>", "rule": "\\%u041f\\%u0440\\%u0430\\%u0432\\%u0438\\%u043b\\%u043e", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u043e\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440\\|\\%u041f\\%u0440\\%u0438\\%u043c\\%u0435\\%u0440", "scenario_outline": "\\%u0421\\%u0442\\%u0440\\%u0443\\%u043a\\%u0442\\%u0443\\%u0440\\%u0430 \\%u0441\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0458\\%u0430\\|\\%u041a\\%u043e\\%u043d\\%u0446\\%u0435\\%u043f\\%u0442\\|\\%u0421\\%u043a\\%u0438\\%u0446\\%u0430", "then": "\\%u041e\\%u043d\\%u0434\\%u0430\\>", "when": "\\%u041a\\%u0430\\%u0434\\%u0430\\>\\|\\%u041a\\%u0430\\%u0434\\>"},
      \"sr-Latn": {"and": "I\\>", "background": "Kontekst\\|Pozadina\\|Osnova", "but": "Ali\\>", "examples": "Scenariji\\|Primeri", "feature": "Funkcionalnost\\|Mogu\\%u0107nost\\|Mogucnost\\|Osobina", "given": "Za dato\\>\\|Za date\\>\\|Za dati\\>", "rule": "Pravilo", "scenario": "Scenario\\|Primer", "scenario_outline": "Struktura scenarija\\|Koncept\\|Skica", "then": "Onda\\>", "when": "Kada\\>\\|Kad\\>"},
      \"sv": {"and": "Och\\>", "background": "Bakgrund", "but": "Men\\>", "examples": "Exempel", "feature": "Egenskap", "given": "Givet\\>", "rule": "Regel", "scenario": "Scenario", "scenario_outline": "Abstrakt Scenario\\|Scenariomall", "then": "S\\%u00e5\\>", "when": "N\\%u00e4r\\>"},
      \"ta": {"and": "\\%u0bae\\%u0bc7\\%u0bb2\\%u0bc1\\%u0bae\\%u0bcd \\>\\|\\%u0bae\\%u0bb1\\%u0bcd\\%u0bb1\\%u0bc1\\%u0bae\\%u0bcd\\>", "background": "\\%u0baa\\%u0bbf\\%u0ba9\\%u0bcd\\%u0ba9\\%u0ba3\\%u0bbf", "but": "\\%u0b86\\%u0ba9\\%u0bbe\\%u0bb2\\%u0bcd \\>", "examples": "\\%u0b8e\\%u0b9f\\%u0bc1\\%u0ba4\\%u0bcd\\%u0ba4\\%u0bc1\\%u0b95\\%u0bcd\\%u0b95\\%u0bbe\\%u0b9f\\%u0bcd\\%u0b9f\\%u0bc1\\%u0b95\\%u0bb3\\%u0bcd\\|\\%u0ba8\\%u0bbf\\%u0bb2\\%u0bc8\\%u0bae\\%u0bc8\\%u0b95\\%u0bb3\\%u0bbf\\%u0bb2\\%u0bcd\\|\\%u0b95\\%u0bbe\\%u0b9f\\%u0bcd\\%u0b9a\\%u0bbf\\%u0b95\\%u0bb3\\%u0bcd", "feature": "\\%u0bb5\\%u0ba3\\%u0bbf\\%u0b95 \\%u0ba4\\%u0bc7\\%u0bb5\\%u0bc8\\|\\%u0b85\\%u0bae\\%u0bcd\\%u0b9a\\%u0bae\\%u0bcd\\|\\%u0ba4\\%u0bbf\\%u0bb1\\%u0ba9\\%u0bcd", "given": "\\%u0b95\\%u0bc6\\%u0bbe\\%u0b9f\\%u0bc1\\%u0b95\\%u0bcd\\%u0b95\\%u0baa\\%u0bcd\\%u0baa\\%u0b9f\\%u0bcd\\%u0b9f\\>", "rule": "Rule", "scenario": "\\%u0b89\\%u0ba4\\%u0bbe\\%u0bb0\\%u0ba3\\%u0bae\\%u0bbe\\%u0b95\\|\\%u0b95\\%u0bbe\\%u0b9f\\%u0bcd\\%u0b9a\\%u0bbf", "scenario_outline": "\\%u0b95\\%u0bbe\\%u0b9f\\%u0bcd\\%u0b9a\\%u0bbf \\%u0bb5\\%u0bbe\\%u0bb0\\%u0bcd\\%u0baa\\%u0bcd\\%u0baa\\%u0bc1\\%u0bb0\\%u0bc1\\|\\%u0b95\\%u0bbe\\%u0b9f\\%u0bcd\\%u0b9a\\%u0bbf \\%u0b9a\\%u0bc1\\%u0bb0\\%u0bc1\\%u0b95\\%u0bcd\\%u0b95\\%u0bae\\%u0bcd", "then": "\\%u0b85\\%u0baa\\%u0bcd\\%u0baa\\%u0bc6\\%u0bbe\\%u0bb4\\%u0bc1\\%u0ba4\\%u0bc1\\>", "when": "\\%u0b8e\\%u0baa\\%u0bcd\\%u0baa\\%u0bc7\\%u0bbe\\%u0ba4\\%u0bc1\\>"},
      \"te": {"and": "\\%u0c2e\\%u0c30\\%u0c3f\\%u0c2f\\%u0c41\\>", "background": "\\%u0c28\\%u0c47\\%u0c2a\\%u0c25\\%u0c4d\\%u0c2f\\%u0c02", "but": "\\%u0c15\\%u0c3e\\%u0c28\\%u0c3f\\>", "examples": "\\%u0c09\\%u0c26\\%u0c3e\\%u0c39\\%u0c30\\%u0c23\\%u0c32\\%u0c41", "feature": "\\%u0c17\\%u0c41\\%u0c23\\%u0c2e\\%u0c41", "given": "\\%u0c1a\\%u0c46\\%u0c2a\\%u0c4d\\%u0c2a\\%u0c2c\\%u0c21\\%u0c3f\\%u0c28\\%u0c26\\%u0c3f\\>", "rule": "Rule", "scenario": "\\%u0c38\\%u0c28\\%u0c4d\\%u0c28\\%u0c3f\\%u0c35\\%u0c47\\%u0c36\\%u0c02\\|\\%u0c09\\%u0c26\\%u0c3e\\%u0c39\\%u0c30\\%u0c23", "scenario_outline": "\\%u0c15\\%u0c25\\%u0c28\\%u0c02", "then": "\\%u0c05\\%u0c2a\\%u0c4d\\%u0c2a\\%u0c41\\%u0c21\\%u0c41\\>", "when": "\\%u0c08 \\%u0c2a\\%u0c30\\%u0c3f\\%u0c38\\%u0c4d\\%u0c25\\%u0c3f\\%u0c24\\%u0c3f\\%u0c32\\%u0c4b\\>"},
      \"th": {"and": "\\%u0e41\\%u0e25\\%u0e30\\>", "background": "\\%u0e41\\%u0e19\\%u0e27\\%u0e04\\%u0e34\\%u0e14", "but": "\\%u0e41\\%u0e15\\%u0e48\\>", "examples": "\\%u0e0a\\%u0e38\\%u0e14\\%u0e02\\%u0e2d\\%u0e07\\%u0e40\\%u0e2b\\%u0e15\\%u0e38\\%u0e01\\%u0e32\\%u0e23\\%u0e13\\%u0e4c\\|\\%u0e0a\\%u0e38\\%u0e14\\%u0e02\\%u0e2d\\%u0e07\\%u0e15\\%u0e31\\%u0e27\\%u0e2d\\%u0e22\\%u0e48\\%u0e32\\%u0e07", "feature": "\\%u0e04\\%u0e27\\%u0e32\\%u0e21\\%u0e15\\%u0e49\\%u0e2d\\%u0e07\\%u0e01\\%u0e32\\%u0e23\\%u0e17\\%u0e32\\%u0e07\\%u0e18\\%u0e38\\%u0e23\\%u0e01\\%u0e34\\%u0e08\\|\\%u0e04\\%u0e27\\%u0e32\\%u0e21\\%u0e2a\\%u0e32\\%u0e21\\%u0e32\\%u0e23\\%u0e16\\|\\%u0e42\\%u0e04\\%u0e23\\%u0e07\\%u0e2b\\%u0e25\\%u0e31\\%u0e01", "given": "\\%u0e01\\%u0e33\\%u0e2b\\%u0e19\\%u0e14\\%u0e43\\%u0e2b\\%u0e49\\>", "rule": "Rule", "scenario": "\\%u0e40\\%u0e2b\\%u0e15\\%u0e38\\%u0e01\\%u0e32\\%u0e23\\%u0e13\\%u0e4c", "scenario_outline": "\\%u0e42\\%u0e04\\%u0e23\\%u0e07\\%u0e2a\\%u0e23\\%u0e49\\%u0e32\\%u0e07\\%u0e02\\%u0e2d\\%u0e07\\%u0e40\\%u0e2b\\%u0e15\\%u0e38\\%u0e01\\%u0e32\\%u0e23\\%u0e13\\%u0e4c\\|\\%u0e2a\\%u0e23\\%u0e38\\%u0e1b\\%u0e40\\%u0e2b\\%u0e15\\%u0e38\\%u0e01\\%u0e32\\%u0e23\\%u0e13\\%u0e4c", "then": "\\%u0e14\\%u0e31\\%u0e07\\%u0e19\\%u0e31\\%u0e49\\%u0e19\\>", "when": "\\%u0e40\\%u0e21\\%u0e37\\%u0e48\\%u0e2d\\>"},
      \"tlh": {"and": "latlh\\>\\|'ej\\>", "background": "mo'", "but": "'ach\\>\\|'a\\>", "examples": "ghantoH\\|lutmey", "feature": "poQbogh malja'\\|Qu'meH 'ut\\|perbogh\\|Qap\\|laH", "given": "DaH ghu' bejlu'\\>\\|ghu' noblu'\\>", "rule": "Rule", "scenario": "lut", "scenario_outline": "lut chovnatlh", "then": "vaj\\>", "when": "qaSDI'\\>"},
      \"tr": {"and": "Ve\\>", "background": "Ge\\%u00e7mi\\%u015f", "but": "Fakat\\>\\|Ama\\>", "examples": "\\%u00d6rnekler", "feature": "\\%u00d6zellik", "given": "Diyelim ki\\>", "rule": "Kural", "scenario": "Senaryo\\|\\%u00d6rnek", "scenario_outline": "Senaryo tasla\\%u011f\\%u0131", "then": "O zaman\\>", "when": "E\\%u011fer ki\\>"},
      \"tt": {"and": "\\%u04ba\\%u04d9\\%u043c\\>\\|\\%u0412\\%u04d9\\>", "background": "\\%u041a\\%u0435\\%u0440\\%u0435\\%u0448", "but": "\\%u041b\\%u04d9\\%u043a\\%u0438\\%u043d\\>\\|\\%u04d8\\%u043c\\%u043c\\%u0430\\>", "examples": "\\%u04ae\\%u0440\\%u043d\\%u04d9\\%u043a\\%u043b\\%u04d9\\%u0440\\|\\%u041c\\%u0438\\%u0441\\%u0430\\%u043b\\%u043b\\%u0430\\%u0440", "feature": "\\%u04ae\\%u0437\\%u0435\\%u043d\\%u0447\\%u04d9\\%u043b\\%u0435\\%u043a\\%u043b\\%u0435\\%u043b\\%u0435\\%u043a\\|\\%u041c\\%u04e9\\%u043c\\%u043a\\%u0438\\%u043d\\%u043b\\%u0435\\%u043a", "given": "\\%u04d8\\%u0439\\%u0442\\%u0438\\%u043a\\>", "rule": "Rule", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439", "scenario_outline": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439\\%u043d\\%u044b\\%u04a3 \\%u0442\\%u04e9\\%u0437\\%u0435\\%u043b\\%u0435\\%u0448\\%u0435", "then": "\\%u041d\\%u04d9\\%u0442\\%u0438\\%u0497\\%u04d9\\%u0434\\%u04d9\\>", "when": "\\%u04d8\\%u0433\\%u04d9\\%u0440\\>"},
      \"uk": {"and": "\\%u0410 \\%u0442\\%u0430\\%u043a\\%u043e\\%u0436\\>\\|\\%u0422\\%u0430\\>\\|\\%u0406\\>", "background": "\\%u041f\\%u0435\\%u0440\\%u0435\\%u0434\\%u0443\\%u043c\\%u043e\\%u0432\\%u0430", "but": "\\%u0410\\%u043b\\%u0435\\>", "examples": "\\%u041f\\%u0440\\%u0438\\%u043a\\%u043b\\%u0430\\%u0434\\%u0438", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0456\\%u043e\\%u043d\\%u0430\\%u043b", "given": "\\%u041f\\%u0440\\%u0438\\%u043f\\%u0443\\%u0441\\%u0442\\%u0438\\%u043c\\%u043e, \\%u0449\\%u043e\\>\\|\\%u041f\\%u0440\\%u0438\\%u043f\\%u0443\\%u0441\\%u0442\\%u0438\\%u043c\\%u043e\\>\\|\\%u041d\\%u0435\\%u0445\\%u0430\\%u0439\\>\\|\\%u0414\\%u0430\\%u043d\\%u043e\\>", "rule": "Rule", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0456\\%u0439\\|\\%u041f\\%u0440\\%u0438\\%u043a\\%u043b\\%u0430\\%u0434", "scenario_outline": "\\%u0421\\%u0442\\%u0440\\%u0443\\%u043a\\%u0442\\%u0443\\%u0440\\%u0430 \\%u0441\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0456\\%u044e", "then": "\\%u0422\\%u043e\\%u0434\\%u0456\\>\\|\\%u0422\\%u043e\\>", "when": "\\%u042f\\%u043a\\%u0449\\%u043e\\>\\|\\%u041a\\%u043e\\%u043b\\%u0438\\>"},
      \"ur": {"and": "\\%u0627\\%u0648\\%u0631\\>", "background": "\\%u067e\\%u0633 \\%u0645\\%u0646\\%u0638\\%u0631", "but": "\\%u0644\\%u06cc\\%u06a9\\%u0646\\>", "examples": "\\%u0645\\%u062b\\%u0627\\%u0644\\%u06cc\\%u06ba", "feature": "\\%u06a9\\%u0627\\%u0631\\%u0648\\%u0628\\%u0627\\%u0631 \\%u06a9\\%u06cc \\%u0636\\%u0631\\%u0648\\%u0631\\%u062a\\|\\%u0635\\%u0644\\%u0627\\%u062d\\%u06cc\\%u062a\\|\\%u062e\\%u0635\\%u0648\\%u0635\\%u06cc\\%u062a", "given": "\\%u0641\\%u0631\\%u0636 \\%u06a9\\%u06cc\\%u0627\\>\\|\\%u0628\\%u0627\\%u0644\\%u0641\\%u0631\\%u0636\\>\\|\\%u0627\\%u06af\\%u0631\\>", "rule": "Rule", "scenario": "\\%u0645\\%u0646\\%u0638\\%u0631\\%u0646\\%u0627\\%u0645\\%u06c1", "scenario_outline": "\\%u0645\\%u0646\\%u0638\\%u0631 \\%u0646\\%u0627\\%u0645\\%u06d2 \\%u06a9\\%u0627 \\%u062e\\%u0627\\%u06a9\\%u06c1", "then": "\\%u067e\\%u06be\\%u0631\\>\\|\\%u062a\\%u0628\\>", "when": "\\%u062c\\%u0628\\>"},
      \"uz": {"and": "\\%u0412\\%u0430\\>", "background": "\\%u0422\\%u0430\\%u0440\\%u0438\\%u0445", "but": "\\%u041b\\%u0435\\%u043a\\%u0438\\%u043d\\>\\|\\%u0411\\%u0438\\%u0440\\%u043e\\%u043a\\>\\|\\%u0410\\%u043c\\%u043c\\%u043e\\>", "examples": "\\%u041c\\%u0438\\%u0441\\%u043e\\%u043b\\%u043b\\%u0430\\%u0440", "feature": "\\%u0424\\%u0443\\%u043d\\%u043a\\%u0446\\%u0438\\%u043e\\%u043d\\%u0430\\%u043b", "given": "Belgilangan\\>", "rule": "Rule", "scenario": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439", "scenario_outline": "\\%u0421\\%u0446\\%u0435\\%u043d\\%u0430\\%u0440\\%u0438\\%u0439 \\%u0441\\%u0442\\%u0440\\%u0443\\%u043a\\%u0442\\%u0443\\%u0440\\%u0430\\%u0441\\%u0438", "then": "\\%u0423\\%u043d\\%u0434\\%u0430\\>", "when": "\\%u0410\\%u0433\\%u0430\\%u0440\\>"},
      \"vi": {"and": "V\\%u00e0\\>", "background": "B\\%u1ed1i c\\%u1ea3nh", "but": "Nh\\%u01b0ng\\>", "examples": "D\\%u1eef li\\%u1ec7u", "feature": "T\\%u00ednh n\\%u0103ng", "given": "Bi\\%u1ebft\\>\\|Cho\\>", "rule": "Rule", "scenario": "T\\%u00ecnh hu\\%u1ed1ng\\|K\\%u1ecbch b\\%u1ea3n", "scenario_outline": "Khung t\\%u00ecnh hu\\%u1ed1ng\\|Khung k\\%u1ecbch b\\%u1ea3n", "then": "Th\\%u00ec\\>", "when": "Khi\\>"},
      \"zh-CN": {"and": "\\%u800c\\%u4e14\\|\\%u5e76\\%u4e14\\|\\%u540c\\%u65f6", "background": "\\%u80cc\\%u666f", "but": "\\%u4f46\\%u662f", "examples": "\\%u4f8b\\%u5b50", "feature": "\\%u529f\\%u80fd", "given": "\\%u5047\\%u5982\\|\\%u5047\\%u8bbe\\|\\%u5047\\%u5b9a", "rule": "Rule\\|\\%u89c4\\%u5219", "scenario": "\\%u573a\\%u666f\\|\\%u5267\\%u672c", "scenario_outline": "\\%u573a\\%u666f\\%u5927\\%u7eb2\\|\\%u5267\\%u672c\\%u5927\\%u7eb2", "then": "\\%u90a3\\%u4e48", "when": "\\%u5f53"},
      \"zh-TW": {"and": "\\%u800c\\%u4e14\\|\\%u4e26\\%u4e14\\|\\%u540c\\%u6642", "background": "\\%u80cc\\%u666f", "but": "\\%u4f46\\%u662f", "examples": "\\%u4f8b\\%u5b50", "feature": "\\%u529f\\%u80fd", "given": "\\%u5047\\%u5982\\|\\%u5047\\%u8a2d\\|\\%u5047\\%u5b9a", "rule": "Rule", "scenario": "\\%u5834\\%u666f\\|\\%u5287\\%u672c", "scenario_outline": "\\%u5834\\%u666f\\%u5927\\%u7db1\\|\\%u5287\\%u672c\\%u5927\\%u7db1", "then": "\\%u90a3\\%u9ebc", "when": "\\%u7576"}}

function! s:pattern(key)
  let language = matchstr(getline(1),'#\s*language:\s*\zs\S\+')
  if &fileencoding == 'latin1' && language == ''
    let language = 'en'
  endif
  if has_key(g:cucumber_languages, language)
    let languages = [g:cucumber_languages[language]]
  else
    let languages = values(g:cucumber_languages)
  end
  return '\<\%('.join(map(languages,'get(v:val,a:key,"\\%(a\\&b\\)")'),'\|').'\)'
endfunction

function! s:Add(name)
  let next = " skipempty skipwhite nextgroup=".join(map(["Region","AndRegion","ButRegion","StarRegion","Comment","String","Table"],'"cucumber".a:name.v:val'),",")
  exe "syn region cucumber".a:name.'Region matchgroup=cucumber'.a:name.' start="\%(^\s*\)\@<=\%('.s:pattern(tolower(a:name)).'\)" end="$"'.next
  exe 'syn region cucumber'.a:name.'AndRegion matchgroup=cucumber'.a:name.'And start="\%(^\s*\)\@<='.s:pattern('and').'" end="$" contained'.next
  exe 'syn region cucumber'.a:name.'ButRegion matchgroup=cucumber'.a:name.'But start="\%(^\s*\)\@<='.s:pattern('but').'" end="$" contained'.next
  exe 'syn region cucumber'.a:name.'StarRegion matchgroup=cucumber'.a:name.'Star start="\%(^\s*\)\@<=\*\S\@!" end="$" contained'.next
  exe 'syn match cucumber'.a:name.'Comment "\%(^\s*\)\@<=#.*" contained'.next
  exe 'syn region cucumber'.a:name.'String start=+\%(^\s*\)\@<="""+ end=+"""+ contained'.next
  exe 'syn match cucumber'.a:name.'Table "\%(^\s*\)\@<=|.*" contained contains=cucumberDelimiter'.next
  exe 'hi def link cucumber'.a:name.'Comment cucumberComment'
  exe 'hi def link cucumber'.a:name.'String cucumberString'
  exe 'hi def link cucumber'.a:name.'But cucumber'.a:name.'And'
  exe 'hi def link cucumber'.a:name.'Star cucumber'.a:name.'And'
  exe 'hi def link cucumber'.a:name.'And cucumber'.a:name
  exe 'syn cluster cucumberStepRegions add=cucumber'.a:name.'Region,cucumber'.a:name.'AndRegion,cucumber'.a:name.'ButRegion'
endfunction

syn match   cucumberComment  "\%(^\s*\)\@<=#.*"
syn match   cucumberComment  "\%(\%^\s*\)\@<=#.*" contains=cucumberLanguage
syn match   cucumberLanguage "\%(#\s*\)\@<=language:" contained
syn match   cucumberUnparsed "\S.*" nextgroup=cucumberUnparsedComment,cucumberUnparsed,cucumberTags,cucumberBackground,cucumberRule,cucumberScenario,cucumberScenarioOutline,cucumberExamples skipwhite skipempty contained
syn match   cucumberUnparsedComment "#.*" nextgroup=cucumberUnparsedComment,cucumberUnparsed,cucumberTags,cucumberBackground,cucumberRule,cucumberScenario,cucumberScenarioOutline,cucumberExamples skipwhite skipempty contained

exe 'syn match cucumberFeature "\%(^\s*\)\@<='.s:pattern('feature').':" nextgroup=cucumberUnparsedComment,cucumberUnparsed,cucumberBackground,cucumberRule,cucumberScenario,cucumberScenarioOutline,cucumberExamples skipwhite skipempty'
exe 'syn match cucumberBackground "\%(^\s*\)\@<='.s:pattern('background').':"'
exe 'syn match cucumberScenario "\%(^\s*\)\@<='.s:pattern('scenario').':"'
exe 'syn match cucumberRule "\%(^\s*\)\@<='.s:pattern('rule').':"'
exe 'syn match cucumberScenarioOutline "\%(^\s*\)\@<='.s:pattern('scenario_outline').':"'
exe 'syn match cucumberExamples "\%(^\s*\)\@<='.s:pattern('examples').':" nextgroup=cucumberExampleTable skipempty skipwhite'

syn match   cucumberPlaceholder   "<[^<>]*>" contained containedin=@cucumberStepRegions
syn match   cucumberExampleTable  "\%(^\s*\)\@<=|.*" contains=cucumberDelimiter
syn match   cucumberDelimiter     "\\\@<!\%(\\\\\)*\zs|" contained
syn match   cucumberTags          "\%(^\s*\)\@<=\%(@[^@[:space:]]\+\s\+\)*@[^@[:space:]]\+\s*$" contains=@NoSpell

call s:Add('Then')
call s:Add('When')
call s:Add('Given')

hi def link cucumberUnparsedComment   cucumberComment
hi def link cucumberComment           Comment
hi def link cucumberLanguage          SpecialComment
hi def link cucumberFeature           Macro
hi def link cucumberBackground        Define
hi def link cucumberRule              Define
hi def link cucumberScenario          Define
hi def link cucumberScenarioOutline   Define
hi def link cucumberExamples          Define
hi def link cucumberPlaceholder       Constant
hi def link cucumberDelimiter         Delimiter
hi def link cucumberTags              Tag
hi def link cucumberString            String
hi def link cucumberGiven             Conditional
hi def link cucumberWhen              Function
hi def link cucumberThen              Type

let b:current_syntax = "cucumber"

let &cpo = s:keepcpo
unlet s:keepcpo

" vim:set sts=2 sw=2:
