/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sqlfileoutput;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sqlfileoutput.Messages;
import org.pentaho.di.trans.steps.sqlfileoutput.SQLFileOutputData;
import org.pentaho.di.trans.steps.sqlfileoutput.SQLFileOutputMeta;

public class SQLFileOutput
extends BaseStep
implements StepInterface {
    private SQLFileOutputMeta meta;
    private SQLFileOutputData data;
    String schemaTable;
    String schemaName;
    String tableName;

    public SQLFileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block20: {
            this.meta = (SQLFileOutputMeta)smi;
            this.data = (SQLFileOutputData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.insertRowMeta = this.getInputRowMeta().clone();
                if (this.meta.isDoNotOpenNewFileInit() && !this.openNewFile()) {
                    this.logError("Couldn't open file [" + this.buildFilename() + "]");
                    this.setErrors(1L);
                    return false;
                }
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (r != null && this.getLinesOutput() > 0L && this.meta.getSplitEvery() > 0 && (this.getLinesOutput() + 1L) % (long)this.meta.getSplitEvery() == 0L) {
                this.closeFile();
                if (r != null && !this.openNewFile()) {
                    this.logError("Unable to open new file (split #" + this.data.splitnr + "...");
                    this.setErrors(1L);
                    return false;
                }
            }
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                if (this.getLinesOutput() == 0L) {
                    if (this.meta.createTable()) {
                        String cr_table = this.data.db.getDDLCreationTable(this.schemaTable, this.data.insertRowMeta);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(Messages.getString("SQLFileOutputLog.OutputSQL", cr_table));
                        }
                        this.data.writer.write(cr_table + Const.CR + Const.CR);
                    }
                    if (this.meta.truncateTable()) {
                        String truncatetable = this.data.db.getDDLTruncateTable(this.schemaName, this.tableName + ";" + Const.CR + Const.CR);
                        this.data.writer.write(truncatetable);
                    }
                }
            }
            catch (Exception e) {
                throw new KettleStepException(e.getMessage());
            }
            try {
                String sql = this.data.db.getSQLOutput(this.schemaName, this.tableName, this.data.insertRowMeta, r, this.meta.getDateFormat()) + ";";
                if (this.meta.StartNewLine()) {
                    sql = sql + Const.CR;
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(Messages.getString("SQLFileOutputLog.OutputSQL", sql));
                }
                try {
                    this.data.writer.write(sql.toCharArray());
                }
                catch (Exception e) {
                    throw new KettleStepException(e.getMessage());
                }
                this.putRow(this.data.outputRowMeta, r);
                this.incrementLinesOutput();
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic("linenr " + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("SQLFileOutputMeta.Log.ErrorInStep") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block20;
                this.putError(this.data.outputRowMeta, r, 1L, errorMessage, null, "SFO001");
                r = null;
            }
        }
        return true;
    }

    public String buildFilename() {
        return this.meta.buildFilename(this.environmentSubstitute(this.meta.getFileName()), this.getCopy(), this.data.splitnr);
    }

    public boolean openNewFile() {
        boolean retval = false;
        this.data.writer = null;
        try {
            OutputStream fos;
            String filename = this.buildFilename();
            if (this.meta.AddToResult()) {
                ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename), this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("This file was created with a text file output step");
                this.addResultFile(resultFile);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Opening output stream in nocompress mode", new Object[0]);
            }
            OutputStream outputStream = fos = KettleVFS.getOutputStream((String)filename, (boolean)this.meta.isFileAppended());
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Opening output stream in default encoding", new Object[0]);
            }
            this.data.writer = new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
            if (!Const.isEmpty((String)this.meta.getEncoding())) {
                if (this.log.isBasic()) {
                    this.log.logDetailed(this.toString(), "Opening output stream in encoding: " + this.meta.getEncoding(), new Object[0]);
                }
                this.data.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream, 5000), this.environmentSubstitute(this.meta.getEncoding()));
            } else {
                if (this.log.isBasic()) {
                    this.log.logDetailed(this.toString(), "Opening output stream in default encoding", new Object[0]);
                }
                this.data.writer = new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
            }
            if (this.log.isDetailed()) {
                this.logDetailed("Opened new file with name [" + filename + "]");
            }
            ++this.data.splitnr;
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file : " + e.toString());
        }
        return retval;
    }

    private boolean closeFile() {
        boolean retval = false;
        try {
            if (this.log.isDebug()) {
                this.logDebug("Closing output stream");
            }
            this.data.writer.close();
            if (this.log.isDebug()) {
                this.logDebug("Closed output stream");
            }
            this.data.writer = null;
            if (this.log.isDebug()) {
                this.logDebug("Closing normal file ..");
            }
            if (this.data.fos != null) {
                this.data.fos.close();
                this.data.fos = null;
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SQLFileOutputMeta)smi;
        this.data = (SQLFileOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                block19: {
                    if (this.meta.getDatabaseMeta() == null) {
                        throw new KettleStepException("The connection is not defined (empty)");
                    }
                    this.data.db = new Database(this.meta.getDatabaseMeta());
                    this.data.db.shareVariablesWith((VariableSpace)this);
                    this.logBasic("Connected to database [" + this.meta.getDatabaseMeta() + "]");
                    if (this.meta.isCreateParentFolder()) {
                        parentfolder = null;
                        try {
                            block18: {
                                filename = this.environmentSubstitute(this.meta.getFileName());
                                parentfolder = KettleVFS.getFileObject((String)filename).getParent();
                                if (parentfolder.exists()) break block18;
                                this.log.logBasic("Folder parent", "Folder parent " + parentfolder.getName() + " does not exist !", new Object[0]);
                                parentfolder.createFolder();
                                this.log.logBasic("Folder parent", "Folder parent was created.", new Object[0]);
                            }
                            var6_7 = null;
                            ** if (parentfolder == null) goto lbl-1000
                        }
                        catch (Throwable var5_13) {
                            var6_9 = null;
                            if (parentfolder != null) {
                                try {
                                    parentfolder.close();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            throw var5_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                parentfolder.close();
                            }
                            catch (Exception ex) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block19;
                            catch (Exception e) {
                                this.logError("Couldn't created parent folder " + parentfolder.getName());
                                this.setErrors(1L);
                                this.stopAll();
                                var6_8 = null;
                                if (parentfolder != null) {
                                    try {
                                        parentfolder.close();
                                    }
                                    catch (Exception ex) {}
                                }
                            }
                        }
                    }
                }
                if (!this.meta.isDoNotOpenNewFileInit() && !this.openNewFile()) {
                    this.logError("Couldn't open file [" + this.buildFilename() + "]");
                    this.setErrors(1L);
                    this.stopAll();
                }
                this.tableName = this.environmentSubstitute(this.meta.getTablename());
                this.schemaName = this.environmentSubstitute(this.meta.getSchemaName());
                if (Const.isEmpty((String)this.tableName)) {
                    throw new KettleStepException("The tablename is not defined (empty)");
                }
                this.schemaTable = this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.schemaName, this.tableName);
            }
            catch (Exception e) {
                this.logError("An error occurred intialising this step: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SQLFileOutputMeta)smi;
        this.data = (SQLFileOutputData)sdi;
        try {
            try {
                if (this.data.db != null) {
                    this.data.db.closeInsert();
                }
                if (this.data.fos != null) {
                    this.data.fos.close();
                }
                if (this.data.writer != null) {
                    this.data.writer.close();
                }
                this.closeFile();
            }
            catch (Exception dbe) {
                this.logError("Unexpected error committing the database connection: " + dbe.toString());
                this.logError(Const.getStackTracker((Throwable)dbe));
                this.setErrors(1L);
                this.stopAll();
                Object var5_4 = null;
                this.setOutputDone();
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                super.dispose(smi, sdi);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setOutputDone();
            if (this.data.db != null) {
                this.data.db.disconnect();
            }
            super.dispose(smi, sdi);
            throw throwable;
        }
        this.setOutputDone();
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

