/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices;

import com.ctc.wstx.exc.WstxParsingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.webservices.Messages;
import org.pentaho.di.trans.steps.webservices.WebServiceData;
import org.pentaho.di.trans.steps.webservices.WebServiceField;
import org.pentaho.di.trans.steps.webservices.WebServiceMeta;
import org.pentaho.di.trans.steps.webservices.wsdl.Wsdl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebService
extends BaseStep
implements StepInterface {
    public static final String NS_PREFIX = "ns";
    private WebServiceData data;
    private WebServiceMeta meta;
    private StringBuffer xml;
    private int nbRowProcess;
    private long requestTime;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private DecimalFormat decFormat = new DecimalFormat("00");
    private Date dateRef;
    private List<Integer> indexList;

    public WebService(StepMeta aStepMeta, StepDataInterface aStepData, int value, TransMeta aTransMeta, Trans aTrans) {
        super(aStepMeta, aStepData, value, aTransMeta, aTrans);
        try {
            this.dateRef = this.timeFormat.parse("00:00:00");
        }
        catch (ParseException e) {
            this.logError("Unexpected error in WebService constructor: ", e);
            this.setErrors(1L);
            this.stopAll();
        }
    }

    public boolean processRow(StepMetaInterface metaInterface, StepDataInterface dataInterface) throws KettleException {
        this.meta = (WebServiceMeta)metaInterface;
        this.data = (WebServiceData)dataInterface;
        Object[] vCurrentRow = this.getRow();
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta() != null ? this.getInputRowMeta().clone() : new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.defineIndexList(this.getInputRowMeta(), vCurrentRow);
            this.startXML();
        } else if (vCurrentRow == null) {
            this.setOutputDone();
            return false;
        }
        if (vCurrentRow != null) {
            this.parseRow(this.getInputRowMeta(), vCurrentRow);
            ++this.nbRowProcess;
        }
        if (vCurrentRow == null && this.nbRowProcess % this.meta.getCallStep() != 0 || vCurrentRow != null && this.nbRowProcess > 0 && this.nbRowProcess % this.meta.getCallStep() == 0 || vCurrentRow == null && !this.meta.hasFieldsIn()) {
            this.endXML();
            this.requestSOAP(vCurrentRow, this.getInputRowMeta());
            this.startXML();
        }
        if (vCurrentRow == null) {
            this.setOutputDone();
        }
        return vCurrentRow != null;
    }

    private void defineIndexList(RowMetaInterface rowMeta, Object[] vCurrentRow) {
        int index;
        this.indexList = new ArrayList<Integer>();
        if (rowMeta != null) {
            for (WebServiceField curField : this.meta.getFieldsIn()) {
                index = rowMeta.indexOfValue(curField.getName());
                if (index < 0) continue;
                this.indexList.add(index);
            }
        }
        for (WebServiceField curField : this.meta.getFieldsOut()) {
            index = this.data.outputRowMeta.indexOfValue(curField.getName());
            if (index < 0) continue;
            this.data.indexMap.put(curField.getWsName(), index);
        }
    }

    private void parseRow(RowMetaInterface rowMeta, Object[] vCurrentRow) throws KettleValueException {
        if (this.meta.getInFieldArgumentName() != null) {
            this.xml.append("        <ns:").append(this.meta.getInFieldArgumentName()).append(">\n");
        }
        for (Integer index : this.indexList) {
            ValueMetaInterface vCurrentValue = rowMeta.getValueMeta(index.intValue());
            Object data = vCurrentRow[index];
            WebServiceField field = this.meta.getFieldInFromName(vCurrentValue.getName());
            if (field == null) continue;
            if (!vCurrentValue.isNull(data)) {
                this.xml.append("          <").append(NS_PREFIX).append(":").append(field.getWsName()).append(">");
                if ("time".equals(field.getXsdType())) {
                    long millis = vCurrentValue.getDate(data).getTime() - this.dateRef.getTime();
                    this.xml.append(this.decFormat.format(millis / 3600000L) + ":" + this.decFormat.format(millis % 3600000L / 60000L) + ":" + this.decFormat.format(millis % 60000L / 1000L));
                } else if ("date".equals(field.getXsdType())) {
                    this.xml.append(this.dateFormat.format(vCurrentValue.getDate(data)));
                } else if ("boolean".equals(field.getXsdType())) {
                    this.xml.append(vCurrentValue.getBoolean(data) != false ? "true" : "false");
                } else if ("datetime".equals(field.getXsdType())) {
                    this.xml.append(this.dateTimeFormat.format(vCurrentValue.getDate(data)));
                } else if (vCurrentValue.isNumber()) {
                    this.xml.append(vCurrentValue.getString(data).trim().replace(',', '.'));
                } else {
                    this.xml.append(Const.trim((String)vCurrentValue.getString(data)));
                }
                this.xml.append("</").append(NS_PREFIX).append(":").append(field.getWsName()).append(">\n");
                continue;
            }
            this.xml.append("          <").append(NS_PREFIX).append(":").append(field.getWsName()).append(" xsi:nil=\"true\"/>\n");
        }
        if (this.meta.getInFieldArgumentName() != null) {
            this.xml.append("        </ns:").append(this.meta.getInFieldArgumentName()).append(">\n");
        }
    }

    private void startXML() {
        this.xml = new StringBuffer();
        this.xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns=\"");
        this.xml.append(this.meta.getOperationNamespace());
        this.xml.append("\">\n");
        this.xml.append("  <soapenv:Header/>\n");
        this.xml.append("  <soapenv:Body>\n");
        this.xml.append("    <ns:").append(this.meta.getOperationName()).append(">\n");
        if (this.meta.getInFieldContainerName() != null) {
            this.xml.append("      <ns:" + this.meta.getInFieldContainerName() + ">\n");
        }
    }

    private void endXML() {
        if (this.xml == null) {
            this.startXML();
        }
        if (this.meta.getInFieldContainerName() != null) {
            this.xml.append("      </ns:" + this.meta.getInFieldContainerName() + ">\n");
        }
        this.xml.append("    </ns:").append(this.meta.getOperationName()).append(">\n");
        this.xml.append("  </soapenv:Body>\n");
        this.xml.append("</soapenv:Envelope>\n");
    }

    private synchronized void requestSOAP(Object[] rowData, RowMetaInterface rowMeta) throws KettleException {
        String proxyHost;
        Wsdl wsdl;
        try {
            wsdl = new Wsdl(new java.net.URI(this.data.realUrl), null, null);
        }
        catch (Exception e) {
            throw new KettleStepException(Messages.getString("WebServices.ERROR0013.ExceptionLoadingWSDL"), (Throwable)e);
        }
        String vURLService = wsdl.getServiceEndpoint();
        HttpClient vHttpClient = new HttpClient();
        PostMethod vHttpMethod = new PostMethod(vURLService);
        HostConfiguration vHostConfiguration = new HostConfiguration();
        String httpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
        if (httpLogin != null && !"".equals(httpLogin)) {
            vHttpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(httpLogin, this.environmentSubstitute(this.meta.getHttpPassword()));
            vHttpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        if ((proxyHost = this.environmentSubstitute(this.meta.getProxyHost())) != null && !"".equals(proxyHost)) {
            vHostConfiguration.setProxy(proxyHost, Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080));
        }
        try {
            try {
                URI uri = new URI(vURLService, false);
                vHttpMethod.setURI(uri);
                vHttpMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
                String soapAction = "\"" + this.meta.getOperationNamespace();
                if (!this.meta.getOperationNamespace().endsWith("/")) {
                    soapAction = soapAction + "/";
                }
                soapAction = soapAction + this.meta.getOperationName() + "\"";
                this.logDetailed(Messages.getString("WebServices.Log.UsingRequestHeaderSOAPAction", soapAction));
                vHttpMethod.setRequestHeader("SOAPAction", soapAction);
                ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(this.xml.toString().getBytes("UTF-8"), "UTF-8");
                vHttpMethod.setRequestEntity((RequestEntity)requestEntity);
                long currentRequestTime = Const.nanoTime();
                int responseCode = vHttpClient.executeMethod(vHostConfiguration, (HttpMethod)vHttpMethod);
                if (responseCode != 200) {
                    if (responseCode == 401) {
                        throw new KettleStepException(Messages.getString("WebServices.ERROR0011.Authentication", vURLService));
                    }
                    if (responseCode == 404) {
                        throw new KettleStepException(Messages.getString("WebServices.ERROR0012.NotFound", vURLService));
                    }
                    throw new KettleStepException(Messages.getString("WebServices.ERROR0001.ServerError", Integer.toString(responseCode), Const.NVL((String)new String(vHttpMethod.getResponseBody()), (String)""), vURLService));
                }
                this.processRows(vHttpMethod.getResponseBodyAsStream(), rowData, rowMeta);
                this.requestTime += Const.nanoTime() - currentRequestTime;
            }
            catch (URIException e) {
                throw new KettleStepException(Messages.getString("WebServices.ERROR0002.InvalidURI", vURLService), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleStepException(Messages.getString("WebServices.ERROR0003.UnsupportedEncoding", vURLService), (Throwable)e);
            }
            catch (HttpException e) {
                throw new KettleStepException(Messages.getString("WebServices.ERROR0004.HttpException", vURLService), (Throwable)e);
            }
            catch (UnknownHostException e) {
                throw new KettleStepException(Messages.getString("WebServices.ERROR0013.UnknownHost", vURLService), (Throwable)e);
            }
            catch (IOException e) {
                throw new KettleStepException(Messages.getString("WebServices.ERROR0005.IOException", vURLService), (Throwable)e);
            }
            Object var17_21 = null;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            vHttpMethod.releaseConnection();
            throw throwable;
        }
        vHttpMethod.releaseConnection();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WebServiceMeta)smi;
        this.data = (WebServiceData)sdi;
        this.data.indexMap = new Hashtable<String, Integer>();
        this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WebServiceMeta)smi;
        this.data = (WebServiceData)sdi;
        super.dispose(smi, sdi);
    }

    private String readStringFromInputStream(InputStream anXml) throws KettleStepException {
        StringBuffer response = new StringBuffer();
        try {
            int c = anXml.read();
            while (c >= 0) {
                response.append((char)c);
                c = anXml.read();
            }
            anXml.close();
            return response.toString();
        }
        catch (Exception e) {
            throw new KettleStepException("Unable to read web service response data from input stream", (Throwable)e);
        }
    }

    private void processRows(InputStream anXml, Object[] rowData, RowMetaInterface rowMeta) throws KettleException {
        if (this.meta.isCompatible()) {
            this.compatibleProcessRows(anXml, rowData, rowMeta);
            return;
        }
        String response = this.readStringFromInputStream(anXml);
        try {
            Node bodyNode;
            Document doc = XMLHandler.loadXMLString((String)response);
            Node enveloppeNode = XMLHandler.getSubNode((Node)doc, (String)"soapenv:Envelope");
            if (enveloppeNode == null) {
                enveloppeNode = XMLHandler.getSubNode((Node)doc, (String)"soap:Envelope");
            }
            if ((bodyNode = XMLHandler.getSubNode((Node)enveloppeNode, (String)"soapenv:body")) == null) {
                bodyNode = XMLHandler.getSubNode((Node)enveloppeNode, (String)"soap:body");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            if (this.log.isDetailed()) {
                StringWriter bodyXML = new StringWriter();
                transformer.transform(new DOMSource(bodyNode), new StreamResult(bodyXML));
                this.logDetailed(bodyXML.toString());
            }
            Node responseNode = null;
            NodeList nodeList = null;
            if (!Const.isEmpty((String)this.meta.getRepeatingElementName())) {
                nodeList = ((Element)bodyNode).getElementsByTagName(this.meta.getRepeatingElementName());
            } else if (this.meta.isReturningReplyAsString()) {
                StringWriter nodeXML = new StringWriter();
                transformer.transform(new DOMSource(bodyNode), new StreamResult(nodeXML));
                String xml = response;
                Object[] outputRowData = this.createNewRow(rowData);
                int index = rowData == null ? 0 : this.getInputRowMeta().size();
                outputRowData[index++] = xml;
                this.putRow(this.data.outputRowMeta, outputRowData);
            } else {
                NodeList responseChildren = bodyNode.getChildNodes();
                for (int i = 0; i < responseChildren.getLength(); ++i) {
                    Node responseChild = responseChildren.item(i);
                    if (responseChild.getNodeType() != 1) continue;
                    responseNode = responseChild;
                    break;
                }
                if (responseNode != null) {
                    nodeList = responseNode.getChildNodes();
                }
            }
            if (nodeList == null || this.meta.isReturningReplyAsString()) {
                return;
            }
            Object[] outputRowData = this.createNewRow(rowData);
            boolean singleRow = false;
            int fieldsFound = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (this.meta.isReturningReplyAsString()) {
                    StringWriter nodeXML = new StringWriter();
                    transformer.transform(new DOMSource(bodyNode), new StreamResult(nodeXML));
                    String xml = nodeXML.toString();
                    outputRowData = this.createNewRow(rowData);
                    int index = rowData == null ? 0 : this.getInputRowMeta().size();
                    outputRowData[index++] = xml;
                    this.putRow(this.data.outputRowMeta, outputRowData);
                    continue;
                }
                WebServiceField field = this.meta.getFieldOutFromWsName(node.getNodeName());
                if (field != null) {
                    if (!this.getNodeValue(outputRowData, node, field, transformer, true)) continue;
                    singleRow = true;
                    ++fieldsFound;
                    continue;
                }
                if (singleRow) continue;
                if (this.log.isDetailed()) {
                    StringWriter nodeXML = new StringWriter();
                    transformer.transform(new DOMSource(node), new StreamResult(nodeXML));
                    this.logDetailed(Messages.getString("WebServices.Log.ResultRowDataFound", nodeXML.toString()));
                }
                outputRowData = this.createNewRow(rowData);
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    field = this.meta.getFieldOutFromWsName(childNode.getNodeName());
                    if (field == null || !this.getNodeValue(outputRowData, childNode, field, transformer, false)) continue;
                    ++fieldsFound;
                }
                if (fieldsFound <= 0) continue;
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            if (singleRow && fieldsFound > 0) {
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
        }
        catch (Exception e) {
            throw new KettleStepException(Messages.getString("WebServices.ERROR0010.OutputParsingError", response.toString()), (Throwable)e);
        }
    }

    private Object[] createNewRow(Object[] inputRowData) {
        return inputRowData == null ? RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size()) : RowDataUtil.createResizedCopy((Object[])inputRowData, (int)this.data.outputRowMeta.size());
    }

    private void compatibleProcessRows(InputStream anXml, Object[] rowData, RowMetaInterface rowMeta) throws KettleException {
        String response = this.readStringFromInputStream(anXml);
        StringReader stringReader = new StringReader(response.toString());
        try {
            XMLInputFactory vFactory = XMLInputFactory.newInstance();
            XMLStreamReader vReader = vFactory.createXMLStreamReader(stringReader);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            boolean processing = false;
            boolean oneValueRowProcessing = false;
            int event = vReader.next();
            while (vReader.hasNext()) {
                switch (event) {
                    case 1: {
                        WebServiceField field;
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("START_ELEMENT / " + vReader.getAttributeCount() + " / " + vReader.getNamespaceCount());
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                        }
                        if (Const.isEmpty((String)this.meta.getOutFieldArgumentName())) {
                            if (!oneValueRowProcessing) break;
                            field = this.meta.getFieldOutFromWsName(vReader.getLocalName());
                            if (field != null) {
                                outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), field);
                                this.putRow(this.data.outputRowMeta, outputRowData);
                                oneValueRowProcessing = false;
                                break;
                            }
                            if (!this.meta.getOutFieldContainerName().equals(vReader.getLocalName())) break;
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("OutFieldContainerName = " + this.meta.getOutFieldContainerName());
                            }
                            oneValueRowProcessing = true;
                            break;
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("OutFieldArgumentName = " + this.meta.getOutFieldArgumentName());
                        }
                        if (this.meta.getOutFieldArgumentName().equals(vReader.getLocalName())) {
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                            }
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("OutFieldArgumentName = ");
                            }
                            if (processing) {
                                int index;
                                field = this.meta.getFieldOutFromWsName(vReader.getLocalName());
                                if (field != null && (index = this.data.outputRowMeta.indexOfValue(field.getName())) >= 0) {
                                    outputRowData[index] = this.getValue(vReader.getElementText(), field);
                                }
                                processing = false;
                                break;
                            }
                            field = this.meta.getFieldOutFromWsName(vReader.getLocalName());
                            if (this.meta.getFieldsOut().size() == 1 && field != null) {
                                try {
                                    outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), field);
                                    this.putRow(this.data.outputRowMeta, outputRowData);
                                    break;
                                }
                                catch (WstxParsingException e) {
                                    throw new KettleStepException("Unable to get value for field [" + field.getName() + "].  Verify that this is not a complex data type by looking at the response XML.", (Throwable)e);
                                }
                            }
                            for (WebServiceField curField : this.meta.getFieldsOut()) {
                                if (Const.isEmpty((String)curField.getName())) continue;
                                outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), curField);
                            }
                            processing = true;
                            break;
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                        }
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("OutFieldArgumentName = " + this.meta.getOutFieldArgumentName());
                        break;
                    }
                    case 2: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("END_ELEMENT");
                        }
                        if (this.meta.getOutFieldArgumentName() == null && this.meta.getOperationName().equals(vReader.getLocalName())) {
                            oneValueRowProcessing = false;
                            break;
                        }
                        if (this.meta.getOutFieldArgumentName() == null || !this.meta.getOutFieldArgumentName().equals(vReader.getLocalName())) break;
                        this.putRow(this.data.outputRowMeta, outputRowData);
                        processing = false;
                        break;
                    }
                    case 3: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("PROCESSING_INSTRUCTION");
                        break;
                    }
                    case 4: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("CHARACTERS");
                        break;
                    }
                    case 5: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("COMMENT");
                        break;
                    }
                    case 6: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("PROCESSING_INSTRUCTION");
                        break;
                    }
                    case 7: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("START_DOCUMENT");
                        }
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel(vReader.getText());
                        break;
                    }
                    case 8: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("END_DOCUMENT");
                        break;
                    }
                    case 9: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ENTITY_REFERENCE");
                        break;
                    }
                    case 10: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ATTRIBUTE");
                        break;
                    }
                    case 11: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("DTD");
                        break;
                    }
                    case 12: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("CDATA");
                        break;
                    }
                    case 13: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("NAMESPACE");
                        break;
                    }
                    case 14: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("NOTATION_DECLARATION");
                        break;
                    }
                    case 15: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ENTITY_DECLARATION");
                        break;
                    }
                }
                event = vReader.next();
            }
        }
        catch (Exception e) {
            throw new KettleStepException(Messages.getString("WebServices.ERROR0010.OutputParsingError", response.toString()), (Throwable)e);
        }
    }

    private boolean getNodeValue(Object[] outputRowData, Node node, WebServiceField field, Transformer transformer, boolean singleRowScenario) throws KettleException {
        Integer outputIndex = this.data.indexMap.get(field.getWsName());
        if (outputIndex == null) {
            return false;
        }
        if (node.getNodeType() == 3 || !field.isComplex()) {
            Object rowValue = null;
            String textContent = node.getTextContent();
            try {
                outputRowData[outputIndex.intValue()] = rowValue = this.getValue(textContent, field);
                return true;
            }
            catch (Exception e) {
                throw new KettleException("Unable to convert value [" + textContent + "] for field [" + field.getWsName() + "], type [" + field.getXsdType() + "]", (Throwable)e);
            }
        }
        if (node.getNodeType() == 1) {
            try {
                StringWriter childNodeXML = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(childNodeXML));
                outputRowData[outputIndex.intValue()] = childNodeXML.toString();
                return true;
            }
            catch (Exception e) {
                throw new KettleException("Unable to transform DOM node with name [" + node.getNodeName() + "] to XML", (Throwable)e);
            }
        }
        return false;
    }

    private Object getValue(String vNodeValue, WebServiceField field) throws XMLStreamException, ParseException {
        if (vNodeValue == null) {
            return null;
        }
        if ("boolean".equals(field.getXsdType())) {
            return Boolean.valueOf(vNodeValue);
        }
        if ("date".equals(field.getXsdType())) {
            try {
                return this.dateFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("time".equals(field.getXsdType())) {
            try {
                return this.timeFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("datetime".equals(field.getXsdType())) {
            try {
                return this.dateTimeFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("int".equals(field.getXsdType()) || "short".equals(field.getXsdType()) || "integer".equals(field.getXsdType())) {
            try {
                return Long.parseLong(vNodeValue);
            }
            catch (NumberFormatException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("float".equals(field.getXsdType()) || "double".equals(field.getXsdType())) {
            try {
                return Double.parseDouble(vNodeValue);
            }
            catch (NumberFormatException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("base64Binary".equals(field.getXsdType())) {
            return Base64.decodeBase64((byte[])vNodeValue.getBytes());
        }
        if ("decimal".equals(field.getXsdType())) {
            return new BigDecimal(vNodeValue);
        }
        return vNodeValue;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

