/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLRelationship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SQLServerUnsupportedFeaturesCritic
extends CriticAndSettings {
    public SQLServerUnsupportedFeaturesCritic() {
        super(CriticAndSettings.StarterPlatformTypes.SQL_SERVER.getName(), Messages.getString("UnsupportedFeaturesCritic.name", CriticAndSettings.StarterPlatformTypes.SQL_SERVER.getName()));
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        if (!(subject instanceof SQLRelationship)) {
            return Collections.emptyList();
        }
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        SQLRelationship r = (SQLRelationship)subject;
        if (r.getDeferrability() != SQLRelationship.Deferrability.NOT_DEFERRABLE) {
            criticisms.add(new Criticism(subject, Messages.getString("UnsupportedFeaturesCritic.deferrabilityRuleNotSupported", this.getPlatformType(), r.getName()), this, new CriticFix[0]));
        }
        return criticisms;
    }
}

