/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.diff.SQLObjectComparator;
import ca.sqlpower.object.SPObjectUUIDComparator;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SQLRelationshipComparator
implements Comparator<SQLRelationship> {
    private static Logger logger = Logger.getLogger(SQLRelationshipComparator.class);
    private SQLObjectComparator nameComparator = new SQLObjectComparator();
    private SPObjectUUIDComparator<SQLObject> uuidComparator = new SPObjectUUIDComparator();
    private boolean useUUID;

    public SQLRelationshipComparator() {
        this(false);
    }

    public SQLRelationshipComparator(boolean compareWithUUID) {
        this.useUUID = compareWithUUID;
    }

    @Override
    public int compare(SQLRelationship r1, SQLRelationship r2) {
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        Object comparatorToUse = this.useUUID ? this.uuidComparator : this.nameComparator;
        int result = comparatorToUse.compare((SQLTable)r1.getPkTable(), (SQLTable)r2.getPkTable());
        if (result != 0) {
            return result;
        }
        result = comparatorToUse.compare(r1.getFkTable(), r2.getFkTable());
        if (result != 0) {
            return result;
        }
        TreeSet<SQLColumn> sourceColPk = new TreeSet<SQLColumn>((Comparator<SQLColumn>)comparatorToUse);
        TreeSet<SQLColumn> targetColPk = new TreeSet<SQLColumn>((Comparator<SQLColumn>)comparatorToUse);
        TreeSet<SQLColumn> sourceColFk = new TreeSet<SQLColumn>((Comparator<SQLColumn>)comparatorToUse);
        TreeSet<SQLColumn> targetColFk = new TreeSet<SQLColumn>((Comparator<SQLColumn>)comparatorToUse);
        for (SQLRelationship.ColumnMapping cm : r1.getChildren(SQLRelationship.ColumnMapping.class)) {
            sourceColPk.add(cm.getPkColumn());
            sourceColFk.add(cm.getFkColumn());
        }
        for (SQLRelationship.ColumnMapping cm : r2.getChildren(SQLRelationship.ColumnMapping.class)) {
            targetColPk.add(cm.getPkColumn());
            targetColFk.add(cm.getFkColumn());
        }
        result = this.compareColumns(sourceColPk, targetColPk);
        if (result != 0) {
            return result;
        }
        result = this.compareColumns(sourceColFk, targetColFk);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public int compareColumns(Set<SQLColumn> source, Set<SQLColumn> target) {
        boolean targetContinue;
        boolean sourceContinue;
        Iterator<SQLColumn> sourceIter = source.iterator();
        Iterator<SQLColumn> targetIter = target.iterator();
        do {
            SQLColumn targetColumn;
            SQLColumn sourceColumn;
            if (sourceIter.hasNext()) {
                sourceContinue = true;
                sourceColumn = sourceIter.next();
            } else {
                sourceContinue = false;
                sourceColumn = null;
            }
            if (targetIter.hasNext()) {
                targetContinue = true;
                targetColumn = targetIter.next();
            } else {
                targetContinue = false;
                targetColumn = null;
            }
            int result = this.nameComparator.compare((SQLObject)sourceColumn, (SQLObject)targetColumn);
            if (result == 0) continue;
            return result;
        } while (sourceContinue || targetContinue);
        return 0;
    }
}

