/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools;

import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ToolsUtils {
    public static String requireProperty(String name) {
        String value = ToolsUtils.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getProperty(String name) {
        return ToolsUtils.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public static Map<String, String> stringToMap(String str, String entrySeparator, String keyValueSeparator) {
        HashMap<String, String> result = new HashMap<String, String>();
        block4: for (String entry : StringUtils.splitByWholeSeparator((String)str, (String)entrySeparator)) {
            String[] pair = StringUtils.splitByWholeSeparator((String)entry, (String)keyValueSeparator, (int)2);
            if (pair.length > 0 && StringUtils.isBlank((CharSequence)pair[0])) {
                throw new IllegalArgumentException("Entry with empty key " + entry);
            }
            switch (pair.length) {
                case 1: {
                    result.put(pair[0].trim(), "");
                    continue block4;
                }
                case 2: {
                    result.put(pair[0].trim(), pair[1].trim());
                }
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }

    public static String dotJoin(String ... parts) {
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(parts[0]);
        int i = 1;
        while (i < parts.length) {
            buf.append('.').append(parts[i++]);
        }
        return buf.toString();
    }

    public static ExtensionCatalog resolvePlatformDescriptorDirectly(String bomGroupId, String bomArtifactId, String bomVersion, MavenArtifactResolver artifactResolver, MessageWriter log) {
        return ToolsUtils.resolvePlatformDescriptorDirectly(bomGroupId, bomArtifactId, bomVersion, artifactResolver, log, 1);
    }

    private static ExtensionCatalog resolvePlatformDescriptorDirectly(String bomGroupId, String bomArtifactId, String bomVersion, MavenArtifactResolver artifactResolver, MessageWriter log, int registryPreference) {
        Object members;
        Object o;
        ExtensionCatalog catalog;
        Path platformJson;
        DefaultArtifact catalogCoords;
        block17: {
            if (bomVersion == null) {
                throw new IllegalArgumentException("BOM version was not provided");
            }
            catalogCoords = new DefaultArtifact(bomGroupId == null ? "io.quarkus.platform" : bomGroupId, (bomArtifactId == null ? "quarkus-bom" : bomArtifactId) + "-quarkus-platform-descriptor", bomVersion, "json", bomVersion);
            platformJson = null;
            try {
                log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                platformJson = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
            }
            catch (Exception e) {
                if (bomGroupId == null && catalogCoords.getArtifactId().startsWith("quarkus-bom")) {
                    catalogCoords = new DefaultArtifact("io.quarkus", "quarkus-bom-quarkus-platform-descriptor", catalogCoords.getClassifier(), catalogCoords.getExtension(), catalogCoords.getVersion());
                    try {
                        log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                        platformJson = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (platformJson != null) break block17;
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to resolve extension catalog for ");
                sb.append(PlatformArtifacts.ensureBomArtifact((ArtifactCoords)ArtifactCoords.of((String)catalogCoords.getGroupId(), (String)catalogCoords.getArtifactId(), (String)catalogCoords.getClassifier(), (String)catalogCoords.getExtension(), (String)catalogCoords.getVersion())).toCompactCoords());
                sb.append(". Make sure the groupId, artifactId and version are spelled correctly and the relevant Maven repositories are configured.");
                throw new RuntimeException(sb.toString(), e);
            }
        }
        try {
            catalog = ExtensionCatalog.fromFile(platformJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize extension catalog " + String.valueOf(platformJson), e);
        }
        Map md = catalog.getMetadata();
        if (md != null && (o = md.get("platform-release")) instanceof Map && (members = ((Map)o).get("members")) instanceof Collection) {
            Collection memberList = (Collection)members;
            ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(memberList.size());
            int memberIndex = 0;
            for (Object m : memberList) {
                ExtensionCatalog memberCatalog;
                if (!(m instanceof String)) continue;
                if (catalog.getId().equals(m)) {
                    memberCatalog = catalog;
                } else {
                    try {
                        ArtifactCoords coords = ArtifactCoords.fromString((String)((String)m));
                        catalogCoords = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
                        log.debug("Resolving platform descriptor %s", new Object[]{catalogCoords});
                        Path jsonPath = artifactResolver.resolve((Artifact)catalogCoords).getArtifact().getFile().toPath();
                        memberCatalog = ExtensionCatalog.fromFile((Path)jsonPath);
                    }
                    catch (Exception e) {
                        log.warn("Failed to resolve member catalog " + String.valueOf(m), new Object[]{e});
                        continue;
                    }
                }
                OriginPreference originPreference = new OriginPreference(registryPreference, 1, 1, ++memberIndex, 1);
                HashMap<String, OriginPreference> metadata = new HashMap<String, OriginPreference>(memberCatalog.getMetadata());
                metadata.put("origin-preference", originPreference);
                ExtensionCatalog.Mutable mutableMemberCatalog = memberCatalog.mutable();
                mutableMemberCatalog.setMetadata(metadata);
                catalogs.add(mutableMemberCatalog.build());
            }
            catalog = CatalogMergeUtility.merge(catalogs);
        }
        if (!(catalog.getUpstreamQuarkusCoreVersion() == null || catalog.getUpstreamQuarkusCoreVersion().isBlank() || bomVersion.equals(catalog.getUpstreamQuarkusCoreVersion()) && catalogCoords.getGroupId().equals("io.quarkus.platform") && catalogCoords.getArtifactId().equals("quarkus-bom-quarkus-platform-descriptor"))) {
            try {
                ExtensionCatalog upstreamCatalog = ToolsUtils.resolvePlatformDescriptorDirectly(null, null, catalog.getUpstreamQuarkusCoreVersion(), artifactResolver, log, registryPreference + 1);
                catalog = CatalogMergeUtility.merge(List.of(catalog, upstreamCatalog));
            }
            catch (Exception e) {
                log.warn(e.getLocalizedMessage());
            }
        }
        return catalog;
    }

    public static ExtensionCatalog mergePlatforms(List<ArtifactCoords> platforms, MavenArtifactResolver artifactResolver) {
        return ToolsUtils.mergePlatforms(platforms, (AppModelResolver)new BootstrapAppModelResolver(artifactResolver));
    }

    public static ExtensionCatalog mergePlatforms(List<ArtifactCoords> platforms, AppModelResolver artifactResolver) {
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(platforms.size());
        for (ArtifactCoords platform : platforms) {
            Path json;
            try {
                json = artifactResolver.resolve(ArtifactCoords.of((String)platform.getGroupId(), (String)platform.getArtifactId(), (String)platform.getClassifier(), (String)platform.getType(), (String)platform.getVersion())).getResolvedPaths().getSinglePath();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve platform descriptor " + String.valueOf(platform), e);
            }
            try {
                catalogs.add(ExtensionCatalog.fromFile((Path)json));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize platform descriptor " + String.valueOf(json), e);
            }
        }
        return CatalogMergeUtility.merge(catalogs);
    }

    public static Properties readQuarkusProperties(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata().getOrDefault("project", Collections.emptyMap());
        map = map.getOrDefault("properties", Collections.emptyMap());
        Properties properties = new Properties();
        map.entrySet().forEach(e -> properties.setProperty(e.getKey().toString(), e.getValue() == null ? null : e.getValue().toString()));
        return properties;
    }

    public static Map<String, Object> readProjectData(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata().getOrDefault("project", Map.of());
        Map<String, Object> projectData = map.getOrDefault("codestart-data", Map.of());
        if (!projectData.containsKey("tooling-dockerfiles.dockerfile.jvm.from-template")) {
            projectData = projectData.entrySet().stream().collect(Collectors.toMap(e -> {
                if (!((String)e.getKey()).startsWith("dockerfile.")) {
                    return (String)e.getKey();
                }
                Object key = (String)e.getKey();
                if ("dockerfile.native-micro".equals(key)) {
                    key = (String)key + ".from";
                }
                return "tooling-dockerfiles." + (String)key;
            }, Map.Entry::getValue, (v1, v2) -> v1));
        }
        return projectData;
    }

    public static String requireProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getMavenPluginArtifactId(Properties props) {
        return props.getProperty("maven-plugin-artifactId");
    }

    public static String getMavenPluginGroupId(Properties props) {
        return props.getProperty("maven-plugin-groupId");
    }

    public static String getQuarkusCoreVersion(Properties props) {
        return props.getProperty("quarkus-core-version");
    }

    public static String requireQuarkusCoreVersion(Properties props) {
        return ToolsUtils.requireProperty(props, "quarkus-core-version");
    }

    public static String getMavenPluginVersion(Properties props) {
        return props.getProperty("maven-plugin-version");
    }

    public static String getGradlePluginVersion(Properties props) {
        return props.getProperty("gradle-plugin-version");
    }

    public static String getPluginKey(Properties props) {
        return ToolsUtils.getMavenPluginGroupId(props) + ":" + ToolsUtils.getMavenPluginArtifactId(props);
    }

    public static String getProposedMavenVersion(Properties props) {
        return props.getProperty("proposed-maven-version");
    }

    public static String getMavenWrapperVersion(Properties props) {
        return props.getProperty("maven-wrapper-version");
    }

    public static String getGradleWrapperVersion(Properties props) {
        return props.getProperty("gradle-wrapper-version");
    }
}

