/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_s64_t")
public class LibDivideS64
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    public LibDivideS64(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LibDivideS64.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int64_t")
    public long magic() {
        return LibDivideS64.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideS64.nmore(this.address());
    }

    public LibDivideS64 magic(@NativeType(value="int64_t") long value) {
        LibDivideS64.nmagic(this.address(), value);
        return this;
    }

    public LibDivideS64 more(@NativeType(value="uint8_t") byte value) {
        LibDivideS64.nmore(this.address(), value);
        return this;
    }

    public LibDivideS64 set(long magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideS64 set(LibDivideS64 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LibDivideS64 malloc() {
        return (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LibDivideS64 calloc() {
        return (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LibDivideS64 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LibDivideS64 create(long address) {
        return (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)address);
    }

    @Nullable
    public static LibDivideS64 createSafe(long address) {
        return address == 0L ? null : (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LibDivideS64.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LibDivideS64.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LibDivideS64.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideS64.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LibDivideS64.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LibDivideS64.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LibDivideS64.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static LibDivideS64 mallocStack() {
        return LibDivideS64.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LibDivideS64 callocStack() {
        return LibDivideS64.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LibDivideS64 mallocStack(MemoryStack stack) {
        return LibDivideS64.malloc(stack);
    }

    @Deprecated
    public static LibDivideS64 callocStack(MemoryStack stack) {
        return LibDivideS64.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LibDivideS64.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LibDivideS64.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LibDivideS64.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LibDivideS64.calloc(capacity, stack);
    }

    public static LibDivideS64 malloc(MemoryStack stack) {
        return (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LibDivideS64 calloc(MemoryStack stack) {
        return (LibDivideS64)LibDivideS64.wrap(LibDivideS64.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LibDivideS64.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LibDivideS64.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nmagic(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAGIC);
    }

    public static byte nmore(long struct) {
        return UNSAFE.getByte(null, struct + (long)MORE);
    }

    public static void nmagic(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAGIC, value);
    }

    public static void nmore(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MORE, value);
    }

    static {
        Struct.Layout layout = LibDivideS64.__struct((Struct.Member[])new Struct.Member[]{LibDivideS64.__member((int)8), LibDivideS64.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideS64, Buffer>
    implements NativeResource {
        private static final LibDivideS64 ELEMENT_FACTORY = LibDivideS64.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LibDivideS64 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int64_t")
        public long magic() {
            return LibDivideS64.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideS64.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="int64_t") long value) {
            LibDivideS64.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideS64.nmore(this.address(), value);
            return this;
        }
    }
}

