/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.component.tabview.Tab;
import org.primefaces.util.WidgetBuilder;

public class AccordionPanelRenderer
extends org.primefaces.component.accordionpanel.AccordionPanelRenderer {
    protected void encodeMarkup(FacesContext context, AccordionPanel acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = acco.getClientId(context);
        String widgetVar = acco.resolveWidgetVar();
        String style = acco.getStyle();
        String styleClass = acco.getStyleClass();
        styleClass = styleClass == null ? "ui-accordion ui-collapsible-set ui-corner-all" : "ui-accordion ui-collapsible-set ui-corner-all " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (acco.getStyle() != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("role", (Object)"tablist", null);
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        this.encodeTabs(context, acco);
        this.encodeStateHolder(context, acco);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AccordionPanel acco) throws IOException {
        String clientId = acco.getClientId(context);
        boolean multiple = acco.isMultiple();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AccordionPanel", acco.resolveWidgetVar(), clientId);
        if (acco.isDynamic()) {
            wb.attr("dynamic", true).attr("cache", acco.isCache());
        }
        wb.attr("multiple", multiple, false).callback("onTabChange", "function(panel)", acco.getOnTabChange()).callback("onTabShow", "function(panel)", acco.getOnTabShow());
        this.encodeClientBehaviors(context, acco);
        wb.finish();
    }

    protected void encodeTab(FacesContext context, Tab tab, boolean active, boolean dynamic, boolean rtl) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String containerClass = active ? "ui-collapsible ui-collapsible-inset ui-corner-all ui-collapsible-themed-content" : "ui-collapsible ui-collapsible-inset ui-corner-all ui-collapsible-themed-content ui-collapsible-collapsed";
        String headerClass = active ? "ui-collapsible-heading" : "ui-collapsible-heading ui-collapsible-heading-collapsed";
        headerClass = tab.isDisabled() ? headerClass + " ui-state-disabled" : headerClass;
        headerClass = tab.getTitleStyleClass() == null ? headerClass : headerClass + " " + tab.getTitleStyleClass();
        String iconClass = active ? "ui-collapsible-heading-toggle ui-btn ui-btn-icon-left ui-icon-minus" : "ui-collapsible-heading-toggle ui-btn ui-btn-icon-left ui-icon-plus";
        String contentClass = active ? "ui-collapsible-content ui-body-inherit" : "ui-collapsible-content ui-body-inherit ui-collapsible-content-collapsed";
        UIComponent titleFacet = tab.getFacet("title");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)tab.getClientId(context), null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.startElement("h3", null);
        writer.writeAttribute("class", (Object)headerClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        if (tab.getTitleStyle() != null) {
            writer.writeAttribute("style", (Object)tab.getTitleStyle(), null);
        }
        if (tab.getTitletip() != null) {
            writer.writeAttribute("title", (Object)tab.getTitletip(), null);
        }
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        if (titleFacet == null) {
            writer.write(tab.getTitle());
        } else {
            titleFacet.encodeAll(context);
        }
        writer.endElement("a");
        writer.endElement("h3");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)contentClass, null);
        writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
        writer.startElement("p", null);
        if (dynamic) {
            if (active) {
                tab.encodeAll(context);
                tab.setLoaded(true);
            }
        } else {
            tab.encodeAll(context);
        }
        writer.endElement("p");
        writer.endElement("div");
        writer.endElement("div");
    }
}

