/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarkChange;
import org.netbeans.modules.editor.bookmarks.BookmarkHistory;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerEvent;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerListener;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.FileBookmarksChange;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarksChange;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public final class BookmarkList {
    private static final String PROP_BOOKMARKS = "bookmarks";
    private static Set<EditorCookie.Observable> observedObservables = Collections.newSetFromMap(new WeakHashMap());
    private Document document;
    private List<Bookmark> bookmarks;
    private Map<BookmarkInfo, Bookmark> info2bookmark;
    private FileBookmarks fileBookmarks;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final BookmarkManagerListener bmListener = new BookmarkManagerListener(){

        @Override
        public void bookmarksChanged(BookmarkManagerEvent evt) {
            Collection<BookmarkChange> bookmarkChanges;
            FileBookmarksChange fileChange;
            ProjectBookmarksChange prjChange;
            if (BookmarkList.this.fileBookmarks != null && (prjChange = evt.getProjectBookmarksChange(BookmarkList.this.fileBookmarks.getProjectBookmarks().getProjectURI())) != null && (fileChange = prjChange.getFileBookmarksChange(BookmarkList.this.fileBookmarks.getRelativeURI())) != null && (bookmarkChanges = fileChange.getBookmarkChanges()) != null) {
                for (BookmarkChange change : bookmarkChanges) {
                    if (change.isAdded()) {
                        BookmarkList.this.addBookmarkForInfo(change.getBookmark(), -1);
                    }
                    if (!change.isRemoved()) continue;
                    BookmarkList.this.removeBookmarkImpl(change.getBookmark());
                }
            }
        }
    };
    private boolean pendingFireChange;
    private static PropertyChangeListener documentModifiedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditorCookie.Observable observable;
            StyledDocument document;
            if ("modified".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue()) && (document = (observable = (EditorCookie.Observable)evt.getSource()).getDocument()) != null) {
                BookmarkList.get(document).updateBookmarkLineIndexes();
            }
        }
    };
    private static final Comparator<Bookmark> bookmarksComparator = new Comparator<Bookmark>(){

        @Override
        public int compare(Bookmark bookmark1, Bookmark bookmark2) {
            return bookmark1.getOffset() - bookmark2.getOffset();
        }
    };

    public static BookmarkList get(Document doc) {
        BookmarkList bookmarkList = (BookmarkList)doc.getProperty(BookmarkList.class);
        if (bookmarkList == null) {
            bookmarkList = new BookmarkList(doc);
            doc.putProperty(BookmarkList.class, bookmarkList);
        }
        return bookmarkList;
    }

    private BookmarkList(final Document document) {
        EditorCookie.Observable observable;
        if (document == null) {
            throw new NullPointerException("Document cannot be null");
        }
        this.document = document;
        this.bookmarks = new ArrayList<Bookmark>();
        this.info2bookmark = new HashMap<BookmarkInfo, Bookmark>();
        BookmarkUtils.postTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                try {
                    BookmarkList.this.fileBookmarks = lockedBookmarkManager.getFileBookmarks(document);
                    if (BookmarkList.this.fileBookmarks != null) {
                        ProjectBookmarks projectBookmarks = BookmarkList.this.fileBookmarks.getProjectBookmarks();
                        projectBookmarks.activeClientNotify(this);
                        for (BookmarkInfo bookmarkInfo : BookmarkList.this.fileBookmarks.getBookmarks()) {
                            try {
                                BookmarkList.this.addBookmarkForInfo(bookmarkInfo, -1);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                        }
                    }
                    lockedBookmarkManager.addBookmarkManagerListener((BookmarkManagerListener)WeakListeners.create(BookmarkManagerListener.class, (EventListener)BookmarkList.this.bmListener, (Object)lockedBookmarkManager));
                }
                finally {
                    lockedBookmarkManager.unlock();
                }
            }
        });
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject != null && (observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class)) != null && !observedObservables.contains(observable)) {
            observable.addPropertyChangeListener(documentModifiedListener);
            observedObservables.add(observable);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public synchronized List<Bookmark> getBookmarks() {
        return Collections.unmodifiableList(this.bookmarks);
    }

    public Bookmark getNextBookmark(int offset, boolean wrapSearch) {
        this.checkOffsetNonNegative(++offset);
        Bookmark bookmark = this.getNextBookmark(offset);
        return bookmark != null || !wrapSearch ? bookmark : this.getNextBookmark(-1, false);
    }

    public Bookmark getPreviousBookmark(int offset, boolean wrapSearch) {
        Bookmark bookmark;
        this.checkOffsetNonNegative(offset);
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(this.getBookmarks());
        if (!bookmarks.isEmpty()) {
            if ((bookmark = this.getNextBookmark(--offset)) == null || bookmark.getOffset() != offset) {
                int index;
                int n = index = bookmark == null ? bookmarks.size() : bookmarks.indexOf(bookmark);
                bookmark = --index >= 0 ? (Bookmark)bookmarks.get(index) : (wrapSearch ? this.getPreviousBookmark(Integer.MAX_VALUE, false) : null);
            }
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    private Bookmark getNextBookmark(int offset) {
        int low = 0;
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(this.getBookmarks());
        if (bookmarks.isEmpty()) {
            return null;
        }
        int high = bookmarks.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midOffset = ((Bookmark)bookmarks.get(mid)).getOffset();
            if (midOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midOffset > offset) {
                high = mid - 1;
                continue;
            }
            --mid;
            while (mid >= 0 && ((Bookmark)bookmarks.get(mid)).getOffset() == offset) {
                --mid;
            }
            return (Bookmark)bookmarks.get(++mid);
        }
        if (low < bookmarks.size()) {
            return (Bookmark)bookmarks.get(low);
        }
        return null;
    }

    public Bookmark toggleLineBookmark(int offset) {
        try {
            final Position pos = this.document.createPosition(offset);
            BookmarkUtils.postTask(new Runnable(){
                private boolean docLocked;

                @Override
                public void run() {
                    if (this.docLocked) {
                        int lineIndex = BookmarkUtils.offset2LineIndex(BookmarkList.this.document, pos.getOffset());
                        Bookmark bookmark = null;
                        Element lineElem = BookmarkList.this.document.getDefaultRootElement().getElement(lineIndex);
                        int lineStartOffset = lineElem.getStartOffset();
                        bookmark = BookmarkList.this.getNextBookmark(lineStartOffset);
                        if (bookmark != null && bookmark.getOffset() < lineElem.getEndOffset()) {
                            BookmarkList.this.removeBookmark(bookmark);
                        } else {
                            Bookmark bookmark2 = BookmarkList.this.addBookmark(lineStartOffset);
                        }
                    } else {
                        this.docLocked = true;
                        BookmarkList.this.document.render(this);
                    }
                }
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBookmarkLineIndexes() {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            for (Bookmark b : this.bookmarks) {
                BookmarkInfo info = b.info();
                lockedBookmarkManager.updateLineIndex(info, b.getLineNumber());
            }
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    public synchronized boolean removeBookmark(Bookmark bookmark) {
        boolean removed = this.bookmarks.contains(bookmark);
        BookmarkUtils.removeBookmarkUnderLock(bookmark.info());
        return removed;
    }

    private synchronized void removeBookmarkImpl(BookmarkInfo bInfo) {
        Bookmark bookmark = this.info2bookmark.remove(bInfo);
        if (bookmark != null) {
            this.bookmarks.remove(bookmark);
            bookmark.release();
            this.fireChange();
        }
    }

    public synchronized void removeAllBookmarks() {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            lockedBookmarkManager.removeBookmarks(new ArrayList<BookmarkInfo>(this.info2bookmark.keySet()));
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Bookmark addBookmark(int offset) {
        Bookmark bookmark = null;
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            if (this.fileBookmarks != null) {
                int id = this.fileBookmarks.getProjectBookmarks().generateBookmarkId();
                BookmarkInfo info = BookmarkInfo.create(id, "", offset, "");
                bookmark = this.addBookmarkForInfo(info, offset);
                lockedBookmarkManager.addBookmark(this.fileBookmarks, info);
                BookmarkHistory.get().add(info);
                this.fireChange();
            }
        }
        finally {
            lockedBookmarkManager.unlock();
        }
        return bookmark;
    }

    @NonNull
    private Bookmark addBookmarkForInfo(BookmarkInfo bookmarkInfo, int offset) {
        Bookmark bookmark = this.info2bookmark.get(bookmarkInfo);
        if (bookmark == null) {
            int lineIndex = bookmarkInfo.getLineIndex();
            if (offset == -1) {
                offset = BookmarkUtils.lineIndex2Offset(this.document, lineIndex);
            } else {
                lineIndex = BookmarkUtils.offset2LineIndex(this.document, offset);
                bookmarkInfo.setLineIndex(lineIndex);
            }
            bookmark = new Bookmark(this, bookmarkInfo, offset);
            this.bookmarks.add(bookmark);
            this.bookmarks.sort(bookmarksComparator);
            this.info2bookmark.put(bookmarkInfo, bookmark);
        }
        return bookmark;
    }

    Bookmark getBookmark(BookmarkInfo info) {
        return this.info2bookmark.get(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        BookmarkManagerListener bookmarkManagerListener = this.bmListener;
        synchronized (bookmarkManagerListener) {
            if (this.pendingFireChange) {
                return;
            }
            this.pendingFireChange = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BookmarkManagerListener bookmarkManagerListener = BookmarkList.this.bmListener;
                synchronized (bookmarkManagerListener) {
                    BookmarkList.this.pendingFireChange = false;
                }
                BookmarkList.this.propertyChangeSupport.firePropertyChange(BookmarkList.PROP_BOOKMARKS, null, null);
            }
        });
    }

    private void checkOffsetNonNegative(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset=" + offset + " < 0");
        }
    }

    public synchronized String toString() {
        return "Bookmarks: " + this.bookmarks;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }
}

