/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsTreeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private final Map<Session, JPDABreakpoint> currentBreakpoints = new WeakHashMap<Session, JPDABreakpoint>();

    static int log10(int n) {
        int l = 1;
        while ((n /= 10) > 0) {
            ++l;
        }
        return l;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        Object z = ZEROS;
        while (((String)z).length() < n) {
            z = (String)z + " ";
        }
        return z;
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            int max;
            int num0;
            LineBreakpoint b = (LineBreakpoint)o;
            int lineNum = b.getLineNumber();
            Object line = Integer.toString(lineNum);
            Integer maxInt = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get(b);
            if (maxInt != null && (num0 = BreakpointsNodeModel.log10(max = maxInt.intValue()) - BreakpointsNodeModel.log10(lineNum)) > 0) {
                line = BreakpointsNodeModel.zeros(num0) + (String)line;
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(b), (Object)line));
        }
        if (o instanceof ThreadBreakpoint) {
            ThreadBreakpoint b = (ThreadBreakpoint)o;
            if (b.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint"));
            }
            if (b.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint"));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint"));
        }
        if (o instanceof FieldBreakpoint) {
            FieldBreakpoint b = (FieldBreakpoint)o;
            if (b.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getClassName()), (Object)b.getFieldName()));
            }
            if (b.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getClassName()), (Object)b.getFieldName()));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_or_Modification_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getClassName()), (Object)b.getFieldName()));
        }
        if (o instanceof MethodBreakpoint) {
            MethodBreakpoint b = (MethodBreakpoint)o;
            String className = "";
            String[] fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            }
            if ("".equals(b.getMethodName())) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)BreakpointsNodeModel.getShort(className), (Object)b.getMethodName()));
        }
        if (o instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint b = (ClassLoadUnloadBreakpoint)o;
            String className = "";
            String[] fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            } else {
                fs = b.getClassExclusionFilters();
                if (fs.length > 0) {
                    className = fs[0];
                }
            }
            if (b.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            if (b.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
        }
        if (o instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint b = (ExceptionBreakpoint)o;
            if (b.getCatchType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getExceptionClassName())));
            }
            if (b.getCatchType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getExceptionClassName())));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getExceptionClassName())));
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        Object description;
        String appendMsg = null;
        if (o instanceof Breakpoint) {
            boolean valid = false;
            boolean invalid = false;
            String message = null;
            Breakpoint brkp = (Breakpoint)o;
            Breakpoint.VALIDITY validity = brkp.getValidity();
            valid = validity == Breakpoint.VALIDITY.VALID;
            invalid = validity == Breakpoint.VALIDITY.INVALID;
            message = brkp.getValidityMessage();
            if (valid) {
                appendMsg = NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_APPEND_BP_Valid");
            }
            if (invalid) {
                appendMsg = message != null ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_APPEND_BP_Invalid_with_reason", (Object)message) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_APPEND_BP_Invalid");
            }
        }
        if (o instanceof LineBreakpoint) {
            description = NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)o), (Object)String.valueOf(((LineBreakpoint)o).getLineNumber()));
        } else if (o instanceof ThreadBreakpoint) {
            ThreadBreakpoint b = (ThreadBreakpoint)o;
            description = b.getBreakpointType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint") : (b.getBreakpointType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint") : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint"));
        } else if (o instanceof FieldBreakpoint) {
            FieldBreakpoint b = (FieldBreakpoint)o;
            description = b.getBreakpointType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)b.getClassName(), (Object)b.getFieldName()) : (b.getBreakpointType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)b.getClassName(), (Object)b.getFieldName()) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_or_Modification_Breakpoint", (Object)b.getClassName(), (Object)b.getFieldName()));
        } else if (o instanceof MethodBreakpoint) {
            MethodBreakpoint b = (MethodBreakpoint)o;
            className = "";
            fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            }
            description = "".equals(b.getMethodName()) ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)className) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)className, (Object)b.getMethodName());
        } else if (o instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint b = (ClassLoadUnloadBreakpoint)o;
            className = "";
            fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            } else {
                fs = b.getClassExclusionFilters();
                if (fs.length > 0) {
                    className = fs[0];
                }
            }
            description = b.getBreakpointType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)className) : (b.getBreakpointType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)className) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)className));
        } else if (o instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint b = (ExceptionBreakpoint)o;
            description = b.getCatchType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)b.getExceptionClassName()) : (b.getCatchType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)b.getExceptionClassName()) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)b.getExceptionClassName()));
        } else {
            throw new UnknownTypeException(o);
        }
        if (appendMsg != null) {
            description = (String)description + " " + appendMsg;
        }
        return description;
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        boolean invalid;
        boolean current = this.getCurrentBreakpoint() == o;
        boolean disabled = !((Breakpoint)o).isEnabled();
        boolean bl = invalid = ((Breakpoint)o).getValidity() == Breakpoint.VALIDITY.INVALID;
        if (o instanceof LineBreakpoint) {
            boolean conditional;
            String condition = ((LineBreakpoint)o).getCondition();
            boolean bl2 = conditional = condition != null && condition.trim().length() > 0;
            Object iconBase = current ? (disabled ? (conditional ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_CURRENT_LINE_BREAKPOINT) : (conditional ? CURRENT_LINE_CONDITIONAL_BREAKPOINT : CURRENT_LINE_BREAKPOINT)) : (disabled ? (conditional ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_LINE_BREAKPOINT) : (conditional ? LINE_CONDITIONAL_BREAKPOINT : LINE_BREAKPOINT));
            if (invalid && !disabled) {
                iconBase = (String)iconBase + "_broken";
            }
            return iconBase;
        }
        if (o instanceof ThreadBreakpoint || o instanceof FieldBreakpoint || o instanceof MethodBreakpoint || o instanceof ClassLoadUnloadBreakpoint || o instanceof ExceptionBreakpoint) {
            Object iconBase;
            if (current) {
                iconBase = disabled ? DISABLED_CURRENT_BREAKPOINT : CURRENT_BREAKPOINT;
            } else if (disabled) {
                iconBase = DISABLED_BREAKPOINT;
            } else {
                iconBase = BREAKPOINT;
                if (invalid) {
                    iconBase = (String)iconBase + "_broken";
                }
            }
            return iconBase;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireNodeChanged(JPDABreakpoint b) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
    }

    static String getShort(String s) {
        if (s.indexOf(42) >= 0) {
            return s;
        }
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPDABreakpoint getCurrentBreakpoint() {
        Session s = DebuggerManager.getDebuggerManager().getCurrentSession();
        Map<Session, JPDABreakpoint> map = this.currentBreakpoints;
        synchronized (map) {
            return this.currentBreakpoints.get(s);
        }
    }

    private String bold(JPDABreakpoint b, String name) {
        return b == this.getCurrentBreakpoint() ? BoldVariablesTableModelFilter.toHTML(name, true, false, null) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentBreakpoint(Session s, JPDABreakpoint currentBreakpoint) {
        JPDABreakpoint oldCurrentBreakpoint;
        Map<Session, JPDABreakpoint> map = this.currentBreakpoints;
        synchronized (map) {
            oldCurrentBreakpoint = this.currentBreakpoints.get(s);
            if (currentBreakpoint == null) {
                this.currentBreakpoints.remove(s);
            } else {
                this.currentBreakpoints.put(s, currentBreakpoint);
            }
        }
        if (oldCurrentBreakpoint != null) {
            this.fireNodeChanged(oldCurrentBreakpoint);
        }
        if (currentBreakpoint != null) {
            this.fireNodeChanged(currentBreakpoint);
        }
    }
}

