/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousVirtualMachine
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="vmName")
    private final String vmName;
    @JsonProperty(value="dbServerId")
    private final String dbServerId;
    @JsonProperty(value="dbServerDisplayName")
    private final String dbServerDisplayName;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="clientIpAddress")
    private final String clientIpAddress;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="autonomousVmClusterId")
    private final String autonomousVmClusterId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="cloudAutonomousVmClusterId")
    private final String cloudAutonomousVmClusterId;

    @Deprecated
    @ConstructorProperties(value={"id", "vmName", "dbServerId", "dbServerDisplayName", "cpuCoreCount", "memorySizeInGBs", "dbNodeStorageSizeInGBs", "lifecycleState", "clientIpAddress", "compartmentId", "autonomousVmClusterId", "freeformTags", "definedTags", "cloudAutonomousVmClusterId"})
    public AutonomousVirtualMachine(String id, String vmName, String dbServerId, String dbServerDisplayName, Integer cpuCoreCount, Integer memorySizeInGBs, Integer dbNodeStorageSizeInGBs, LifecycleState lifecycleState, String clientIpAddress, String compartmentId, String autonomousVmClusterId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String cloudAutonomousVmClusterId) {
        this.id = id;
        this.vmName = vmName;
        this.dbServerId = dbServerId;
        this.dbServerDisplayName = dbServerDisplayName;
        this.cpuCoreCount = cpuCoreCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.lifecycleState = lifecycleState;
        this.clientIpAddress = clientIpAddress;
        this.compartmentId = compartmentId;
        this.autonomousVmClusterId = autonomousVmClusterId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getDbServerId() {
        return this.dbServerId;
    }

    public String getDbServerDisplayName() {
        return this.dbServerDisplayName;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousVmClusterId() {
        return this.autonomousVmClusterId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getCloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousVirtualMachine(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", vmName=").append(String.valueOf(this.vmName));
        sb.append(", dbServerId=").append(String.valueOf(this.dbServerId));
        sb.append(", dbServerDisplayName=").append(String.valueOf(this.dbServerDisplayName));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", dbNodeStorageSizeInGBs=").append(String.valueOf(this.dbNodeStorageSizeInGBs));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", clientIpAddress=").append(String.valueOf(this.clientIpAddress));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", autonomousVmClusterId=").append(String.valueOf(this.autonomousVmClusterId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", cloudAutonomousVmClusterId=").append(String.valueOf(this.cloudAutonomousVmClusterId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousVirtualMachine)) {
            return false;
        }
        AutonomousVirtualMachine other = (AutonomousVirtualMachine)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.vmName, other.vmName) && Objects.equals(this.dbServerId, other.dbServerId) && Objects.equals(this.dbServerDisplayName, other.dbServerDisplayName) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.dbNodeStorageSizeInGBs, other.dbNodeStorageSizeInGBs) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.clientIpAddress, other.clientIpAddress) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.autonomousVmClusterId, other.autonomousVmClusterId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.cloudAutonomousVmClusterId, other.cloudAutonomousVmClusterId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.vmName == null ? 43 : this.vmName.hashCode());
        result = result * 59 + (this.dbServerId == null ? 43 : this.dbServerId.hashCode());
        result = result * 59 + (this.dbServerDisplayName == null ? 43 : this.dbServerDisplayName.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.dbNodeStorageSizeInGBs == null ? 43 : this.dbNodeStorageSizeInGBs.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.clientIpAddress == null ? 43 : this.clientIpAddress.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.autonomousVmClusterId == null ? 43 : this.autonomousVmClusterId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.cloudAutonomousVmClusterId == null ? 43 : this.cloudAutonomousVmClusterId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="vmName")
        private String vmName;
        @JsonProperty(value="dbServerId")
        private String dbServerId;
        @JsonProperty(value="dbServerDisplayName")
        private String dbServerDisplayName;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="clientIpAddress")
        private String clientIpAddress;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="autonomousVmClusterId")
        private String autonomousVmClusterId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="cloudAutonomousVmClusterId")
        private String cloudAutonomousVmClusterId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder vmName(String vmName) {
            this.vmName = vmName;
            this.__explicitlySet__.add("vmName");
            return this;
        }

        public Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            this.__explicitlySet__.add("dbServerId");
            return this;
        }

        public Builder dbServerDisplayName(String dbServerDisplayName) {
            this.dbServerDisplayName = dbServerDisplayName;
            this.__explicitlySet__.add("dbServerDisplayName");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder clientIpAddress(String clientIpAddress) {
            this.clientIpAddress = clientIpAddress;
            this.__explicitlySet__.add("clientIpAddress");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder autonomousVmClusterId(String autonomousVmClusterId) {
            this.autonomousVmClusterId = autonomousVmClusterId;
            this.__explicitlySet__.add("autonomousVmClusterId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            this.__explicitlySet__.add("cloudAutonomousVmClusterId");
            return this;
        }

        public AutonomousVirtualMachine build() {
            AutonomousVirtualMachine model = new AutonomousVirtualMachine(this.id, this.vmName, this.dbServerId, this.dbServerDisplayName, this.cpuCoreCount, this.memorySizeInGBs, this.dbNodeStorageSizeInGBs, this.lifecycleState, this.clientIpAddress, this.compartmentId, this.autonomousVmClusterId, this.freeformTags, this.definedTags, this.cloudAutonomousVmClusterId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousVirtualMachine model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("vmName")) {
                this.vmName(model.getVmName());
            }
            if (model.wasPropertyExplicitlySet("dbServerId")) {
                this.dbServerId(model.getDbServerId());
            }
            if (model.wasPropertyExplicitlySet("dbServerDisplayName")) {
                this.dbServerDisplayName(model.getDbServerDisplayName());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbNodeStorageSizeInGBs")) {
                this.dbNodeStorageSizeInGBs(model.getDbNodeStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("clientIpAddress")) {
                this.clientIpAddress(model.getClientIpAddress());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("autonomousVmClusterId")) {
                this.autonomousVmClusterId(model.getAutonomousVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("cloudAutonomousVmClusterId")) {
                this.cloudAutonomousVmClusterId(model.getCloudAutonomousVmClusterId());
            }
            return this;
        }
    }
}

