/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="isLatestForMajorVersion")
    private final Boolean isLatestForMajorVersion;
    @JsonProperty(value="supportsPdb")
    private final Boolean supportsPdb;
    @JsonProperty(value="isPreviewDbVersion")
    private final Boolean isPreviewDbVersion;
    @JsonProperty(value="isUpgradeSupported")
    private final Boolean isUpgradeSupported;

    @Deprecated
    @ConstructorProperties(value={"version", "isLatestForMajorVersion", "supportsPdb", "isPreviewDbVersion", "isUpgradeSupported"})
    public DbVersionSummary(String version, Boolean isLatestForMajorVersion, Boolean supportsPdb, Boolean isPreviewDbVersion, Boolean isUpgradeSupported) {
        this.version = version;
        this.isLatestForMajorVersion = isLatestForMajorVersion;
        this.supportsPdb = supportsPdb;
        this.isPreviewDbVersion = isPreviewDbVersion;
        this.isUpgradeSupported = isUpgradeSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getIsLatestForMajorVersion() {
        return this.isLatestForMajorVersion;
    }

    public Boolean getSupportsPdb() {
        return this.supportsPdb;
    }

    public Boolean getIsPreviewDbVersion() {
        return this.isPreviewDbVersion;
    }

    public Boolean getIsUpgradeSupported() {
        return this.isUpgradeSupported;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", isLatestForMajorVersion=").append(String.valueOf(this.isLatestForMajorVersion));
        sb.append(", supportsPdb=").append(String.valueOf(this.supportsPdb));
        sb.append(", isPreviewDbVersion=").append(String.valueOf(this.isPreviewDbVersion));
        sb.append(", isUpgradeSupported=").append(String.valueOf(this.isUpgradeSupported));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbVersionSummary)) {
            return false;
        }
        DbVersionSummary other = (DbVersionSummary)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.isLatestForMajorVersion, other.isLatestForMajorVersion) && Objects.equals(this.supportsPdb, other.supportsPdb) && Objects.equals(this.isPreviewDbVersion, other.isPreviewDbVersion) && Objects.equals(this.isUpgradeSupported, other.isUpgradeSupported) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.isLatestForMajorVersion == null ? 43 : this.isLatestForMajorVersion.hashCode());
        result = result * 59 + (this.supportsPdb == null ? 43 : this.supportsPdb.hashCode());
        result = result * 59 + (this.isPreviewDbVersion == null ? 43 : this.isPreviewDbVersion.hashCode());
        result = result * 59 + (this.isUpgradeSupported == null ? 43 : this.isUpgradeSupported.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="isLatestForMajorVersion")
        private Boolean isLatestForMajorVersion;
        @JsonProperty(value="supportsPdb")
        private Boolean supportsPdb;
        @JsonProperty(value="isPreviewDbVersion")
        private Boolean isPreviewDbVersion;
        @JsonProperty(value="isUpgradeSupported")
        private Boolean isUpgradeSupported;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder isLatestForMajorVersion(Boolean isLatestForMajorVersion) {
            this.isLatestForMajorVersion = isLatestForMajorVersion;
            this.__explicitlySet__.add("isLatestForMajorVersion");
            return this;
        }

        public Builder supportsPdb(Boolean supportsPdb) {
            this.supportsPdb = supportsPdb;
            this.__explicitlySet__.add("supportsPdb");
            return this;
        }

        public Builder isPreviewDbVersion(Boolean isPreviewDbVersion) {
            this.isPreviewDbVersion = isPreviewDbVersion;
            this.__explicitlySet__.add("isPreviewDbVersion");
            return this;
        }

        public Builder isUpgradeSupported(Boolean isUpgradeSupported) {
            this.isUpgradeSupported = isUpgradeSupported;
            this.__explicitlySet__.add("isUpgradeSupported");
            return this;
        }

        public DbVersionSummary build() {
            DbVersionSummary model = new DbVersionSummary(this.version, this.isLatestForMajorVersion, this.supportsPdb, this.isPreviewDbVersion, this.isUpgradeSupported);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbVersionSummary model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("isLatestForMajorVersion")) {
                this.isLatestForMajorVersion(model.getIsLatestForMajorVersion());
            }
            if (model.wasPropertyExplicitlySet("supportsPdb")) {
                this.supportsPdb(model.getSupportsPdb());
            }
            if (model.wasPropertyExplicitlySet("isPreviewDbVersion")) {
                this.isPreviewDbVersion(model.getIsPreviewDbVersion());
            }
            if (model.wasPropertyExplicitlySet("isUpgradeSupported")) {
                this.isUpgradeSupported(model.getIsUpgradeSupported());
            }
            return this;
        }
    }
}

