/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.api.io.IOProvider;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputWriter;
import org.netbeans.modules.cloud.oracle.assets.k8s.Bundle;
import org.netbeans.modules.cloud.oracle.assets.k8s.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.assets.k8s.PodItem;
import org.openide.util.Exceptions;

public class ShowPodLogsAction
implements ActionListener {
    private PodItem podItem;

    public ShowPodLogsAction(PodItem podItem) {
        this.podItem = podItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InputOutput io = IOProvider.getDefault().getIO(Bundle.OutputName(this.podItem.getName()), true);
        OutputWriter writer = io.getOut();
        KubernetesUtils.runWithClient(this.podItem.getCluster(), client -> {
            PodResource pod = (PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.podItem.getNamespace())).withName(this.podItem.getName());
            InputStream is = pod.watchLog().getOutput();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }
}

