/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.model.Base64SecretContentDetails;
import com.oracle.bmc.vault.model.CreateSecretDetails;
import com.oracle.bmc.vault.model.SecretContentDetails;
import com.oracle.bmc.vault.model.SecretReuseRule;
import com.oracle.bmc.vault.model.UpdateSecretDetails;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;

public class VaultItemClient {
    private static final Logger LOG = Logger.getLogger(VaultItemClient.class.getName());
    private final VaultsClient client;
    private final VaultItem context;

    public VaultItemClient(VaultItem context) {
        this.client = VaultsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile(context).getConfigProvider());
        this.context = context;
    }

    public ListSecretsResponse listSecrets(ListSecretsRequest request) {
        return this.client.listSecrets(request);
    }

    public void createNewSecret(Map.Entry<String, String> secret, KeyItem key) {
        SecretContentDetails secretContent = this.generateSecretContent(secret.getValue());
        CreateSecretDetails createDetails = CreateSecretDetails.builder().secretName(secret.getKey()).secretContent(secretContent).secretRules(new ArrayList<SecretReuseRule>(Arrays.asList(SecretReuseRule.builder().isEnforcedOnDeletedSecretVersions(Boolean.valueOf(false)).build()))).compartmentId(this.context.getCompartmentId()).vaultId(this.context.getKey().getValue()).keyId(key.getKey().getValue()).build();
        CreateSecretRequest request = CreateSecretRequest.builder().createSecretDetails(createDetails).build();
        this.client.createSecret(request);
    }

    public void updateExistingSecret(Map.Entry<String, String> secret, String secretId) {
        SecretContentDetails secretContent = this.generateSecretContent(secret.getValue());
        UpdateSecretDetails updateSecretDetails = UpdateSecretDetails.builder().secretContent(secretContent).build();
        UpdateSecretRequest request = UpdateSecretRequest.builder().secretId(secretId).updateSecretDetails(updateSecretDetails).build();
        try {
            this.client.updateSecret(request);
        }
        catch (BmcException ex) {
            LOG.log(Level.WARNING, "Update of secret failed", ex);
        }
    }

    private SecretContentDetails generateSecretContent(String secretValue) {
        String base64Content = Base64.getEncoder().encodeToString(secretValue.getBytes(StandardCharsets.UTF_8));
        return Base64SecretContentDetails.builder().content(base64Content).stage(SecretContentDetails.Stage.Current).build();
    }
}

