/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VaultUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="keyCount")
    private final Integer keyCount;
    @JsonProperty(value="keyVersionCount")
    private final Integer keyVersionCount;
    @JsonProperty(value="softwareKeyCount")
    private final Integer softwareKeyCount;
    @JsonProperty(value="softwareKeyVersionCount")
    private final Integer softwareKeyVersionCount;

    @Deprecated
    @ConstructorProperties(value={"keyCount", "keyVersionCount", "softwareKeyCount", "softwareKeyVersionCount"})
    public VaultUsage(Integer keyCount, Integer keyVersionCount, Integer softwareKeyCount, Integer softwareKeyVersionCount) {
        this.keyCount = keyCount;
        this.keyVersionCount = keyVersionCount;
        this.softwareKeyCount = softwareKeyCount;
        this.softwareKeyVersionCount = softwareKeyVersionCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getKeyCount() {
        return this.keyCount;
    }

    public Integer getKeyVersionCount() {
        return this.keyVersionCount;
    }

    public Integer getSoftwareKeyCount() {
        return this.softwareKeyCount;
    }

    public Integer getSoftwareKeyVersionCount() {
        return this.softwareKeyVersionCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VaultUsage(");
        sb.append("super=").append(super.toString());
        sb.append("keyCount=").append(String.valueOf(this.keyCount));
        sb.append(", keyVersionCount=").append(String.valueOf(this.keyVersionCount));
        sb.append(", softwareKeyCount=").append(String.valueOf(this.softwareKeyCount));
        sb.append(", softwareKeyVersionCount=").append(String.valueOf(this.softwareKeyVersionCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VaultUsage)) {
            return false;
        }
        VaultUsage other = (VaultUsage)((Object)o);
        return Objects.equals(this.keyCount, other.keyCount) && Objects.equals(this.keyVersionCount, other.keyVersionCount) && Objects.equals(this.softwareKeyCount, other.softwareKeyCount) && Objects.equals(this.softwareKeyVersionCount, other.softwareKeyVersionCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.keyCount == null ? 43 : this.keyCount.hashCode());
        result = result * 59 + (this.keyVersionCount == null ? 43 : this.keyVersionCount.hashCode());
        result = result * 59 + (this.softwareKeyCount == null ? 43 : this.softwareKeyCount.hashCode());
        result = result * 59 + (this.softwareKeyVersionCount == null ? 43 : this.softwareKeyVersionCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyCount")
        private Integer keyCount;
        @JsonProperty(value="keyVersionCount")
        private Integer keyVersionCount;
        @JsonProperty(value="softwareKeyCount")
        private Integer softwareKeyCount;
        @JsonProperty(value="softwareKeyVersionCount")
        private Integer softwareKeyVersionCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyCount(Integer keyCount) {
            this.keyCount = keyCount;
            this.__explicitlySet__.add("keyCount");
            return this;
        }

        public Builder keyVersionCount(Integer keyVersionCount) {
            this.keyVersionCount = keyVersionCount;
            this.__explicitlySet__.add("keyVersionCount");
            return this;
        }

        public Builder softwareKeyCount(Integer softwareKeyCount) {
            this.softwareKeyCount = softwareKeyCount;
            this.__explicitlySet__.add("softwareKeyCount");
            return this;
        }

        public Builder softwareKeyVersionCount(Integer softwareKeyVersionCount) {
            this.softwareKeyVersionCount = softwareKeyVersionCount;
            this.__explicitlySet__.add("softwareKeyVersionCount");
            return this;
        }

        public VaultUsage build() {
            VaultUsage model = new VaultUsage(this.keyCount, this.keyVersionCount, this.softwareKeyCount, this.softwareKeyVersionCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VaultUsage model) {
            if (model.wasPropertyExplicitlySet("keyCount")) {
                this.keyCount(model.getKeyCount());
            }
            if (model.wasPropertyExplicitlySet("keyVersionCount")) {
                this.keyVersionCount(model.getKeyVersionCount());
            }
            if (model.wasPropertyExplicitlySet("softwareKeyCount")) {
                this.softwareKeyCount(model.getSoftwareKeyCount());
            }
            if (model.wasPropertyExplicitlySet("softwareKeyVersionCount")) {
                this.softwareKeyVersionCount(model.getSoftwareKeyVersionCount());
            }
            return this;
        }
    }
}

