/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateRelationshipPanel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToOne;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class AbstractCreateRelationshipHint
implements Fix {
    private FileObject fileObject;
    private FileObject targetFileObject;
    private ElementHandle<TypeElement> classHandle;
    private AccessType accessType;
    private String targetEntityClassName;
    private String localAttrName;
    private String annotationClass;
    private String complimentaryAnnotationClassName;
    private String relationName;
    private Collection<String> fieldsExistingAtTargetClass;
    private Collection<String> compatibleFieldsExistingAtTargetClass;

    public AbstractCreateRelationshipHint(FileObject fileObject, ElementHandle<TypeElement> classHandle, AccessType accessType, String localAttrName, String targetEntityClassName, String annotationClass, String complimentaryAnnotationClassName) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
        this.accessType = accessType;
        this.targetEntityClassName = targetEntityClassName;
        this.annotationClass = annotationClass;
        this.complimentaryAnnotationClassName = complimentaryAnnotationClassName;
        this.localAttrName = localAttrName;
        int dotPos = annotationClass.lastIndexOf(46);
        this.relationName = dotPos > -1 ? annotationClass.substring(dotPos + 1) : annotationClass;
    }

    public ChangeInfo implement() {
        this.examineTargetClass();
        boolean owningSide = this.isOwningSideByDefault();
        String mappedBy = this.getExistingFieldInRelation();
        if (mappedBy == null) {
            CreateRelationshipPanel pnlPickOrCreateField = new CreateRelationshipPanel();
            pnlPickOrCreateField.setEntityClassNames(Utilities.getShortClassName(this.classHandle.getQualifiedName()), Utilities.getShortClassName(this.targetEntityClassName));
            pnlPickOrCreateField.setAvailableSelection(this.getAvailableRelationTypeSelection());
            pnlPickOrCreateField.setAvailableFields(this.compatibleFieldsExistingAtTargetClass);
            pnlPickOrCreateField.setDefaultFieldName(this.genDefaultFieldName());
            pnlPickOrCreateField.setExistingFieldNames(this.fieldsExistingAtTargetClass);
            DialogDescriptor ddesc = new DialogDescriptor((Object)pnlPickOrCreateField, NbBundle.getMessage(AbstractCreateRelationshipHint.class, (String)"LBL_CreateRelationDlgTitle", (Object)this.relationName, (Object)this.targetEntityClassName));
            pnlPickOrCreateField.setDlgDescriptor(ddesc);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(ddesc);
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
            if (ddesc.getValue() == DialogDescriptor.OK_OPTION) {
                String fieldName = null;
                fieldName = pnlPickOrCreateField.wasCreateNewFieldSelected() ? pnlPickOrCreateField.getNewIdName() : pnlPickOrCreateField.getSelectedField().toString();
                owningSide = pnlPickOrCreateField.owningSide();
                mappedBy = fieldName;
            } else {
                mappedBy = null;
            }
        } else {
            owningSide = false;
        }
        if (mappedBy != null) {
            this.modifyFiles(owningSide, mappedBy);
        }
        return null;
    }

    private void examineTargetClass() {
        this.fieldsExistingAtTargetClass = new TreeSet<String>();
        this.compatibleFieldsExistingAtTargetClass = new TreeSet<String>();
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController ccontrol) throws Exception {
                ccontrol.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement targetClass = ccontrol.getElements().getTypeElement(AbstractCreateRelationshipHint.this.targetEntityClassName);
                assert (targetClass != null);
                AbstractCreateRelationshipHint.this.targetFileObject = SourceUtils.getFile((Element)targetClass, (ClasspathInfo)ccontrol.getClasspathInfo());
                for (VariableElement field : ElementFilter.fieldsIn(targetClass.getEnclosedElements())) {
                    AbstractCreateRelationshipHint.this.fieldsExistingAtTargetClass.add(field.getSimpleName().toString());
                    TypeMirror type = field.asType();
                    Element typeElement = null;
                    if (AbstractCreateRelationshipHint.this.isMultiValuedAtTargetEntity()) {
                        List<? extends TypeMirror> typeArgs;
                        if (type.getKind() == TypeKind.DECLARED && (typeArgs = ((DeclaredType)type).getTypeArguments()).size() == 1) {
                            typeElement = ccontrol.getTypes().asElement(typeArgs.get(0));
                        }
                    } else {
                        typeElement = ccontrol.getTypes().asElement(type);
                    }
                    if (typeElement == null || typeElement.getKind() != ElementKind.CLASS || !((TypeElement)typeElement).getQualifiedName().contentEquals(AbstractCreateRelationshipHint.this.classHandle.getQualifiedName())) continue;
                    AbstractCreateRelationshipHint.this.compatibleFieldsExistingAtTargetClass.add(field.getSimpleName().toString());
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runUserActionTask((Task)task, true);
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private String getExistingFieldInRelation() {
        String mappedBy = null;
        try {
            MetadataModel<EntityMappingsMetadata> emModel = ModelUtils.getModel(this.fileObject);
            mappedBy = (String)emModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, String>(){

                public String run(EntityMappingsMetadata metadata) {
                    Entity remoteEntity = ModelUtils.getEntity(metadata, AbstractCreateRelationshipHint.this.targetEntityClassName);
                    assert (remoteEntity != null);
                    if (AbstractCreateRelationshipHint.this.complimentaryAnnotationClassName.equals("javax.persistence.OneToOne")) {
                        return AbstractCreateRelationshipHint.this.getMappedByFromOneToOne(remoteEntity);
                    }
                    if (AbstractCreateRelationshipHint.this.complimentaryAnnotationClassName.equals("javax.persistence.ManyToMany")) {
                        return AbstractCreateRelationshipHint.this.getMappedByFromManyToMany(remoteEntity);
                    }
                    if (AbstractCreateRelationshipHint.this.complimentaryAnnotationClassName.equals("javax.persistence.OneToMany")) {
                        return AbstractCreateRelationshipHint.this.getMappedByFromOneToMany(remoteEntity);
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException ex) {
            JPAProblemFinder.LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            JPAProblemFinder.LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return mappedBy;
    }

    private String getMappedByFromOneToOne(Entity remoteEntity) {
        for (OneToOne one2one : remoteEntity.getAttributes().getOneToOne()) {
            if (!this.classHandle.getQualifiedName().equals(one2one.getTargetEntity()) || !this.localAttrName.equals(one2one.getMappedBy())) continue;
            return one2one.getName();
        }
        return null;
    }

    private String getMappedByFromManyToMany(Entity remoteEntity) {
        for (ManyToMany many2many : remoteEntity.getAttributes().getManyToMany()) {
            if (!this.classHandle.getQualifiedName().equals(many2many.getTargetEntity()) || !this.localAttrName.equals(many2many.getMappedBy())) continue;
            return many2many.getName();
        }
        return null;
    }

    private String getMappedByFromOneToMany(Entity remoteEntity) {
        for (OneToMany oneToMany : remoteEntity.getAttributes().getOneToMany()) {
            if (!this.classHandle.getQualifiedName().equals(oneToMany.getTargetEntity()) || !this.localAttrName.equals(oneToMany.getMappedBy())) continue;
            return oneToMany.getName();
        }
        return null;
    }

    private void modifyFiles(final boolean owningSide, final String mappedBy) {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                if (AbstractCreateRelationshipHint.this.fileObject.equals(workingCopy.getFileObject()) && AbstractCreateRelationshipHint.this.targetFileObject.equals(workingCopy.getFileObject())) {
                    AbstractCreateRelationshipHint.this.modifyLocalClass(workingCopy, mappedBy, owningSide);
                    AbstractCreateRelationshipHint.this.modifyTargetClass(workingCopy, mappedBy, !owningSide);
                } else if (AbstractCreateRelationshipHint.this.fileObject.equals(workingCopy.getFileObject())) {
                    AbstractCreateRelationshipHint.this.modifyLocalClass(workingCopy, mappedBy, owningSide);
                } else {
                    AbstractCreateRelationshipHint.this.modifyTargetClass(workingCopy, mappedBy, !owningSide);
                }
            }
        };
        ClasspathInfo cpi = ClasspathInfo.create((FileObject)this.fileObject);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)cpi, (FileObject[])new FileObject[]{this.fileObject, this.targetFileObject});
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void modifyLocalClass(WorkingCopy workingCopy, String mappedBy, boolean owningSide) throws IOException {
        TypeElement localClass = (TypeElement)this.classHandle.resolve((CompilationInfo)workingCopy);
        GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
        List<Object> annArgs = null;
        annArgs = !owningSide ? Collections.singletonList(genUtils.createAnnotationArgument("mappedBy", (Object)mappedBy)) : Collections.emptyList();
        AnnotationTree ann = genUtils.createAnnotation(this.annotationClass, annArgs);
        if (this.accessType == AccessType.FIELD) {
            VariableElement field = ModelUtils.getField(localClass, this.localAttrName);
            VariableTree fieldTree = (VariableTree)workingCopy.getTrees().getTree(field);
            VariableTree modifiedTree = genUtils.addAnnotation(fieldTree, ann);
            workingCopy.rewrite((Tree)fieldTree, (Tree)modifiedTree);
        } else {
            ExecutableElement accesor = ModelUtils.getAccesor(localClass, this.localAttrName);
            MethodTree fieldTree = workingCopy.getTrees().getTree(accesor);
            MethodTree modifiedTree = genUtils.addAnnotation(fieldTree, ann);
            workingCopy.rewrite((Tree)fieldTree, (Tree)modifiedTree);
        }
    }

    private void modifyTargetClass(WorkingCopy workingCopy, String mappedBy, boolean owningSide) throws IOException {
        Object modifiedTree;
        TypeElement targetClass = workingCopy.getElements().getTypeElement(this.targetEntityClassName);
        assert (targetClass != null);
        ClassTree targetClassTree = workingCopy.getTrees().getTree(targetClass);
        GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
        String remoteFieldType = this.classHandle.getQualifiedName();
        if (this.isMultiValuedAtTargetEntity()) {
            remoteFieldType = String.format("java.util.List<%s>", remoteFieldType);
        }
        VariableTree targetField = null;
        VariableElement targetFieldElem = ModelUtils.getField(targetClass, mappedBy);
        MethodTree targetFieldAccesor = this.resolveAccessor(targetFieldElem, targetClass, workingCopy);
        ClassTree modifiedClass = targetClassTree;
        if (targetFieldElem != null) {
            targetField = (VariableTree)workingCopy.getTrees().getTree(targetFieldElem);
        } else {
            ModifiersTree fieldModifiers = workingCopy.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE));
            targetField = genUtils.createField(targetClass, fieldModifiers, mappedBy, remoteFieldType, null);
            modifiedClass = genUtils.addClassFields(targetClassTree, Collections.singletonList(targetField));
        }
        AccessType targetEntityAccessType = this.findTargetEntityAccessType(targetClass);
        if (AccessType.PROPERTY == targetEntityAccessType) {
            MethodTree targetFieldMutator = this.resolveMutator(targetFieldElem, targetClass, workingCopy);
            ModifiersTree accessorMutatorModifiers = workingCopy.getTreeMaker().Modifiers(Collections.singleton(Modifier.PUBLIC));
            if (targetFieldAccesor == null) {
                targetFieldAccesor = genUtils.createPropertyGetterMethod(targetClass, accessorMutatorModifiers, mappedBy, remoteFieldType);
                modifiedClass = workingCopy.getTreeMaker().addClassMember(modifiedClass, (Tree)targetFieldAccesor);
            }
            if (targetFieldMutator == null) {
                MethodTree mutator = genUtils.createPropertySetterMethod(targetClass, accessorMutatorModifiers, mappedBy, remoteFieldType);
                modifiedClass = workingCopy.getTreeMaker().addClassMember(modifiedClass, (Tree)mutator);
            }
        }
        workingCopy.rewrite((Tree)targetClassTree, (Tree)modifiedClass);
        List<Object> targetAnnArgs = null;
        targetAnnArgs = !owningSide ? Collections.singletonList(genUtils.createAnnotationArgument("mappedBy", (Object)this.localAttrName)) : Collections.emptyList();
        AnnotationTree targetAnn = genUtils.createAnnotation(this.complimentaryAnnotationClassName, targetAnnArgs);
        if (targetEntityAccessType == AccessType.FIELD && targetField != null) {
            if (targetField.getModifiers() != null && targetField.getModifiers().getAnnotations() != null) {
                for (AnnotationTree annotationTree : targetField.getModifiers().getAnnotations()) {
                    if (!this.complimentaryAnnotationClassName.endsWith(annotationTree.getAnnotationType().toString())) continue;
                    return;
                }
            }
            modifiedTree = genUtils.addAnnotation(targetField, targetAnn);
            workingCopy.rewrite((Tree)targetField, (Tree)modifiedTree);
        } else if (targetFieldAccesor != null) {
            if (targetFieldAccesor.getModifiers() != null && targetFieldAccesor.getModifiers().getAnnotations() != null) {
                for (AnnotationTree annotationTree : targetFieldAccesor.getModifiers().getAnnotations()) {
                    if (!this.complimentaryAnnotationClassName.endsWith(annotationTree.getAnnotationType().toString())) continue;
                    return;
                }
            }
            modifiedTree = genUtils.addAnnotation(targetFieldAccesor, targetAnn);
            workingCopy.rewrite((Tree)targetFieldAccesor, (Tree)modifiedTree);
        }
    }

    private MethodTree resolveAccessor(VariableElement fieldElem, TypeElement clazz, WorkingCopy workingCopy) {
        return this.resolvePropertyMethod(fieldElem, clazz, workingCopy, true);
    }

    private MethodTree resolveMutator(VariableElement fieldElem, TypeElement clazz, WorkingCopy workingCopy) {
        return this.resolvePropertyMethod(fieldElem, clazz, workingCopy, false);
    }

    private MethodTree resolvePropertyMethod(VariableElement fieldElem, TypeElement clazz, WorkingCopy workingCopy, boolean accessor) {
        if (fieldElem == null) {
            return null;
        }
        VariableTree field = (VariableTree)workingCopy.getTrees().getTree(fieldElem);
        ExecutableElement propertyMethod = accessor ? ModelUtils.getAccesor(clazz, field.getName().toString()) : ModelUtils.getMutator((CompilationInfo)workingCopy, clazz, fieldElem);
        return propertyMethod == null ? null : workingCopy.getTrees().getTree(propertyMethod);
    }

    private AccessType findTargetEntityAccessType(final TypeElement targetEntityClass) {
        AccessType accessType = AccessType.INDETERMINED;
        try {
            MetadataModel<EntityMappingsMetadata> emModel = ModelUtils.getModel(this.fileObject);
            accessType = (AccessType)((Object)emModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, AccessType>(){

                public AccessType run(EntityMappingsMetadata metadata) {
                    Entity remoteEntity = ModelUtils.getEntity(metadata, AbstractCreateRelationshipHint.this.targetEntityClassName);
                    assert (remoteEntity != null);
                    return JPAHelper.findAccessType(targetEntityClass, remoteEntity);
                }
            }));
        }
        catch (MetadataModelException ex) {
            JPAProblemFinder.LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            JPAProblemFinder.LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return accessType;
    }

    protected String genDefaultFieldName() {
        String defaultFieldNameBase = Utilities.getShortClassName(this.classHandle.getQualifiedName());
        char initial = Character.toLowerCase(defaultFieldNameBase.charAt(0));
        defaultFieldNameBase = initial + defaultFieldNameBase.substring(1);
        if (this.isMultiValuedAtTargetEntity()) {
            defaultFieldNameBase = defaultFieldNameBase + "s";
        }
        String defaultFieldName = null;
        int suffix = 0;
        do {
            defaultFieldName = defaultFieldNameBase + (suffix == 0 ? "" : Integer.valueOf(suffix));
            ++suffix;
        } while (this.fieldsExistingAtTargetClass.contains(defaultFieldName));
        return defaultFieldName;
    }

    public String getText() {
        return NbBundle.getMessage(AbstractCreateRelationshipHint.class, (String)"LBL_CreateRelationHint", (Object)this.relationName);
    }

    protected boolean isOwningSideByDefault() {
        return this.getAvailableRelationTypeSelection() != CreateRelationshipPanel.AvailableSelection.INVERSE_ONLY;
    }

    protected CreateRelationshipPanel.AvailableSelection getAvailableRelationTypeSelection() {
        return CreateRelationshipPanel.AvailableSelection.BOTH;
    }

    protected boolean isMultiValuedAtTargetEntity() {
        return "javax.persistence.ManyToMany".equals(this.complimentaryAnnotationClassName) || "javax.persistence.OneToMany".equals(this.complimentaryAnnotationClassName);
    }

    protected boolean isMultiValuedAtLocalEntity() {
        return "javax.persistence.ManyToMany".equals(this.annotationClass) || "javax.persistence.ManyToOne".equals(this.annotationClass);
    }
}

