/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

public class ConnectivitySettings {
    public static final int CONNECTION_DIRECT = 0;
    public static final int CONNECTION_VIA_SOCKS = 1;
    public static final int CONNECTION_VIA_HTTPS = 2;
    private static final int CONNECTION_TYPE_MIN = 0;
    private static final int CONNECTION_TYPE_MAX = 2;
    private int mConnectionType = 0;
    private String mProxyHost;
    private int mProxyPort;
    private String mProxyUsername;
    private char[] mProxyPassword;
    private int mKeepAliveIntervalSeconds = 60;

    public String toString() {
        return "Type: " + this.mConnectionType + " Proxy: " + this.mProxyUsername + "@" + this.mProxyHost + ":" + this.mProxyPort;
    }

    public void setProxy(int type, String host, int port, String username, char[] proxyPassword) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Illegal connection type");
        }
        if (type != 0) {
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("Illegal proxy port number: " + port);
            }
            if (host == null || (host = host.trim()).length() == 0) {
                throw new IllegalArgumentException("A proxy host must be specified");
            }
        }
        this.mConnectionType = type;
        this.mProxyHost = host;
        this.mProxyPort = port;
        this.mProxyUsername = username;
        this.mProxyPassword = proxyPassword;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.mKeepAliveIntervalSeconds;
    }

    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.mKeepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    public int getConnectionType() {
        return this.mConnectionType;
    }

    public void setConnectionType(int connectionType) {
        this.mConnectionType = connectionType;
    }

    public String getProxyHost() {
        return this.mProxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.mProxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.mProxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.mProxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.mProxyUsername = proxyUsername;
    }

    public char[] getProxyPassword() {
        return this.mProxyPassword;
    }

    public void setProxyPassword(char[] proxyPassword) {
        this.mProxyPassword = proxyPassword;
    }
}

