/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidJSRAnnotations
extends AbstractWebServiceRule {
    @Override
    protected ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.WebService");
        if (subject.getKind() == ElementKind.CLASS && Utilities.getAnnotationAttrValue(annEntity, "endpointInterface") != null) {
            for (String aName : new String[]{"javax.jws.WebMethod", "javax.jws.WebParam", "javax.jws.WebResult", "javax.jws.Oneway", "javax.jws.soap.SOAPMessageHandlers", "javax.jws.soap.InitParam", "javax.jws.soap.SOAPBinding", "javax.jws.soap.SOAPMessageHandler"}) {
                AnnotationMirror wrongAnnon = Utilities.findAnnotation(subject, aName);
                if (wrongAnnon == null) continue;
                String label = NbBundle.getMessage(InvalidJSRAnnotations.class, (String)"MSG_Invalid_JSR181Annotation");
                Tree problemTree = ctx.getCompilationInfo().getTrees().getTree(subject, wrongAnnon);
                RemoveAnnotation removeHC = new RemoveAnnotation(ctx.getFileObject(), subject, wrongAnnon);
                ctx.setElementToAnnotate(problemTree);
                errors.add(InvalidJSRAnnotations.createProblem((Element)subject, ctx, label, removeHC));
                ctx.setElementToAnnotate(null);
            }
        }
        return errors.isEmpty() ? null : errors.toArray(new ErrorDescription[0]);
    }
}

