/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CheckoutRevisionCommand
extends GitCommand {
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final String revision;
    private final boolean failOnConflict;
    private DirCache cache;
    private final Map<String, ObjectId> cachedContents = new HashMap<String, ObjectId>();

    public CheckoutRevisionCommand(Repository repository, GitClassFactory gitFactory, String revision, boolean failOnConflict, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.revision = revision;
        this.listener = listener;
        this.monitor = monitor;
        this.failOnConflict = failOnConflict;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            String fromName;
            Ref headRef = repository.findRef("HEAD");
            if (headRef == null) {
                throw new GitException("Corrupted repository, missing HEAD file in .git folder.");
            }
            RevTree headTree = null;
            try {
                headTree = Utils.findCommit(repository, "HEAD").getTree();
            }
            catch (GitException.MissingObjectException missingObjectException) {
                // empty catch block
            }
            Ref ref = repository.findRef(this.revision);
            if (ref != null && !ref.getName().startsWith("refs/heads/") && !ref.getName().startsWith("refs/remotes/")) {
                ref = null;
            }
            if ((fromName = headRef.getTarget().getName()).startsWith("refs/heads/")) {
                fromName = fromName.substring("refs/heads/".length());
            }
            String refLogMessage = "checkout: moving from " + fromName;
            this.cache = repository.lockDirCache();
            DirCacheCheckout dco = null;
            RevCommit commit = null;
            try {
                commit = Utils.findCommit(repository, this.revision);
                DirCacheCheckout dirCacheCheckout = dco = headTree == null ? new DirCacheCheckout(repository, this.cache, (ObjectId)commit.getTree()) : new DirCacheCheckout(repository, (ObjectId)headTree, this.cache, (ObjectId)commit.getTree());
                if (!this.failOnConflict) {
                    dco.preScanTwoTrees();
                    this.cacheContents(dco.getConflicts());
                    dco = headTree == null ? new DirCacheCheckout(repository, this.cache, (ObjectId)commit.getTree()) : new DirCacheCheckout(repository, (ObjectId)headTree, this.cache, (ObjectId)commit.getTree());
                }
                dco.setFailOnConflict(this.failOnConflict);
                dco.checkout();
                this.cache.lock();
                File workDir = repository.getWorkTree();
                this.notify(workDir, dco.getRemoved());
                this.notify(workDir, dco.getConflicts());
                this.notify(workDir, dco.getUpdated().keySet());
                if (!this.failOnConflict && dco.getConflicts().size() > 0) {
                    this.mergeConflicts(dco.getConflicts(), this.cache);
                }
            }
            catch (InvalidPathException ex) {
                throw new GitException("Commit " + commit.name() + " cannot be checked out because an invalid file name in one of the files.\nPlease remove the file from repository with an external tool and try again.\n\n" + ex.getMessage());
            }
            catch (CheckoutConflictException ex) {
                List conflicts = dco.getConflicts();
                throw new GitException.CheckoutConflictException(conflicts.toArray(new String[0]), (Throwable)ex);
            }
            finally {
                this.cache.unlock();
            }
            if (!this.monitor.isCanceled()) {
                RefUpdate.Result updateResult;
                String toName;
                boolean detach = true;
                if (ref == null) {
                    toName = commit.getName();
                } else {
                    toName = ref.getName();
                    if (toName.startsWith("refs/heads/")) {
                        detach = false;
                        toName = toName.substring("refs/heads/".length());
                    } else if (toName.startsWith("refs/remotes/")) {
                        toName = toName.substring("refs/remotes/".length());
                    }
                }
                RefUpdate refUpdate = repository.updateRef("HEAD", detach);
                refUpdate.setForceUpdate(false);
                refUpdate.setRefLogMessage(refLogMessage + " to " + toName, false);
                if (!detach) {
                    updateResult = refUpdate.link(ref.getName());
                } else {
                    refUpdate.setNewObjectId((AnyObjectId)commit);
                    updateResult = refUpdate.forceUpdate();
                }
                boolean ok = false;
                switch (updateResult) {
                    case NEW: {
                        ok = true;
                        break;
                    }
                    case NO_CHANGE: 
                    case FAST_FORWARD: 
                    case FORCED: {
                        ok = true;
                        break;
                    }
                }
                if (!ok) {
                    throw new GitException("Unexpected result: " + updateResult.name());
                }
            }
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean canExecute = super.prepareCommand();
        if (canExecute) {
            Repository repository = this.getRepository();
            try {
                if (!this.failOnConflict && repository.readDirCache().hasUnmergedPaths()) {
                    String message = MessageFormat.format(Utils.getBundle(GitCommand.class).getString("MSG_Error_CannotCheckoutHasConflicts"), repository.getWorkTree());
                    this.monitor.preparationsFailed(message);
                    throw new GitException(message);
                }
            }
            catch (IOException ex) {
                throw new GitException(ex);
            }
        }
        return canExecute;
    }

    @Override
    protected String getCommandDescription() {
        return "git checkout " + this.revision;
    }

    private void notify(File workDir, Collection<String> paths) {
        for (String path : paths) {
            File f = new File(workDir, path);
            this.listener.notifyFile(f, path);
        }
    }

    private void cacheContents(List<String> conflicts) throws IOException {
        File workTree = this.getRepository().getWorkTree();
        WorkingTreeOptions opt = (WorkingTreeOptions)this.getRepository().getConfig().get(WorkingTreeOptions.KEY);
        boolean autocrlf = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE;
        try (ObjectInserter inserter = this.getRepository().newObjectInserter();){
            for (String path : conflicts) {
                File f = new File(workTree, path);
                Path p = null;
                try {
                    p = f.toPath();
                }
                catch (java.nio.file.InvalidPathException ex) {
                    Logger.getLogger(CheckoutRevisionCommand.class.getName()).log(Level.FINE, null, ex);
                }
                if (p != null && Files.isSymbolicLink(p)) {
                    Path link = Utils.getLinkPath(p);
                    this.cachedContents.put(path, inserter.insert(3, Constants.encode((String)link.toString())));
                    continue;
                }
                if (!f.isFile()) continue;
                long sz = f.length();
                try (FileInputStream in = new FileInputStream(f);){
                    if (autocrlf) {
                        ByteBuffer buf = IO.readWholeStream((InputStream)in, (int)((int)sz));
                        this.cachedContents.put(path, inserter.insert(3, buf.array(), buf.position(), buf.limit() - buf.position()));
                        continue;
                    }
                    this.cachedContents.put(path, inserter.insert(3, sz, (InputStream)in));
                }
            }
            inserter.flush();
        }
    }

    private void mergeConflicts(List<String> conflicts, DirCache cache) throws GitException {
        DirCacheBuilder builder = cache.builder();
        DirCacheBuildIterator dci = new DirCacheBuildIterator(builder);
        ObjectDatabase od = null;
        DiffAlgorithm.SupportedAlgorithm diffAlg = (DiffAlgorithm.SupportedAlgorithm)this.getRepository().getConfig().getEnum("diff", null, "algorithm", (Enum)DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        MergeAlgorithm merger = new MergeAlgorithm(DiffAlgorithm.getAlgorithm((DiffAlgorithm.SupportedAlgorithm)diffAlg));
        try (TreeWalk walk = new TreeWalk(this.getRepository());){
            od = this.getRepository().getObjectDatabase();
            walk.addTree((AbstractTreeIterator)dci);
            walk.setFilter(PathFilterGroup.create(Utils.getPathFilters(conflicts)));
            String lastPath = null;
            DirCacheEntry[] entries = new DirCacheEntry[3];
            walk.setRecursive(true);
            while (walk.next()) {
                DirCacheEntry e = ((DirCacheIterator)walk.getTree(0, DirCacheIterator.class)).getDirCacheEntry();
                String path = e.getPathString();
                if (lastPath != null && !lastPath.equals(path)) {
                    this.resolveEntries(merger, lastPath, entries, od, builder);
                }
                if (e.getStage() == 0) {
                    DirCacheIterator c = (DirCacheIterator)walk.getTree(0, DirCacheIterator.class);
                    builder.add(c.getDirCacheEntry());
                    continue;
                }
                entries[e.getStage() - 1] = e;
                lastPath = path;
            }
            this.resolveEntries(merger, lastPath, entries, od, builder);
            builder.commit();
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            if (od != null) {
                od.close();
            }
        }
    }

    private void resolveEntries(MergeAlgorithm merger, String path, DirCacheEntry[] entries, ObjectDatabase db, DirCacheBuilder builder) throws IOException {
        if (entries[0] == null && entries[1] == null && entries[2] == null) {
            return;
        }
        DirCacheEntry base = entries[0];
        DirCacheEntry theirs = entries[2];
        ObjectId oursId = this.cachedContents.get(path);
        Repository repository = this.getRepository();
        boolean added = false;
        if (oursId != null) {
            if (theirs != null && (theirs.getFileMode().getBits() & 0x8000) == 32768) {
                RawText baseText = base == null ? RawText.EMPTY_TEXT : Utils.getRawText(base.getObjectId(), db);
                RawText ourText = Utils.getRawText(oursId, db);
                RawText theirsText = Utils.getRawText(theirs.getObjectId(), db);
                MergeResult merge = merger.merge((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)baseText, (Sequence)ourText, (Sequence)theirsText);
                this.checkoutFile((MergeResult<RawText>)merge, path);
                if (!merge.containsConflicts()) {
                    added = true;
                    DirCacheEntry e = new DirCacheEntry(path);
                    e.setCreationTime(theirs.getCreationTime());
                    e.setFileMode(theirs.getFileMode());
                    e.setLastModified(theirs.getLastModifiedInstant());
                    e.setLength(theirs.getLength());
                    e.setObjectId((AnyObjectId)theirs.getObjectId());
                    builder.add(e);
                }
            } else {
                File file = new File(this.getRepository().getWorkTree(), path);
                file.getParentFile().mkdirs();
                WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                ObjectLoader loader = repository.getObjectDatabase().open((AnyObjectId)oursId);
                try (Object fos = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE ? new AutoCRLFOutputStream((OutputStream)new FileOutputStream(file)) : new FileOutputStream(file);){
                    loader.copyTo((OutputStream)fos);
                }
            }
        }
        if (!added) {
            for (DirCacheEntry e : entries) {
                if (e == null) continue;
                builder.add(e);
            }
        }
        entries[2] = null;
        entries[1] = null;
        entries[0] = null;
    }

    private void checkoutFile(MergeResult<RawText> merge, String path) throws IOException {
        File file = new File(this.getRepository().getWorkTree(), path);
        file.getParentFile().mkdirs();
        MergeFormatter format = new MergeFormatter();
        WorkingTreeOptions opt = (WorkingTreeOptions)this.getRepository().getConfig().get(WorkingTreeOptions.KEY);
        try (Object fos = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE ? new AutoCRLFOutputStream((OutputStream)new FileOutputStream(file)) : new FileOutputStream(file);){
            format.formatMerge((OutputStream)fos, merge, Arrays.asList("BASE", "OURS", "THEIRS"), StandardCharsets.UTF_8);
        }
    }
}

