/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ExportImageDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ExportImageRequest
extends BmcRequest<ExportImageDetails> {
    private String imageId;
    private ExportImageDetails exportImageDetails;
    private String opcRetryToken;
    private String ifMatch;

    public String getImageId() {
        return this.imageId;
    }

    public ExportImageDetails getExportImageDetails() {
        return this.exportImageDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ExportImageDetails getBody$() {
        return this.exportImageDetails;
    }

    public Builder toBuilder() {
        return new Builder().imageId(this.imageId).exportImageDetails(this.exportImageDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",imageId=").append(String.valueOf(this.imageId));
        sb.append(",exportImageDetails=").append(String.valueOf((Object)this.exportImageDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportImageRequest)) {
            return false;
        }
        ExportImageRequest other = (ExportImageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.imageId, other.imageId) && Objects.equals((Object)this.exportImageDetails, (Object)other.exportImageDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.exportImageDetails == null ? 43 : this.exportImageDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportImageRequest, ExportImageDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String imageId = null;
        private ExportImageDetails exportImageDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder exportImageDetails(ExportImageDetails exportImageDetails) {
            this.exportImageDetails = exportImageDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportImageRequest o) {
            this.imageId(o.getImageId());
            this.exportImageDetails(o.getExportImageDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportImageRequest build() {
            ExportImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportImageDetails body) {
            this.exportImageDetails(body);
            return this;
        }

        public ExportImageRequest buildWithoutInvocationCallback() {
            ExportImageRequest request = new ExportImageRequest();
            request.imageId = this.imageId;
            request.exportImageDetails = this.exportImageDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

