/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BugzillaFlag
implements Serializable {
    private static final long serialVersionUID = -3149026741475639885L;
    private final String name;
    private final String description;
    private final String type;
    private final boolean requestable;
    private final boolean specifically_requestable;
    private final boolean multiplicable;
    private final int flagId;
    private final Map<String, List<String>> used = new HashMap<String, List<String>>();

    public BugzillaFlag(String name, String description, String type, String requestable, String specifically_requestable, String multiplicable, int flagId) {
        this.description = description;
        this.name = name;
        this.type = type;
        this.flagId = flagId;
        this.multiplicable = multiplicable != null && !multiplicable.equals("") ? multiplicable.equals("1") : false;
        this.requestable = requestable != null && !requestable.equals("") ? requestable.equals("1") : false;
        this.specifically_requestable = specifically_requestable != null && !specifically_requestable.equals("") ? specifically_requestable.equals("1") : false;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequestable() {
        return this.requestable;
    }

    public boolean isSpecifically_requestable() {
        return this.specifically_requestable;
    }

    public boolean isMultiplicable() {
        return this.multiplicable;
    }

    public int getFlagId() {
        return this.flagId;
    }

    public void addUsed(String product, String component) {
        List<String> componentList = this.used.get(product);
        if (componentList == null) {
            componentList = new ArrayList<String>();
            this.used.put(product, componentList);
        }
        if (!componentList.contains(component)) {
            componentList.add(component);
        }
    }

    public boolean isUsedIn(String product, String component) {
        List<String> componentList = this.used.get(product);
        return componentList != null && componentList.contains(component);
    }
}

