/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtype.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XFunctionTypeRefs {
    private static final ClassURIHelper classURIHelper = new ClassURIHelper();
    private static final List<String> procedureURIs = new ArrayList<String>();
    private static final List<String> functionURIs = new ArrayList<String>();
    private static final String procedureURI = "java:/Objects/" + Procedures.class.getCanonicalName() + "#" + Procedures.class.getCanonicalName() + "$Procedure";
    private static final String functionURI = "java:/Objects/" + Functions.class.getCanonicalName() + "#" + Functions.class.getCanonicalName() + "$Function";

    static {
        int index = 0;
        while (index <= 6) {
            procedureURIs.add(procedureURI + index);
            functionURIs.add(functionURI + index);
            ++index;
        }
    }

    public static URI computeTypeUri(boolean procedure, int functionParamCount) {
        return URI.createURI((String)XFunctionTypeRefs.buildUri(procedure, functionParamCount));
    }

    public static String buildUri(boolean procedure, int functionParamCount) {
        int paramCount = Math.min(6, functionParamCount);
        if (procedure) {
            return procedureURIs.get(paramCount);
        }
        return functionURIs.get(paramCount);
    }

    public static URI computeTypeUri(Class<?> topLevelClass) {
        return classURIHelper.getFullURI(topLevelClass);
    }

    public static JvmTypeReference wrapIfNecessary(JvmTypeReference reference, JvmType type) {
        if (type instanceof JvmPrimitiveType) {
            JvmType wrappedType = XFunctionTypeRefs.getWrappedType(type);
            if (wrappedType == null) {
                return reference;
            }
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            result.setType(wrappedType);
            return result;
        }
        if (type instanceof JvmVoid && !((JvmVoid)type).eIsProxy()) {
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            result.setType(XFunctionTypeRefs.getType(Void.class, (EObject)type));
            return result;
        }
        return reference;
    }

    public static JvmType getWrappedType(JvmType type) {
        String name = type.getIdentifier();
        if ("int".equals(name)) {
            return XFunctionTypeRefs.getType(Integer.class, (EObject)type);
        }
        if ("boolean".equals(name)) {
            return XFunctionTypeRefs.getType(Boolean.class, (EObject)type);
        }
        if ("char".equals(name)) {
            return XFunctionTypeRefs.getType(Character.class, (EObject)type);
        }
        if ("long".equals(name)) {
            return XFunctionTypeRefs.getType(Long.class, (EObject)type);
        }
        if ("double".equals(name)) {
            return XFunctionTypeRefs.getType(Double.class, (EObject)type);
        }
        if ("byte".equals(name)) {
            return XFunctionTypeRefs.getType(Byte.class, (EObject)type);
        }
        if ("float".equals(name)) {
            return XFunctionTypeRefs.getType(Float.class, (EObject)type);
        }
        if ("short".equals(name)) {
            return XFunctionTypeRefs.getType(Short.class, (EObject)type);
        }
        return null;
    }

    public static JvmType getType(Class<?> clazz, EObject context) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmVoid();
        proxy.eSetProxyURI(XFunctionTypeRefs.computeTypeUri(clazz));
        return (JvmType)EcoreUtil.resolve((EObject)proxy, (EObject)context);
    }
}

