/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.StringsWithLengthBlock;

class BooleanColumn
extends AbstractColumn {
    private String[] m_options;

    BooleanColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 34;
    }

    @Override
    protected int readData(byte[] byArray, int n) {
        StringsWithLengthBlock stringsWithLengthBlock = new StringsWithLengthBlock().read(byArray, n, false);
        this.m_options = stringsWithLengthBlock.getData();
        n = stringsWithLengthBlock.getOffset();
        n = FastTrackUtility.skipToNextMatchingShort(byArray, n, 15);
        int n2 = FastTrackUtility.getInt(byArray, n) + 1;
        FastTrackUtility.validateSize(n2);
        this.m_data = new Boolean[n2];
        n += 4;
        n += 4;
        n += this.m_data.length * 4;
        n += 4;
        for (int i = 0; i < this.m_data.length; ++i) {
            int n3 = FastTrackUtility.getShort(byArray, n);
            n += 2;
            if (n3 == 2) continue;
            this.m_data[i] = n3 == 1;
        }
        return n;
    }

    @Override
    protected void dumpData(PrintWriter printWriter) {
        printWriter.println("  [Options");
        for (String object : this.m_options) {
            printWriter.println("    " + object);
        }
        printWriter.println("  ]");
        printWriter.println("  [Data");
        for (Object object : this.m_data) {
            printWriter.println("    " + object);
        }
        printWriter.println("  ]");
    }
}

