/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class FileSystem {
    @CachedReturnPlugin.Enhance(value="INSTANCE")
    public static FileSystem getInstance() {
        try {
            Class.forName("java.nio.file.Files", false, ClassLoadingStrategy.BOOTSTRAP_LOADER);
            return new ForNio2CapableVm();
        }
        catch (ClassNotFoundException ignored) {
            return new ForLegacyVm();
        }
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    public abstract void copy(File var1, File var2) throws IOException;

    public void link(File source, File target) throws IOException {
        this.copy(source, target);
    }

    public abstract void move(File var1, File var2) throws IOException;

    static /* synthetic */ Object access$000(PrivilegedAction x0) {
        return FileSystem.doPrivileged(x0);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForNio2CapableVm
    extends FileSystem {
        private static final Dispatcher DISPATCHER = (Dispatcher)FileSystem.access$000(JavaDispatcher.of(Dispatcher.class));
        private static final Files FILES = (Files)FileSystem.access$000(JavaDispatcher.of(Files.class));
        private static final StandardCopyOption STANDARD_COPY_OPTION = (StandardCopyOption)FileSystem.access$000(JavaDispatcher.of(StandardCopyOption.class));

        protected ForNio2CapableVm() {
        }

        @Override
        public void copy(File source, File target) throws IOException {
            Object[] option = STANDARD_COPY_OPTION.toArray(1);
            option[0] = STANDARD_COPY_OPTION.valueOf("REPLACE_EXISTING");
            FILES.copy(DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
        }

        @Override
        public void link(File source, File target) throws IOException {
            FILES.createLink(FILES.deleteIfExists(DISPATCHER.toPath(target)), DISPATCHER.toPath(source));
        }

        @Override
        public void move(File source, File target) throws IOException {
            Object[] option = STANDARD_COPY_OPTION.toArray(1);
            option[0] = STANDARD_COPY_OPTION.valueOf("REPLACE_EXISTING");
            FILES.move(DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @JavaDispatcher.Proxied(value="java.nio.file.StandardCopyOption")
        protected static interface StandardCopyOption {
            @JavaDispatcher.Container
            public Object[] toArray(int var1);

            @JavaDispatcher.IsStatic
            public Object valueOf(String var1);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @JavaDispatcher.Proxied(value="java.nio.file.Files")
        protected static interface Files {
            @JavaDispatcher.IsStatic
            public Object copy(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object var1, @JavaDispatcher.Proxied(value="java.nio.file.Path") Object var2, @JavaDispatcher.Proxied(value="java.nio.file.CopyOption") Object[] var3) throws IOException;

            @JavaDispatcher.IsStatic
            public Object createLink(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object var1, @JavaDispatcher.Proxied(value="java.nio.file.Path") Object var2) throws IOException;

            @JavaDispatcher.IsStatic
            public Object move(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object var1, @JavaDispatcher.Proxied(value="java.nio.file.Path") Object var2, @JavaDispatcher.Proxied(value="java.nio.file.CopyOption") Object[] var3) throws IOException;

            @JavaDispatcher.IsStatic
            public Object deleteIfExists(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object var1) throws IOException;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @JavaDispatcher.Proxied(value="java.io.File")
        protected static interface Dispatcher {
            public Object toPath(File var1) throws IOException;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForLegacyVm
    extends FileSystem {
        protected ForLegacyVm() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(File source, File target) throws IOException {
            try (FileInputStream inputStream = new FileInputStream(source);
                 FileOutputStream outputStream = new FileOutputStream(target);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void move(File source, File target) throws IOException {
            try (FileInputStream inputStream = new FileInputStream(source);
                 FileOutputStream outputStream = new FileOutputStream(target);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
            if (!source.delete()) {
                source.deleteOnExit();
            }
        }
    }
}

