/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.analysis.AnalysisException;
import com.android.tools.smali.dexlib2.analysis.ClassPath;
import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.util.ExceptionWithContext;
import java.io.IOException;
import java.io.Writer;

public class RegisterType {
    public final byte category;
    public final TypeProto type;
    public static final String[] CATEGORY_NAMES = new String[]{"Unknown", "Uninit", "Null", "One", "Boolean", "Byte", "PosByte", "Short", "PosShort", "Char", "Integer", "Float", "LongLo", "LongHi", "DoubleLo", "DoubleHi", "UninitRef", "UninitThis", "Reference", "Conflicted"};
    protected static byte[][] mergeTable = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19}, {1, 1, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, {2, 19, 2, 4, 4, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 18, 19}, {3, 19, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {4, 19, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {5, 19, 5, 5, 5, 5, 5, 7, 7, 10, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {6, 19, 6, 6, 6, 5, 6, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {7, 19, 7, 7, 7, 7, 7, 7, 7, 10, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {8, 19, 8, 8, 8, 7, 8, 7, 8, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {9, 19, 9, 9, 9, 10, 9, 10, 9, 9, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {10, 19, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 19, 19, 19, 19, 19, 19, 19, 19}, {11, 19, 11, 11, 11, 11, 11, 11, 11, 11, 10, 11, 19, 19, 19, 19, 19, 19, 19, 19}, {12, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 12, 19, 12, 19, 19, 19, 19, 19}, {13, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 13, 19, 13, 19, 19, 19, 19}, {14, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 12, 19, 14, 19, 19, 19, 19, 19}, {15, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 13, 19, 15, 19, 19, 19, 19}, {16, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, {17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 17, 19, 19}, {18, 19, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18, 19}, {19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}};
    public static final RegisterType UNKNOWN_TYPE = new RegisterType(0, null);
    public static final RegisterType UNINIT_TYPE = new RegisterType(1, null);
    public static final RegisterType NULL_TYPE = new RegisterType(2, null);
    public static final RegisterType ONE_TYPE = new RegisterType(3, null);
    public static final RegisterType BOOLEAN_TYPE = new RegisterType(4, null);
    public static final RegisterType BYTE_TYPE = new RegisterType(5, null);
    public static final RegisterType POS_BYTE_TYPE = new RegisterType(6, null);
    public static final RegisterType SHORT_TYPE = new RegisterType(7, null);
    public static final RegisterType POS_SHORT_TYPE = new RegisterType(8, null);
    public static final RegisterType CHAR_TYPE = new RegisterType(9, null);
    public static final RegisterType INTEGER_TYPE = new RegisterType(10, null);
    public static final RegisterType FLOAT_TYPE = new RegisterType(11, null);
    public static final RegisterType LONG_LO_TYPE = new RegisterType(12, null);
    public static final RegisterType LONG_HI_TYPE = new RegisterType(13, null);
    public static final RegisterType DOUBLE_LO_TYPE = new RegisterType(14, null);
    public static final RegisterType DOUBLE_HI_TYPE = new RegisterType(15, null);
    public static final RegisterType CONFLICTED_TYPE = new RegisterType(19, null);

    private RegisterType(byte category, TypeProto type) {
        assert ((category == 18 || category == 16 || category == 17) && type != null || category != 18 && category != 16 && category != 17 && type == null);
        this.category = category;
        this.type = type;
    }

    public String toString() {
        return "(" + CATEGORY_NAMES[this.category] + (this.type == null ? "" : "," + this.type) + ")";
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(40);
        writer.write(CATEGORY_NAMES[this.category]);
        if (this.type != null) {
            writer.write(44);
            writer.write(this.type.getType());
        }
        writer.write(41);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterType that = (RegisterType)o;
        if (this.category != that.category) {
            return false;
        }
        if (this.category == 16 || this.category == 17) {
            return false;
        }
        return this.type != null ? this.type.equals(that.type) : that.type == null;
    }

    public int hashCode() {
        int result = this.category;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static RegisterType getWideRegisterType(CharSequence type, boolean firstRegister) {
        switch (type.charAt(0)) {
            case 'J': {
                if (firstRegister) {
                    return RegisterType.getRegisterType((byte)12, null);
                }
                return RegisterType.getRegisterType((byte)13, null);
            }
            case 'D': {
                if (firstRegister) {
                    return RegisterType.getRegisterType((byte)14, null);
                }
                return RegisterType.getRegisterType((byte)15, null);
            }
        }
        throw new ExceptionWithContext("Cannot use this method for narrow register type: %s", type);
    }

    public static RegisterType getRegisterType(ClassPath classPath, CharSequence type) {
        switch (type.charAt(0)) {
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'I': {
                return INTEGER_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_LO_TYPE;
            }
            case 'D': {
                return DOUBLE_LO_TYPE;
            }
            case 'L': 
            case '[': {
                return RegisterType.getRegisterType((byte)18, classPath.getClass(type));
            }
        }
        throw new AnalysisException("Invalid type: " + type, new Object[0]);
    }

    public static RegisterType getRegisterTypeForLiteral(int literalValue) {
        if (literalValue < Short.MIN_VALUE) {
            return INTEGER_TYPE;
        }
        if (literalValue < -128) {
            return SHORT_TYPE;
        }
        if (literalValue < 0) {
            return BYTE_TYPE;
        }
        if (literalValue == 0) {
            return NULL_TYPE;
        }
        if (literalValue == 1) {
            return ONE_TYPE;
        }
        if (literalValue < 128) {
            return POS_BYTE_TYPE;
        }
        if (literalValue < 32768) {
            return POS_SHORT_TYPE;
        }
        if (literalValue < 65536) {
            return CHAR_TYPE;
        }
        return INTEGER_TYPE;
    }

    public RegisterType merge(RegisterType other) {
        if (other.equals(this)) {
            return this;
        }
        byte mergedCategory = mergeTable[this.category][other.category];
        TypeProto mergedType = null;
        if (mergedCategory == 18) {
            TypeProto type = this.type;
            mergedType = type != null ? (other.type != null ? type.getCommonSuperclass(other.type) : type) : other.type;
        } else if (mergedCategory == 16 || mergedCategory == 17) {
            if (this.category == 0) {
                return other;
            }
            assert (other.category == 0);
            return this;
        }
        if (mergedType != null) {
            if (mergedType.equals(this.type)) {
                return this;
            }
            if (mergedType.equals(other.type)) {
                return other;
            }
        }
        return RegisterType.getRegisterType(mergedCategory, mergedType);
    }

    public static RegisterType getRegisterType(byte category, TypeProto typeProto) {
        switch (category) {
            case 0: {
                return UNKNOWN_TYPE;
            }
            case 1: {
                return UNINIT_TYPE;
            }
            case 2: {
                return NULL_TYPE;
            }
            case 3: {
                return ONE_TYPE;
            }
            case 4: {
                return BOOLEAN_TYPE;
            }
            case 5: {
                return BYTE_TYPE;
            }
            case 6: {
                return POS_BYTE_TYPE;
            }
            case 7: {
                return SHORT_TYPE;
            }
            case 8: {
                return POS_SHORT_TYPE;
            }
            case 9: {
                return CHAR_TYPE;
            }
            case 10: {
                return INTEGER_TYPE;
            }
            case 11: {
                return FLOAT_TYPE;
            }
            case 12: {
                return LONG_LO_TYPE;
            }
            case 13: {
                return LONG_HI_TYPE;
            }
            case 14: {
                return DOUBLE_LO_TYPE;
            }
            case 15: {
                return DOUBLE_HI_TYPE;
            }
            case 19: {
                return CONFLICTED_TYPE;
            }
        }
        return new RegisterType(category, typeProto);
    }
}

