/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.utils;

import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.sections.SectionReader;

public class MUtf8 {
    public static String decode(SectionReader in) {
        int len = in.readUleb128();
        char[] out = new char[len];
        int k = 0;
        while (true) {
            int b;
            char a;
            if ((a = (char)(in.readUByte() & 0xFF)) == '\u0000') {
                return new String(out, 0, k);
            }
            out[k] = a;
            if (a < '\u0080') {
                ++k;
                continue;
            }
            if ((a & 0xE0) == 192) {
                b = in.readUByte();
                if ((b & 0xC0) != 128) {
                    throw new DexException("Bad second byte");
                }
                out[k] = (char)((a & 0x1F) << 6 | b & 0x3F);
                ++k;
                continue;
            }
            if ((a & 0xF0) != 224) break;
            b = in.readUByte();
            int c = in.readUByte();
            if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                throw new DexException("Bad second or third byte");
            }
            out[k] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
            ++k;
        }
        throw new DexException("Bad byte");
    }
}

