/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;

public class CaseStatementDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping {
    private final LinkedHashMap<String, TableDiscriminatorDetails> tableDiscriminatorDetailsMap = new LinkedHashMap();

    public CaseStatementDiscriminatorMappingImpl(JoinedSubclassEntityPersister entityDescriptor, String[] tableNames, int[] notNullColumnTableNumbers, String[] notNullColumnNames, String[] discriminatorValues, boolean[] discriminatorAbstract, DiscriminatorType<?> incomingDiscriminatorType) {
        super(entityDescriptor, incomingDiscriminatorType, incomingDiscriminatorType.getUnderlyingJdbcMapping());
        for (int i = 0; i < discriminatorValues.length; ++i) {
            if (discriminatorAbstract[i]) continue;
            String tableName = tableNames[notNullColumnTableNumbers[i]];
            String oneSubEntityColumn = notNullColumnNames[i];
            String discriminatorValue = discriminatorValues[i];
            this.tableDiscriminatorDetailsMap.put(tableName, new TableDiscriminatorDetails(tableName, oneSubEntityColumn, this.getUnderlyingJdbcMapping().getJavaTypeDescriptor().wrap(discriminatorValue, null)));
        }
    }

    @Override
    public boolean hasPhysicalColumn() {
        return false;
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        this.resolveSubTypeTableReferences(tableGroup, navigablePath);
        return super.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public BasicFetch<?> generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        this.resolveSubTypeTableReferences(tableGroup, fetchablePath);
        return super.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }

    private void resolveSubTypeTableReferences(TableGroup tableGroup, NavigablePath navigablePath) {
        EntityMappingType entityDescriptor = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
        for (EntityMappingType subMappingType : entityDescriptor.getSubMappingTypes()) {
            tableGroup.getTableReference(navigablePath, subMappingType.getMappedTableDetails().getTableName(), true);
        }
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        return expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getSelectionExpression(), jdbcMappingToUse), sqlAstProcessingState -> this.createCaseSearchedExpression(tableGroup));
    }

    private Expression createCaseSearchedExpression(TableGroup entityTableGroup) {
        return new CaseStatementDiscriminatorExpression(entityTableGroup);
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return null;
    }

    @Override
    public Long getLength() {
        return null;
    }

    @Override
    public Integer getPrecision() {
        return null;
    }

    @Override
    public Integer getTemporalPrecision() {
        return null;
    }

    @Override
    public Integer getScale() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public String getContainingTableExpression() {
        return this.getEntityDescriptor().getMappedTableDetails().getTableName();
    }

    @Override
    public String getSelectionExpression() {
        return "{discriminator}";
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    public final class CaseStatementDiscriminatorExpression
    implements SelfRenderingExpression {
        private final TableGroup entityTableGroup;
        CaseSearchedExpression caseSearchedExpression;

        public CaseStatementDiscriminatorExpression(TableGroup entityTableGroup) {
            this.entityTableGroup = entityTableGroup;
        }

        public List<TableReference> getUsedTableReferences() {
            ArrayList<TableReference> usedTableReferences = new ArrayList<TableReference>(CaseStatementDiscriminatorMappingImpl.this.tableDiscriminatorDetailsMap.size());
            CaseStatementDiscriminatorMappingImpl.this.tableDiscriminatorDetailsMap.forEach((tableName, tableDiscriminatorDetails) -> {
                TableReference tableReference = this.entityTableGroup.getTableReference(this.entityTableGroup.getNavigablePath(), (String)tableName, false);
                if (tableReference != null) {
                    usedTableReferences.add(tableReference);
                }
            });
            return usedTableReferences;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            if (this.caseSearchedExpression == null) {
                this.caseSearchedExpression = new CaseSearchedExpression(CaseStatementDiscriminatorMappingImpl.this);
                CaseStatementDiscriminatorMappingImpl.this.tableDiscriminatorDetailsMap.forEach((tableName, tableDiscriminatorDetails) -> {
                    TableReference tableReference = this.entityTableGroup.getTableReference(this.entityTableGroup.getNavigablePath(), (String)tableName, false);
                    if (tableReference == null) {
                        return;
                    }
                    NullnessPredicate predicate = new NullnessPredicate(new ColumnReference(tableReference, tableDiscriminatorDetails.getCheckColumnName(), false, null, CaseStatementDiscriminatorMappingImpl.this.getJdbcMapping()), true);
                    this.caseSearchedExpression.when(predicate, new QueryLiteral<Object>(tableDiscriminatorDetails.getDiscriminatorValue(), (SqlExpressible)((Object)CaseStatementDiscriminatorMappingImpl.this.getUnderlyingJdbcMapping())));
                });
            }
            this.caseSearchedExpression.accept(walker);
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return CaseStatementDiscriminatorMappingImpl.this;
        }
    }

    private static class TableDiscriminatorDetails {
        private final String tableName;
        private final String checkColumnName;
        private final Object discriminatorValue;

        public TableDiscriminatorDetails(String tableName, String checkColumnName, Object discriminatorValue) {
            this.tableName = tableName;
            this.checkColumnName = checkColumnName;
            this.discriminatorValue = discriminatorValue;
        }

        Object getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        String getCheckColumnName() {
            return this.checkColumnName;
        }

        public String toString() {
            return "TableDiscriminatorDetails(`" + this.tableName + "." + this.checkColumnName + "` = " + this.discriminatorValue + ")";
        }
    }
}

