/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.util.HashMap;
import java.util.Map;

public class Scope {
    public static final Scope EMPTY = new Scope(null){

        @Override
        public void putBinding(String binding, String type) {
            throw new UnsupportedOperationException("Immutable empty scope");
        }
    };
    private final Scope parentScope;
    private Map<String, String> bindings;
    private Map<String, Object> attributes;
    private String lastPartHint;

    public Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public void putBinding(String binding, String type) {
        if (this.bindings == null) {
            this.bindings = new HashMap<String, String>();
        }
        this.bindings.put(binding, this.sanitizeType(type));
    }

    public String getBinding(String binding) {
        if (this.bindings != null && this.bindings.containsKey(binding)) {
            return this.bindings.get(binding);
        }
        return this.parentScope != null ? this.parentScope.getBinding(binding) : null;
    }

    Map<String, String> getBindings() {
        return this.bindings;
    }

    public String getBindingTypeOrDefault(String binding, String defaultValue) {
        String type = this.getBinding(binding);
        return type != null ? type : defaultValue;
    }

    public void putAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public String getLastPartHint() {
        return this.lastPartHint;
    }

    public void setLastPartHint(String lastPartHint) {
        this.lastPartHint = lastPartHint;
    }

    private String sanitizeType(String type) {
        if (type != null && type.contains("?")) {
            String upperBound = " extends ";
            String lowerBound = " super ";
            type = type.contains(upperBound) ? type.replace("?", "").replace(upperBound, "").trim() : (type.contains(lowerBound) ? type.replace("?", "").replace(lowerBound, "").trim() : type.replace("?", "java.lang.Object"));
        }
        return type;
    }
}

