/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.ast.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.ast.TruffleNode;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakListeners;

public class ASTTreeModel
implements TreeModel,
PropertyChangeListener {
    private final JPDADebugger debugger;
    private final Set<ModelListener> listeners = new CopyOnWriteArraySet<ModelListener>();

    public ASTTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", WeakListeners.propertyChange((PropertyChangeListener)this, (String)"currentCallStackFrame", (Object)this.debugger));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            JPDAThread currentThread = this.debugger.getCurrentThread();
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(currentThread);
            if (currentPCInfo == null) {
                return new Object[0];
            }
            TruffleNode ast = currentPCInfo.getAST(currentPCInfo.getSelectedStackFrame());
            if (ast != null) {
                return new Object[]{ast};
            }
            return new Object[0];
        }
        if (parent instanceof TruffleNode) {
            return ((TruffleNode)parent).getChildren();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof TruffleNode) {
            return ((TruffleNode)node).getChildren().length == 0;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }
}

