/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class XmlFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    static final String DECODER_SELECTED = "decoder-selected";
    static final String ENCODER_SELECTED = "encoder-selected";
    private static final Logger LOG = Logger.getLogger(XmlFileEncodingQueryImpl.class.getName());
    private static final XmlFileEncodingQueryImpl singleton = new XmlFileEncodingQueryImpl();

    private XmlFileEncodingQueryImpl() {
    }

    public static XmlFileEncodingQueryImpl singleton() {
        return singleton;
    }

    public synchronized Charset getEncoding(FileObject file) {
        assert (file != null);
        return new XMLCharset();
    }

    private static class XMLCharset
    extends Charset {
        public XMLCharset() {
            super("UTF-8", new String[0]);
        }

        @Override
        public boolean contains(Charset c) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return new XMLDecoder(this);
        }

        @Override
        public CharsetEncoder newEncoder() {
            return new XMLEncoder(this);
        }
    }

    private static class XMLDecoder
    extends CharsetDecoder {
        private ByteBuffer buffer = ByteBuffer.allocate(4096);
        private ByteBuffer remainder;
        private CharsetDecoder decoder;

        public XMLDecoder(Charset cs) {
            super(cs, 1.0f, 2.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            if (this.buffer == null) {
                assert (this.decoder != null);
                if (this.remainder != null) {
                    ByteBuffer tmp = ByteBuffer.allocate(this.remainder.remaining() + in.remaining());
                    tmp.put(this.remainder);
                    tmp.put(in);
                    tmp.flip();
                    CoderResult result = this.decoder.decode(tmp, out, false);
                    this.remainder = tmp.hasRemaining() ? tmp : null;
                    return result;
                }
                return this.decoder.decode(in, out, false);
            }
            if (this.buffer.remaining() == 0) {
                return this.handleHead(in, out);
            }
            if (this.buffer.remaining() < in.remaining()) {
                int limit = in.limit();
                in.limit(in.position() + this.buffer.remaining());
                this.buffer.put(in);
                in.limit(limit);
                return this.handleHead(in, out);
            }
            this.buffer.put(in);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult handleHead(ByteBuffer in, CharBuffer out) {
            Charset c;
            String encoding = null;
            try {
                encoding = this.getEncoding();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (encoding == null) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            try {
                c = Charset.forName(encoding);
            }
            catch (UnsupportedCharsetException e) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            catch (IllegalCharsetNameException e) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            this.decoder = c.newDecoder();
            LOG.log(Level.FINEST, XmlFileEncodingQueryImpl.DECODER_SELECTED, this.decoder);
            return this.flushHead(in, out);
        }

        private CoderResult flushHead(ByteBuffer in, CharBuffer out) {
            this.buffer.flip();
            CoderResult r = this.decoder.decode(this.buffer, out, in == null);
            if (r.isOverflow()) {
                this.remainder = this.buffer;
                this.buffer = null;
                return r;
            }
            if (this.buffer.remaining() > 0) {
                this.remainder = this.buffer;
                this.buffer = null;
                return r;
            }
            this.buffer = null;
            if (in == null) {
                return r;
            }
            return this.decoder.decode(in, out, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getEncoding() throws IOException {
            byte[] arr = this.buffer.array();
            try (ByteArrayInputStream in = new ByteArrayInputStream(arr);){
                String string = EncodingUtil.detectEncoding(in);
                return string;
            }
        }

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            if (this.buffer != null) {
                CoderResult res = this.handleHead(null, out);
                return res;
            }
            if (this.remainder != null) {
                this.decoder.decode(this.remainder, out, true);
            } else {
                ByteBuffer empty = (ByteBuffer)ByteBuffer.allocate(0).flip();
                this.decoder.decode(empty, out, true);
            }
            CoderResult res = this.decoder.flush(out);
            return res;
        }

        @Override
        protected void implReset() {
            if (this.decoder != null) {
                this.decoder.reset();
            }
        }
    }

    private static class XMLEncoder
    extends CharsetEncoder {
        private CharBuffer buffer = CharBuffer.allocate(4096);
        private CharBuffer remainder;
        private CharsetEncoder encoder;

        public XMLEncoder(Charset cs) {
            super(cs, 1.0f, 2.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            if (this.buffer == null) {
                CoderResult result;
                assert (this.encoder != null);
                if (this.remainder != null) {
                    result = this.encoder.encode(this.remainder, out, false);
                    if (!this.remainder.hasRemaining()) {
                        this.remainder = null;
                    }
                }
                result = this.encoder.encode(in, out, false);
                return result;
            }
            if (this.buffer.remaining() == 0 || this.buffer.position() > 0 && in.limit() == 0) {
                return this.handleHead(in, out);
            }
            if (this.buffer.remaining() < in.remaining()) {
                int limit = in.limit();
                in.limit(in.position() + this.buffer.remaining());
                this.buffer.put(in);
                in.limit(limit);
                return this.handleHead(in, out);
            }
            this.buffer.put(in);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult handleHead(CharBuffer in, ByteBuffer out) {
            Charset c;
            String encoding = null;
            try {
                encoding = this.getEncoding();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (encoding == null) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            try {
                c = Charset.forName(encoding);
            }
            catch (UnsupportedCharsetException e) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            catch (IllegalCharsetNameException e) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            this.encoder = c.newEncoder();
            LOG.log(Level.FINEST, XmlFileEncodingQueryImpl.ENCODER_SELECTED, this.encoder);
            return this.flushHead(in, out);
        }

        private CoderResult flushHead(CharBuffer in, ByteBuffer out) {
            this.buffer.flip();
            CoderResult r = this.encoder.encode(this.buffer, out, in == null);
            if (r.isOverflow()) {
                this.remainder = this.buffer;
                this.buffer = null;
                return r;
            }
            this.buffer = null;
            if (in == null) {
                return r;
            }
            return this.encoder.encode(in, out, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getEncoding() throws IOException {
            String text = this.buffer.asReadOnlyBuffer().flip().toString();
            try (ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());){
                String string = EncodingUtil.detectEncoding(in);
                return string;
            }
        }

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            if (this.buffer != null) {
                CoderResult res = this.handleHead(null, out);
                return res;
            }
            if (this.remainder != null) {
                this.encoder.encode(this.remainder, out, true);
            } else {
                CharBuffer empty = (CharBuffer)CharBuffer.allocate(0).flip();
                this.encoder.encode(empty, out, true);
            }
            CoderResult res = this.encoder.flush(out);
            return res;
        }

        @Override
        protected void implReset() {
            if (this.encoder != null) {
                this.encoder.reset();
            }
        }
    }
}

