/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBElementProperties;
import org.netbeans.modules.dbschema.DBElementProvider;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.nodes.IconStrings;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;

public abstract class DBElementNode
extends AbstractNode
implements IconStrings,
DBElementProperties,
Node.Cookie {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[0];
    protected DBElement element;
    protected boolean writeable;
    private transient PropertyChangeListener listener;

    public DBElementNode(DBElement element, Children children, boolean writeable) {
        super(children);
        this.element = element;
        this.writeable = writeable;
        this.setIconBase(this.resolveIconBase());
        this.setName(element.getName().getName());
        this.setDisplayName(element.getName().getName());
        this.listener = new ElementListener();
        element.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)element));
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("dbschema_ctxhelp_wizard");
    }

    public boolean canRename() {
        return this.writeable;
    }

    public boolean canDestroy() {
        return this.writeable;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable ex = ExTransferable.create((Transferable)super.clipboardCopy());
        ex.put((ExTransferable.Single)new ElementStringTransferable());
        return ex;
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.writeable) {
            throw new IOException();
        }
        ExTransferable ex = ExTransferable.create((Transferable)super.clipboardCut());
        ex.put((ExTransferable.Single)new ElementStringTransferable());
        return ex;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.writeable;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie c = super.getCookie(type);
        if (c == null && (type.isAssignableFrom(DBElementProvider.class) || type.isAssignableFrom(DBElement.class))) {
            c = new DBElementProvider(this.element);
        }
        return c;
    }

    public boolean equals(Object o) {
        return o instanceof DBElementNode && this.element.equals(((DBElementNode)o).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    protected Node.Property createNameProperty(boolean canW) {
        return new ElementProp("name", String.class, canW){

            public Object getValue() {
                return DBElementNode.this.element.getName().getFullName();
            }
        };
    }

    void superSetName(String name) {
        super.setName(name);
    }

    private class ElementListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null) {
                DBElementNode.this.setIconBase(DBElementNode.this.resolveIconBase());
            } else {
                String[] iconProps = DBElementNode.this.getIconAffectingProperties();
                for (int i = 0; i < iconProps.length; ++i) {
                    if (!iconProps[i].equals(propName)) continue;
                    DBElementNode.this.setIconBase(DBElementNode.this.resolveIconBase());
                    break;
                }
                if (propName.equals("name")) {
                    try {
                        DBElementNode.this.superSetName(((DBMemberElement)DBElementNode.this.element).getName().toString());
                    }
                    catch (ClassCastException classCastException) {}
                } else if (propName.equals("cookie")) {
                    DBElementNode.this.superFireCookieChange();
                    return;
                }
            }
            DBElementNode.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    class ElementStringTransferable
    extends ExTransferable.Single {
        ElementStringTransferable() {
            super(DataFlavor.stringFlavor);
        }

        protected Object getData() {
            return DBElementNode.this.element.toString();
        }
    }

    static abstract class ElementProp
    extends PropertySupport {
        public ElementProp(String name, Class type, boolean canW) {
            super(name, type, NbBundle.getMessage(DBElementNode.class, (String)("PROP_" + name)), NbBundle.getMessage(DBElementNode.class, (String)("HINT_" + name)), true, canW);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(NbBundle.getMessage(DBElementNode.class, (String)"MSG_Cannot_Write"));
            }
        }
    }
}

