/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.state;

import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.PayaraStatus;
import org.netbeans.modules.payara.tooling.PayaraStatusListener;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandLocation;
import org.netbeans.modules.payara.tooling.admin.CommandVersion;
import org.netbeans.modules.payara.tooling.admin.Result;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.data.PayaraStatusCheck;
import org.netbeans.modules.payara.tooling.data.PayaraStatusCheckResult;
import org.netbeans.modules.payara.tooling.data.PayaraStatusTask;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.state.AbstractTask;
import org.netbeans.modules.payara.tooling.server.state.AdminPortTask;
import org.netbeans.modules.payara.tooling.server.state.PayaraStatusEntity;
import org.netbeans.modules.payara.tooling.server.state.StatusJobState;
import org.netbeans.modules.payara.tooling.server.state.StatusResult;
import org.netbeans.modules.payara.tooling.server.state.StatusResultLocations;
import org.netbeans.modules.payara.tooling.server.state.StatusResultVersion;
import org.netbeans.modules.payara.tooling.server.state.StatusScheduler;
import org.netbeans.modules.payara.tooling.utils.LinkedList;

public class StatusJob {
    private static final Logger LOGGER = new Logger(StatusJob.class);
    private static final StatusJobState[][] portCheckTransition = new StatusJobState[][]{{StatusJobState.NO_CHECK, StatusJobState.NO_CHECK}, {StatusJobState.UNKNOWN_PORT, StatusJobState.OFFLINE}, {StatusJobState.UNKNOWN_PORT, StatusJobState.OFFLINE}, {StatusJobState.OFFLINE_PORT, StatusJobState.OFFLINE}, {StatusJobState.OFFLINE_PORT, StatusJobState.OFFLINE}, {StatusJobState.STARTUP_PORT, StatusJobState.STARTUP}, {StatusJobState.STARTUP_PORT, StatusJobState.OFFLINE}, {StatusJobState.ONLINE, StatusJobState.OFFLINE_PORT}, {StatusJobState.SHUTDOWN, StatusJobState.SHUTDOWN_PORT}, {StatusJobState.SHUTDOWN_PORT, StatusJobState.OFFLINE}};
    private static final StatusJobState[][] commandTransition = new StatusJobState[][]{{StatusJobState.NO_CHECK, StatusJobState.NO_CHECK}, {StatusJobState.ONLINE, StatusJobState.UNKNOWN}, {StatusJobState.ONLINE, StatusJobState.OFFLINE}, {StatusJobState.ONLINE, StatusJobState.OFFLINE}, {StatusJobState.ONLINE, StatusJobState.OFFLINE_PORT}, {StatusJobState.ONLINE, StatusJobState.STARTUP}, {StatusJobState.ONLINE, StatusJobState.STARTUP_PORT}, {StatusJobState.ONLINE, StatusJobState.OFFLINE_PORT}, {StatusJobState.SHUTDOWN, StatusJobState.SHUTDOWN_PORT}, {StatusJobState.SHUTDOWN, StatusJobState.SHUTDOWN_PORT}};
    private final PayaraStatusEntity status;
    private StatusJobState state;
    private final Task portCheck;
    private final RunnerTask locations;
    private final RunnerTask version;
    private final LinkedList<PayaraStatusListener>[] newStatusListeners;
    private final LinkedList<PayaraStatusListener> currStatusListeners;
    private final LinkedList<PayaraStatusListener> errorListeners;

    private static PayaraStatusCheckResult checkResult(StatusJob job) {
        return PayaraStatusCheckResult.and(job.portCheck.evalResult(), job.version.evalResult(), job.locations.evalResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void portCheckTransition(StatusJob job, PayaraStatusTask task) {
        PayaraStatus newState;
        PayaraStatus oldState;
        String METHOD = "portCheckTransition";
        StatusJob statusJob = job;
        synchronized (statusJob) {
            StatusJobState oldInternalState = job.state;
            oldState = job.status.getStatus();
            job.state = portCheckTransition[job.state.ordinal()][job.portCheck.result.status.ordinal()];
            LOGGER.log(Level.FINE, "portCheckTransition", "transition", new String[]{job.portCheck.result.status.toString(), oldInternalState.toString(), job.state.toString()});
            if (oldInternalState != job.state) {
                StatusScheduler scheduler = StatusScheduler.getInstance();
                scheduler.remove(job);
                scheduler.reschedule(job);
            }
            if (oldState != (newState = job.state.toPayaraStatus())) {
                job.status.setStatus(newState);
            }
        }
        if (job.portCheck.result.status == PayaraStatusCheckResult.FAILED) {
            job.notifyErrorListeners(job.portCheck);
        }
        if (oldState != newState) {
            job.notifyNewStatusListeners(job.status.getStatus(), task);
        }
        job.notifyCurrStatusListeners(job.status.getStatus(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commandTransition(StatusJob job, PayaraStatusTask task) {
        PayaraStatus newState;
        PayaraStatus oldState;
        String METHOD = "commandLocationsTransition";
        PayaraStatusCheckResult status = StatusJob.checkResult(job);
        StatusJob statusJob = job;
        synchronized (statusJob) {
            StatusJobState oldInternalState = job.state;
            oldState = job.status.getStatus();
            job.state = commandTransition[job.state.ordinal()][status.ordinal()];
            LOGGER.log(Level.FINE, "commandLocationsTransition", "transition", new String[]{status.toString(), oldInternalState.toString(), job.state.toString()});
            if (oldInternalState != job.state) {
                StatusScheduler scheduler = StatusScheduler.getInstance();
                scheduler.remove(job);
                scheduler.reschedule(job);
            }
            if (oldState != (newState = job.state.toPayaraStatus())) {
                job.status.setStatus(newState);
            }
        }
        if (oldState != newState) {
            job.notifyNewStatusListeners(job.status.getStatus(), task);
        }
        job.notifyCurrStatusListeners(job.status.getStatus(), task);
    }

    StatusJob(PayaraStatusEntity status) {
        this.status = status;
        this.state = StatusJobState.UNKNOWN;
        this.portCheck = new Task(PayaraStatusCheck.PORT, new ListenerPortCheck(this));
        this.locations = new RunnerTaskLocations(new ListenerLocations(this));
        this.version = new RunnerTaskVersion(new ListenerVersion(this));
        this.newStatusListeners = new LinkedList[PayaraStatus.length];
        for (int i = 0; i < PayaraStatus.length; ++i) {
            this.newStatusListeners[i] = new LinkedList();
        }
        this.currStatusListeners = new LinkedList();
        this.errorListeners = new LinkedList();
    }

    PayaraStatusEntity getStatus() {
        return this.status;
    }

    StatusJobState getState() {
        return this.state;
    }

    void setState(StatusJobState state) {
        this.state = state;
    }

    Task getPortCheck() {
        return this.portCheck;
    }

    RunnerTask getLocations() {
        return this.locations;
    }

    RunnerTask getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restartJob(StatusScheduler scheduler, PayaraStatusListener listener) {
        boolean result;
        StatusJob statusJob = this;
        synchronized (statusJob) {
            switch (this.state) {
                case NO_CHECK: {
                    this.state = StatusJobState.UNKNOWN_PORT;
                    this.status.setStatus(this.state.toPayaraStatus());
                    scheduler.remove(this);
                    scheduler.reschedule(this);
                    result = true;
                    if (listener == null) break;
                    this.addNewStatusListener(listener, PayaraStatus.values());
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopJob(StatusScheduler scheduler) {
        StatusJob statusJob = this;
        synchronized (statusJob) {
            PayaraStatus oldStatus = this.state.toPayaraStatus();
            this.state = StatusJobState.NO_CHECK;
            this.status.setStatus(this.state.toPayaraStatus());
            scheduler.remove(this);
            scheduler.reschedule(this);
            if (oldStatus != this.status.getStatus()) {
                this.notifyNewStatusListeners(this.status.getStatus(), null);
            }
        }
    }

    private void startStateImpl(StatusScheduler scheduler, PayaraStatusListener listener, PayaraStatus ... newState) {
        PayaraStatus oldStatus = this.status.getStatus();
        this.state = StatusJobState.STARTUP;
        this.status.setStatus(this.state.toPayaraStatus());
        scheduler.remove(this);
        scheduler.reschedule(this);
        if (oldStatus != this.status.getStatus()) {
            this.notifyNewStatusListeners(this.status.getStatus(), null);
        }
        if (listener != null) {
            this.addNewStatusListener(listener, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startState(StatusScheduler scheduler, boolean force, PayaraStatusListener listener, PayaraStatus ... newState) {
        boolean result;
        StatusJob statusJob = this;
        synchronized (statusJob) {
            switch (this.state) {
                case OFFLINE: 
                case OFFLINE_PORT: {
                    this.startStateImpl(scheduler, listener, newState);
                    result = true;
                    break;
                }
                case STARTUP: {
                    result = false;
                    break;
                }
                default: {
                    if (force) {
                        this.startStateImpl(scheduler, listener, newState);
                        result = true;
                        break;
                    }
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shutdownState(StatusScheduler scheduler) {
        boolean result;
        StatusJob statusJob = this;
        synchronized (statusJob) {
            switch (this.state) {
                case ONLINE: {
                    this.state = StatusJobState.SHUTDOWN;
                    this.status.setStatus(this.state.toPayaraStatus());
                    scheduler.remove(this);
                    scheduler.reschedule(this);
                    result = true;
                    this.notifyNewStatusListeners(this.status.getStatus(), null);
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNew(StatusScheduler scheduler) {
        StatusJob statusJob = this;
        synchronized (statusJob) {
            scheduler.scheduleNew(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewStatusListeners(PayaraStatus status, PayaraStatusTask task) {
        int i = 0;
        Object[] objectArray = this.newStatusListeners;
        synchronized (this.newStatusListeners) {
            LinkedList<PayaraStatusListener> listeners = this.newStatusListeners[status.ordinal()];
            PayaraStatusListener[] call = new PayaraStatusListener[listeners.size()];
            boolean isElement = listeners.first();
            while (isElement) {
                call[i++] = listeners.getCurrent();
                isElement = listeners.next();
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            for (PayaraStatusListener listener : call) {
                listener.newState(this.status.getServer(), status, task);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCurrStatusListeners(PayaraStatus status, PayaraStatusTask task) {
        int i = 0;
        PayaraStatusListener[] payaraStatusListenerArray = this.currStatusListeners;
        synchronized (this.currStatusListeners) {
            PayaraStatusListener[] call = new PayaraStatusListener[this.currStatusListeners.size()];
            boolean isElement = this.currStatusListeners.first();
            while (isElement) {
                call[i++] = this.currStatusListeners.getCurrent();
                isElement = this.currStatusListeners.next();
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            for (PayaraStatusListener listener : call) {
                listener.currentState(this.status.getServer(), status, task);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyErrorListeners(PayaraStatusTask task) {
        int i = 0;
        PayaraStatusListener[] payaraStatusListenerArray = this.errorListeners;
        synchronized (this.errorListeners) {
            PayaraStatusListener[] call = new PayaraStatusListener[this.errorListeners.size()];
            boolean isElement = this.errorListeners.first();
            while (isElement) {
                call[i++] = this.errorListeners.getCurrent();
                isElement = this.errorListeners.next();
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            for (PayaraStatusListener listener : call) {
                listener.error(this.status.getServer(), task);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCurrStatusListener(PayaraStatusListener listener) {
        boolean added = false;
        boolean exists = false;
        LinkedList<PayaraStatusListener> linkedList = this.currStatusListeners;
        synchronized (linkedList) {
            boolean isElement = this.currStatusListeners.first();
            while (isElement) {
                if (listener.equals(this.currStatusListeners.getCurrent())) {
                    exists = true;
                }
                isElement = this.currStatusListeners.next();
            }
            if (!exists) {
                this.currStatusListeners.addLast(listener);
                added = true;
            }
        }
        if (added && listener != null) {
            listener.added();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNewStatusListener(PayaraStatusListener listener, PayaraStatus ... newState) {
        boolean added = false;
        LinkedList<PayaraStatusListener>[] linkedListArray = this.newStatusListeners;
        synchronized (this.newStatusListeners) {
            for (PayaraStatus stateToAdd : newState) {
                LinkedList<PayaraStatusListener> listeners = this.newStatusListeners[stateToAdd.ordinal()];
                boolean exists = false;
                boolean isElement = listeners.first();
                while (isElement) {
                    if (listener.equals(listeners.getCurrent())) {
                        exists = true;
                    }
                    isElement = listeners.next();
                }
                if (exists) continue;
                listeners.addLast(listener);
                added = true;
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            if (added && listener != null) {
                listener.added();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addErrorListener(PayaraStatusListener listener) {
        boolean added = false;
        boolean exists = false;
        LinkedList<PayaraStatusListener> linkedList = this.errorListeners;
        synchronized (linkedList) {
            boolean isElement = this.errorListeners.first();
            while (isElement) {
                if (listener.equals(this.errorListeners.getCurrent())) {
                    exists = true;
                }
                isElement = this.errorListeners.next();
            }
            if (!exists) {
                this.errorListeners.addLast(listener);
                added = true;
            }
        }
        if (added && listener != null) {
            listener.added();
        }
        return added;
    }

    public boolean addStatusListener(PayaraStatusListener listener, boolean currentState, PayaraStatus ... newState) {
        boolean added = currentState ? this.addCurrStatusListener(listener) : false;
        if (newState != null) {
            boolean bl = added = this.addNewStatusListener(listener, newState) || added;
        }
        if (added && listener != null) {
            listener.added();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStatusListener(PayaraStatusListener listener) {
        boolean isElement;
        boolean removed = false;
        LinkedList<PayaraStatusListener> linkedList = this.currStatusListeners;
        synchronized (linkedList) {
            isElement = this.currStatusListeners.first();
            while (isElement) {
                if (listener.equals(this.currStatusListeners.getCurrent())) {
                    this.currStatusListeners.removeAndNext();
                    isElement = this.currStatusListeners.isCurrent();
                    removed = true;
                    continue;
                }
                isElement = this.currStatusListeners.next();
            }
        }
        Object object = this.newStatusListeners;
        synchronized (this.newStatusListeners) {
            for (PayaraStatus stateToRemove : PayaraStatus.values()) {
                LinkedList<PayaraStatusListener> listeners = this.newStatusListeners[stateToRemove.ordinal()];
                isElement = listeners.first();
                while (isElement) {
                    if (listener.equals(listeners.getCurrent())) {
                        listeners.removeAndNext();
                        isElement = listeners.isCurrent();
                        removed = true;
                        continue;
                    }
                    isElement = listeners.next();
                }
            }
            // ** MonitorExit[var5_6 /* !! */ ] (shouldn't be in output)
            object = this.errorListeners;
            synchronized (object) {
                isElement = this.errorListeners.first();
                while (isElement) {
                    if (listener.equals(this.errorListeners.getCurrent())) {
                        this.errorListeners.removeAndNext();
                        isElement = this.errorListeners.isCurrent();
                        removed = true;
                        continue;
                    }
                    isElement = this.errorListeners.next();
                }
            }
            if (removed && listener != null) {
                listener.removed();
            }
            return removed;
        }
    }

    static class Task
    implements PayaraStatusTask {
        private Listener listener;
        StatusResult result;
        AbstractTask task;
        private ScheduledFuture future;
        private TaskStateListener[] listeners;
        private final PayaraStatusCheck type;

        private Task(PayaraStatusCheck type, Listener listener) {
            this.listener = listener;
            this.type = type;
            this.result = null;
            this.task = null;
            this.future = null;
            this.listeners = new TaskStateListener[]{listener};
        }

        Listener getListener() {
            return this.listener;
        }

        void setListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public PayaraStatusCheck getType() {
            return this.type;
        }

        StatusResult getResult() {
            return this.result;
        }

        void setResult(StatusResult result) {
            this.result = result;
        }

        @Override
        public PayaraStatusCheckResult getStatus() {
            return this.result != null ? this.result.status : null;
        }

        @Override
        public TaskEvent getEvent() {
            return this.result != null ? this.result.event : null;
        }

        AbstractTask getTask() {
            return this.task;
        }

        void setTask(AbstractTask task) {
            this.task = task;
        }

        TaskStateListener[] getListeners() {
            return this.listeners;
        }

        ScheduledFuture getFuture() {
            return this.future;
        }

        void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        void setTaskFuture(AbstractTask task, ScheduledFuture future) {
            this.task = task;
            this.future = future;
        }

        void clearTaskFuture() {
            this.task = null;
            this.future = null;
        }

        PayaraStatusCheckResult evalResult() {
            return this.task == null ? PayaraStatusCheckResult.SUCCESS : (this.result == null ? PayaraStatusCheckResult.FAILED : this.result.status);
        }
    }

    static class RunnerTask
    extends Task {
        private final Command command;

        private RunnerTask(PayaraStatusCheck type, Command cmd, Listener listener) {
            super(type, listener);
            this.command = cmd;
        }

        Command getCommand() {
            return this.command;
        }
    }

    static class ListenerPortCheck
    extends Listener {
        private static final Logger LOGGER = new Logger(ListenerPortCheck.class);

        private ListenerPortCheck(StatusJob job) {
            super(job);
        }

        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            String METHOD = "operationStateChanged";
            AdminPortTask task = (AdminPortTask)this.job.portCheck.getTask();
            this.job.portCheck.setResult(task.getResult());
            LOGGER.log(Level.FINE, "operationStateChanged", "result", ((StatusJob)this.job).portCheck.getResult().status.toString());
            StatusJob.portCheckTransition(this.job, this.job.portCheck);
        }
    }

    static abstract class Listener
    implements TaskStateListener {
        private static final Logger LOGGER = new Logger(Listener.class);
        Runner runner = null;
        final StatusJob job;

        private Listener(StatusJob job) {
            this.job = job;
        }

        void setRunner(Runner runner) {
            this.runner = runner;
        }

        void clearRunner() {
            this.runner = null;
        }
    }

    static class RunnerTaskLocations
    extends RunnerTask {
        private RunnerTaskLocations(Listener listener) {
            super(PayaraStatusCheck.LOCATIONS, new CommandLocation(), listener);
        }
    }

    static class ListenerLocations
    extends Listener {
        private static final Logger LOGGER = new Logger(ListenerLocations.class);

        private ListenerLocations(StatusJob job) {
            super(job);
        }

        private boolean verifyResult() {
            Result result = this.runner.getResult();
            if (result instanceof ResultMap) {
                ResultMap resultMap = (ResultMap)result;
                return CommandLocation.verifyResult(resultMap, this.job.status.getServer());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            String METHOD = "operationStateChanged";
            switch (newState) {
                case COMPLETED: 
                case FAILED: {
                    ResultMap taskResult = (ResultMap)this.runner.getResult();
                    if (args != null && args.length >= 3) {
                        String serverName = args[0];
                        String exceptionMeasage = args[2];
                    } else {
                        Object serverName = null;
                        Object exceptionMeasage = null;
                    }
                    boolean notifyError = false;
                    Object object = this.job.locations;
                    synchronized (object) {
                        switch (newState) {
                            case COMPLETED: {
                                if (this.verifyResult()) {
                                    this.job.locations.setResult(new StatusResultLocations(taskResult, PayaraStatusCheckResult.SUCCESS, event));
                                    break;
                                }
                            }
                            case FAILED: {
                                this.job.locations.setResult(new StatusResultLocations(taskResult, PayaraStatusCheckResult.FAILED, event));
                                notifyError = true;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "operationStateChanged", "result", ((StatusJob)this.job).locations.getResult().status.toString());
                    if (notifyError) {
                        object = this.job;
                        synchronized (object) {
                            this.job.notifyErrorListeners(this.job.locations);
                        }
                    }
                    StatusJob.commandTransition(this.job, this.job.locations);
                }
            }
        }
    }

    static class RunnerTaskVersion
    extends RunnerTask {
        private RunnerTaskVersion(Listener listener) {
            super(PayaraStatusCheck.VERSION, new CommandVersion(), listener);
        }
    }

    static class ListenerVersion
    extends Listener {
        private static final Logger LOGGER = new Logger(ListenerVersion.class);

        private ListenerVersion(StatusJob job) {
            super(job);
        }

        private boolean verifyResult() {
            Result result = this.runner.getResult();
            if (result instanceof ResultString) {
                ResultString resultString = (ResultString)result;
                return CommandVersion.verifyResult(resultString, this.job.status.getServer());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            String METHOD = "operationStateChanged";
            switch (newState) {
                case COMPLETED: 
                case FAILED: {
                    ResultString taskResult = (ResultString)this.runner.getResult();
                    if (args != null && args.length >= 3) {
                        String serverName = args[0];
                        String exceptionMeasage = args[2];
                    } else {
                        Object serverName = null;
                        Object exceptionMeasage = null;
                    }
                    boolean notifyError = false;
                    Object object = this.job.version;
                    synchronized (object) {
                        switch (newState) {
                            case COMPLETED: {
                                if (this.verifyResult()) {
                                    this.job.version.setResult(new StatusResultVersion(taskResult, PayaraStatusCheckResult.SUCCESS, event));
                                    break;
                                }
                            }
                            case FAILED: {
                                this.job.version.setResult(new StatusResultVersion(taskResult, PayaraStatusCheckResult.FAILED, event));
                                notifyError = true;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "operationStateChanged", "result", ((StatusJob)this.job).version.getResult().status.toString());
                    if (notifyError) {
                        object = this.job;
                        synchronized (object) {
                            this.job.notifyErrorListeners(this.job.version);
                        }
                    }
                    StatusJob.commandTransition(this.job, this.job.version);
                }
            }
        }
    }
}

