/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.CreateReplicationPolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateReplicationPolicyRequest
extends BmcRequest<CreateReplicationPolicyDetails> {
    private String namespaceName;
    private String bucketName;
    private CreateReplicationPolicyDetails createReplicationPolicyDetails;
    private String opcClientRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CreateReplicationPolicyDetails getCreateReplicationPolicyDetails() {
        return this.createReplicationPolicyDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    @InternalSdk
    public CreateReplicationPolicyDetails getBody$() {
        return this.createReplicationPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).createReplicationPolicyDetails(this.createReplicationPolicyDetails).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",createReplicationPolicyDetails=").append(String.valueOf((Object)this.createReplicationPolicyDetails));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateReplicationPolicyRequest)) {
            return false;
        }
        CreateReplicationPolicyRequest other = (CreateReplicationPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals((Object)this.createReplicationPolicyDetails, (Object)other.createReplicationPolicyDetails) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.createReplicationPolicyDetails == null ? 43 : this.createReplicationPolicyDetails.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateReplicationPolicyRequest, CreateReplicationPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private CreateReplicationPolicyDetails createReplicationPolicyDetails = null;
        private String opcClientRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder createReplicationPolicyDetails(CreateReplicationPolicyDetails createReplicationPolicyDetails) {
            this.createReplicationPolicyDetails = createReplicationPolicyDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateReplicationPolicyRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.createReplicationPolicyDetails(o.getCreateReplicationPolicyDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateReplicationPolicyRequest build() {
            CreateReplicationPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateReplicationPolicyDetails body) {
            this.createReplicationPolicyDetails(body);
            return this;
        }

        public CreateReplicationPolicyRequest buildWithoutInvocationCallback() {
            CreateReplicationPolicyRequest request = new CreateReplicationPolicyRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.createReplicationPolicyDetails = this.createReplicationPolicyDetails;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

