/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.List;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;

record CompositeResult<T>(List<ResultImplementation<T>> results) implements ResultImplementation<T>
{
    public CompositeResult(ResultImplementation<T> first, ResultImplementation<T> second) {
        this(List.of(first, second));
    }

    @Override
    public boolean isPartial() {
        for (ResultImplementation<T> result : this.results) {
            if (!result.isPartial()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void waitForSkipped() {
        for (ResultImplementation<T> result : this.results) {
            result.waitForSkipped();
        }
    }

    @Override
    public List<T> getResults() {
        return this.results.stream().flatMap(r -> r.getResults().stream()).sorted().distinct().toList();
    }

    @Override
    public int getTotalResultCount() {
        int ret = 0;
        for (ResultImplementation<T> result : this.results) {
            ret += result.getTotalResultCount();
        }
        return ret;
    }

    @Override
    public int getReturnedResultCount() {
        int ret = 0;
        for (ResultImplementation<T> result : this.results) {
            ret += result.getReturnedResultCount();
        }
        return ret;
    }
}

