/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.java.editor.imports.ClipboardImportPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClipboardHandler {
    private static final RequestProcessor WORKER = new RequestProcessor(ClipboardHandler.class.getName(), 3, false, false);
    static boolean autoImport = false;
    private static final Object NO_IMPORTS = new Object();
    private static final Object RUN_SYNCHRONOUSLY = new Object();
    private static final DataFlavor IMPORT_FLAVOR = new DataFlavor(ImportsWrapper.class, NbBundle.getMessage(ClipboardHandler.class, (String)"MSG_ClipboardImportFlavor"));
    private static final DataFlavor COPY_FROM_STRING_FLAVOR = new DataFlavor(Boolean.class, NbBundle.getMessage(ClipboardHandler.class, (String)"MSG_ClipboardCopyFromStringFlavor"));

    public static void install(JTextComponent c) {
        c.setTransferHandler(new ImportingTransferHandler(c.getTransferHandler()));
    }

    private static void doImport(JavaSource js, final Document doc, final int caret, final Map<String, String> simple2ImportFQN, final List<Position[]> inSpans, AtomicBoolean cancel) {
        final HashMap putFQNs = new HashMap();
        try {
            final ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePath context = copy.getTreeUtilities().pathFor(caret);
                    Scope scope = copy.getTrees().getScope(context);
                    Scope cutScope = copy.getTrees().getScope(new TreePath(context.getCompilationUnit()));
                    ArrayList spans = new ArrayList(inSpans);
                    spans.sort((o1, o2) -> o1[0].getOffset() - o2[0].getOffset());
                    HashMap<String, String> imported = new HashMap<String, String>();
                    for (Position[] span : spans) {
                        String currentSimpleName = copy.getText().substring(span[0].getOffset(), span[1].getOffset());
                        String handled = (String)imported.get(currentSimpleName);
                        if (handled == null) {
                            String fqn = (String)simple2ImportFQN.get(currentSimpleName);
                            Element e = ClipboardHandler.fqn2element(copy.getElements(), fqn);
                            if (e == null) continue;
                            if (e.getKind().isClass() || e.getKind().isInterface()) {
                                handled = SourceUtils.resolveImport((CompilationInfo)copy, (TreePath)context, (String)fqn);
                            } else {
                                CompilationUnitTree cut = (CompilationUnitTree)copy.resolveRewriteTarget((Tree)copy.getCompilationUnit());
                                if (e.getModifiers().contains((Object)Modifier.STATIC) && copy.getTrees().isAccessible(cutScope, e, (DeclaredType)e.getEnclosingElement().asType()) && (scope.getEnclosingClass() == null || copy.getElementUtilities().outermostTypeElement(e) != copy.getElementUtilities().outermostTypeElement((Element)scope.getEnclosingClass()))) {
                                    copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(cut, Collections.singleton(e)));
                                }
                                handled = e.getSimpleName().toString();
                            }
                            imported.put(currentSimpleName, handled);
                        }
                        putFQNs.put(span, handled);
                    }
                }
            });
            if (cancel.get()) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        mr.commit();
                        for (Map.Entry e : putFQNs.entrySet()) {
                            doc.remove(((Position[])e.getKey())[0].getOffset(), ((Position[])e.getKey())[1].getOffset() - ((Position[])e.getKey())[0].getOffset());
                            doc.insertString(((Position[])e.getKey())[0].getOffset(), (String)e.getValue(), null);
                        }
                    }
                    catch (IOException | BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (IOException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void showImportDialog(final JavaSource js, final Document doc, final int caret, final Map<String, String> simple2ImportFQN, Collection<String> toShow, final List<Position[]> inSpans) {
        if (autoImport) {
            ClipboardHandler.doImport(js, doc, caret, simple2ImportFQN, inSpans, new AtomicBoolean());
            return;
        }
        ClipboardImportPanel panel = new ClipboardImportPanel(toShow);
        final AtomicBoolean cancel = new AtomicBoolean();
        final JButton okButton = new JButton(NbBundle.getMessage(ClipboardHandler.class, (String)"BTN_ClipboardImportOK"));
        JButton cancelButton = new JButton(NbBundle.getMessage(ClipboardHandler.class, (String)"BTN_ClipboardImportCancel"));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ClipboardHandler.class, (String)"MSG_ClipboardImportImportClasses"), true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        final Dialog[] d = new Dialog[1];
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okButton.setEnabled(false);
                WORKER.post(new Runnable(){

                    @Override
                    public void run() {
                        ClipboardHandler.doImport(js, doc, caret, simple2ImportFQN, inSpans, cancel);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                d[0].setVisible(false);
                                d[0].dispose();
                            }
                        });
                    }
                });
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancel.set(true);
                d[0].setVisible(false);
                d[0].dispose();
            }
        });
        d[0] = DialogDisplayer.getDefault().createDialog(dd);
        d[0].setVisible(true);
    }

    private static Collection<? extends String> needsImports(JavaSource js, final int caret, final Map<String, String> simple2FQNs) {
        final ArrayList unavailable = new ArrayList();
        boolean finished = ClipboardHandler.runQuickly(js, new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = cc.getTreeUtilities().pathFor(caret);
                Scope context = cc.getTrees().getScope(tp);
                SourcePositions[] sps = new SourcePositions[1];
                block0: for (Map.Entry e : simple2FQNs.entrySet()) {
                    Element el = ClipboardHandler.fqn2element(cc.getElements(), (String)e.getValue());
                    if (el == null) continue;
                    if (el.getKind().isClass() || el.getKind().isInterface()) {
                        ExpressionTree simpleName = cc.getTreeUtilities().parseExpression((String)e.getKey() + ".class", sps);
                        cc.getTreeUtilities().attributeTree((Tree)simpleName, context);
                        Element element = cc.getTrees().getElement(new TreePath(tp, ((MemberSelectTree)simpleName).getExpression()));
                        if (el.equals(element)) {
                            continue;
                        }
                    } else {
                        if (!cc.getTrees().isAccessible(context, el, (DeclaredType)el.getEnclosingElement().asType()) || context.getEnclosingClass() != null && (cc.getElementUtilities().outermostTypeElement(el) == cc.getElementUtilities().outermostTypeElement((Element)context.getEnclosingClass()) || cc.getElements().getAllMembers(context.getEnclosingClass()).contains(el))) continue;
                        for (ImportTree importTree : cc.getCompilationUnit().getImports()) {
                            if (!importTree.isStatic() || importTree.getQualifiedIdentifier().getKind() != Tree.Kind.MEMBER_SELECT) continue;
                            MemberSelectTree mst = (MemberSelectTree)importTree.getQualifiedIdentifier();
                            Element elm = cc.getTrees().getElement(TreePath.getPath(cc.getCompilationUnit(), (Tree)mst.getExpression()));
                            if (!el.getEnclosingElement().equals(elm) || !"*".contentEquals(mst.getIdentifier()) && !el.getSimpleName().contentEquals(mst.getIdentifier())) continue;
                            continue block0;
                        }
                    }
                    unavailable.add((String)e.getValue());
                }
            }
        });
        if (finished) {
            return unavailable;
        }
        return null;
    }

    private static Element fqn2element(Elements elements, String fqn) {
        if (fqn == null) {
            return null;
        }
        TypeElement type = elements.getTypeElement(fqn);
        if (type != null) {
            return type;
        }
        int idx = fqn.lastIndexOf(46);
        if (idx > 0) {
            type = elements.getTypeElement(fqn.substring(0, idx));
            String name = fqn.substring(idx + 1);
            if (type != null && name.length() > 0) {
                for (Element element : type.getEnclosedElements()) {
                    if (!element.getModifiers().contains((Object)Modifier.STATIC) || !name.contentEquals(element.getSimpleName())) continue;
                    return element;
                }
            }
        }
        return null;
    }

    private static boolean runQuickly(final JavaSource js, final Task<CompilationController> task) {
        boolean finished;
        final CountDownLatch started = new CountDownLatch(1);
        final AtomicBoolean cancel = new AtomicBoolean();
        RequestProcessor.Task t = WORKER.post(new Runnable(){

            @Override
            public void run() {
                try {
                    js.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController parameter) throws Exception {
                            started.countDown();
                            if (cancel.get()) {
                                return;
                            }
                            task.run((Object)parameter);
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        try {
            finished = started.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            finished = false;
        }
        if (finished) {
            try {
                finished = t.waitFinished(1000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                finished = false;
            }
        } else {
            cancel.set(true);
        }
        return finished;
    }

    private static final class ImportingTransferHandler
    extends TransferHandler {
        private final TransferHandler delegate;

        public ImportingTransferHandler(TransferHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return this.delegate.canImport(support);
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.delegate.canImport(comp, transferFlavors);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            try {
                Method method = this.delegate.getClass().getDeclaredMethod("createTransferable", JComponent.class);
                method.setAccessible(true);
                return (Transferable)method.invoke((Object)this.delegate, c);
            }
            catch (ReflectiveOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            this.delegate.exportAsDrag(comp, e, action);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            try {
                Method method = this.delegate.getClass().getDeclaredMethod("exportDone", JComponent.class, Transferable.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.delegate, source, data, action);
            }
            catch (ReflectiveOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            ImportsWrapper iw = null;
            boolean copiedFromString = false;
            if (comp instanceof JTextComponent) {
                JavaSource js;
                JTextComponent tc = (JTextComponent)comp;
                copiedFromString = this.insideToken(tc, JavaTokenId.STRING_LITERAL, JavaTokenId.CHAR_LITERAL);
                if (comp.getClientProperty(NO_IMPORTS) == null && (js = JavaSource.forDocument((Document)tc.getDocument())) != null) {
                    final int start = tc.getSelectionStart();
                    final int end = tc.getSelectionEnd();
                    final HashMap<String, String> simple2ImportFQN = new HashMap<String, String>();
                    final ArrayList<int[]> spans = new ArrayList<int[]>();
                    Task<CompilationController> w = new Task<CompilationController>(){

                        public void run(final CompilationController parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.RESOLVED);
                            new ErrorAwareTreePathScanner<Void, Void>(){
                                private final Set<Element> declaredInCopiedText = new HashSet<Element>();
                                private Tree lastType;
                                boolean ignoreSynthetic;

                                public Void visitIdentifier(IdentifierTree node, Void p) {
                                    int s = (int)parameter.getTrees().getSourcePositions().getStartPosition(parameter.getCompilationUnit(), node);
                                    int e = (int)parameter.getTrees().getSourcePositions().getEndPosition(parameter.getCompilationUnit(), node);
                                    Element el = parameter.getTrees().getElement(this.getCurrentPath());
                                    if (s >= start && e >= start && e <= end && el != null && !this.declaredInCopiedText.contains(el)) {
                                        if (el.getKind().isClass() || el.getKind().isInterface()) {
                                            TreePath parentPath = this.getCurrentPath().getParentPath();
                                            if (parentPath == null || parentPath.getLeaf().getKind() != Tree.Kind.NEW_CLASS || ((NewClassTree)parentPath.getLeaf()).getEnclosingExpression() == null || ((NewClassTree)parentPath.getLeaf()).getIdentifier() != node) {
                                                simple2ImportFQN.put(el.getSimpleName().toString(), ((TypeElement)el).getQualifiedName().toString());
                                                spans.add(new int[]{s - start, e - start});
                                            }
                                        } else if (el.getKind() == ElementKind.ENUM_CONSTANT) {
                                            TreePath parentPath = this.getCurrentPath().getParentPath();
                                            if (parentPath.getLeaf().getKind() != Tree.Kind.CASE || ((CaseTree)parentPath.getLeaf()).getExpression() != node) {
                                                simple2ImportFQN.put(el.getSimpleName().toString(), ((TypeElement)el.getEnclosingElement()).getQualifiedName().toString() + "." + el.getSimpleName().toString());
                                                spans.add(new int[]{s - start, e - start});
                                            }
                                        } else if ((el.getKind() == ElementKind.FIELD || el.getKind() == ElementKind.METHOD) && el.getModifiers().contains((Object)Modifier.STATIC) && !el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                                            simple2ImportFQN.put(el.getSimpleName().toString(), ((TypeElement)el.getEnclosingElement()).getQualifiedName().toString() + "." + el.getSimpleName().toString());
                                            spans.add(new int[]{s - start, e - start});
                                        }
                                    }
                                    return (Void)super.visitIdentifier(node, (Object)p);
                                }

                                public Void visitClass(ClassTree node, Void p) {
                                    this.handleDeclaration();
                                    return (Void)super.visitClass(node, (Object)p);
                                }

                                public Void visitMethod(MethodTree node, Void p) {
                                    this.handleDeclaration();
                                    return (Void)super.visitMethod(node, (Object)p);
                                }

                                private void handleDeclaration() {
                                    int s = (int)parameter.getTrees().getSourcePositions().getStartPosition(parameter.getCompilationUnit(), this.getCurrentPath().getLeaf());
                                    int e = (int)parameter.getTrees().getSourcePositions().getEndPosition(parameter.getCompilationUnit(), this.getCurrentPath().getLeaf());
                                    Element el = parameter.getTrees().getElement(this.getCurrentPath());
                                    if (el != null && (start <= s && s <= end || start <= e && e <= end)) {
                                        simple2ImportFQN.remove(el.getSimpleName().toString());
                                        this.declaredInCopiedText.add(el);
                                    }
                                }

                                public Void visitVariable(VariableTree node, Void p) {
                                    this.handleDeclaration();
                                    if (this.lastType == node.getType()) {
                                        this.scan((Tree)node.getInitializer(), null);
                                        return null;
                                    }
                                    this.lastType = node.getType();
                                    return (Void)super.visitVariable(node, (Object)p);
                                }

                                public Void scan(Tree tree, Void p) {
                                    if (tree == null) {
                                        return null;
                                    }
                                    if (parameter.getTreeUtilities().isSynthetic(new TreePath(this.getCurrentPath(), tree)) && !this.ignoreSynthetic) {
                                        AssignmentTree at;
                                        if (tree.getKind() == Tree.Kind.ASSIGNMENT && this.getCurrentPath().getLeaf().getKind() == Tree.Kind.ANNOTATION && (at = (AssignmentTree)tree).getVariable() != null && at.getVariable().getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)at.getVariable()).getName().contentEquals("value")) {
                                            this.ignoreSynthetic = true;
                                            super.scan(tree, (Object)p);
                                            this.ignoreSynthetic = false;
                                            return null;
                                        }
                                        return null;
                                    }
                                    return (Void)super.scan(tree, (Object)p);
                                }
                            }.scan((Tree)parameter.getCompilationUnit(), null);
                        }
                    };
                    boolean finished = false;
                    if (comp.getClientProperty(RUN_SYNCHRONOUSLY) != null || autoImport) {
                        try {
                            js.runUserActionTask((Task)w, true);
                            finished = true;
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else {
                        finished = ClipboardHandler.runQuickly(js, w);
                    }
                    if (finished) {
                        iw = new ImportsWrapper(NbEditorUtilities.getFileObject((Document)tc.getDocument()), simple2ImportFQN, spans);
                    }
                }
            }
            this.delegate.exportToClipboard(comp, clip, action);
            if (iw != null || copiedFromString) {
                clip.setContents(new WrappedTransferable(clip.getContents(null), iw, copiedFromString), null);
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return this.delegate.getSourceActions(c);
        }

        @Override
        public Icon getVisualRepresentation(Transferable t) {
            return this.delegate.getVisualRepresentation(t);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            return this.delegate.importData(comp, t);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Transferable t = support.getTransferable();
            Component comp = support.getComponent();
            if (t.isDataFlavorSupported(IMPORT_FLAVOR) && comp instanceof JTextComponent && !this.insideToken((JTextComponent)comp, JavaTokenId.STRING_LITERAL, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT)) {
                boolean result = false;
                try {
                    final JTextComponent tc = (JTextComponent)comp;
                    final int caret = tc.getSelectionStart();
                    result = this.delegatedImportData(support);
                    if (result) {
                        final ImportsWrapper imports = (ImportsWrapper)t.getTransferData(IMPORT_FLAVOR);
                        final FileObject file = NbEditorUtilities.getFileObject((Document)tc.getDocument());
                        final Document doc = tc.getDocument();
                        int len = doc.getLength();
                        final ArrayList<Position[]> inSpans = new ArrayList<Position[]>();
                        for (int[] span : imports.identifiers) {
                            int start = caret + span[0];
                            int end = caret + span[1];
                            if (0 > start || start > end || end > len) continue;
                            inSpans.add(new Position[]{doc.createPosition(start), doc.createPosition(end)});
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaSource js = JavaSource.forDocument((Document)tc.getDocument());
                                if (js == null) {
                                    return;
                                }
                                Collection<? extends String> unavailable = ClipboardHandler.needsImports(js, caret, imports.simple2ImportFQN);
                                if (unavailable == null) {
                                    unavailable = file == null || !file.equals(imports.sourceFO) ? imports.simple2ImportFQN.values() : Collections.emptyList();
                                }
                                HashSet<String> toShow = new HashSet<String>(imports.simple2ImportFQN.values());
                                toShow.retainAll(unavailable);
                                if (!unavailable.isEmpty()) {
                                    ClipboardHandler.showImportDialog(js, doc, caret, imports.simple2ImportFQN, toShow, inSpans);
                                }
                            }
                        });
                    }
                }
                catch (UnsupportedFlavorException | IOException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return result;
            }
            return this.delegatedImportData(support);
        }

        private boolean delegatedImportData(TransferHandler.TransferSupport support) {
            final JComponent comp = (JComponent)support.getComponent();
            if (comp instanceof JTextComponent && !support.isDataFlavorSupported(COPY_FROM_STRING_FLAVOR)) {
                if (this.insideToken((JTextComponent)comp, JavaTokenId.STRING_LITERAL, new JavaTokenId[0])) {
                    final Transferable t = support.getTransferable();
                    return this.delegate.importData(comp, new Transferable(){

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return t.getTransferDataFlavors();
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return t.isDataFlavorSupported(flavor);
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            Object data = t.getTransferData(flavor);
                            if (data instanceof String) {
                                String s = (String)data;
                                s = s.replace("\\", "\\\\");
                                s = s.replace("\"", "\\\"");
                                s = s.replace("\r\n", "\n");
                                s = s.replace("\n", "\\n\" +\n\"");
                                data = s;
                            } else if (data instanceof Reader) {
                                String line;
                                BufferedReader br = new BufferedReader((Reader)data);
                                StringBuilder sb = new StringBuilder();
                                while ((line = br.readLine()) != null) {
                                    line = line.replace("\\", "\\\\");
                                    line = line.replace("\"", "\\\"");
                                    if (sb.length() > 0) {
                                        sb.append("\\n\" +\n\"");
                                    }
                                    sb.append(line);
                                }
                                data = new StringReader(sb.toString());
                            }
                            return data;
                        }
                    });
                }
                if (this.insideToken((JTextComponent)comp, JavaTokenId.MULTILINE_STRING_LITERAL, new JavaTokenId[0])) {
                    final Transferable t = support.getTransferable();
                    return this.delegate.importData(comp, new Transferable(){

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return t.getTransferDataFlavors();
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return t.isDataFlavorSupported(flavor);
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            Object data = t.getTransferData(flavor);
                            JTextComponent c = (JTextComponent)comp;
                            int indent = 0;
                            try {
                                indent = IndentUtils.lineIndent((Document)c.getDocument(), (int)IndentUtils.lineStartOffset((Document)c.getDocument(), (int)c.getCaretPosition()));
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            if (data instanceof String) {
                                String s = (String)data;
                                s = s.replace("\"\"\"", "\\\"\"\"");
                                StringBuilder sb = new StringBuilder("");
                                for (int i = 0; i < indent; ++i) {
                                    sb.append(" ");
                                }
                                String emptySpaces = sb.toString();
                                s = s.replace("\r\n", "\n");
                                s = s.replace("\n", System.lineSeparator() + emptySpaces);
                                data = s;
                            } else if (data instanceof Reader) {
                                String line;
                                Reader reader = (Reader)data;
                                BufferedReader br = new BufferedReader(reader);
                                StringBuilder sb = new StringBuilder();
                                while ((line = br.readLine()) != null) {
                                    line = line.replace("\"\"\"", "\\\"\"\"");
                                    if (sb.length() > 0) {
                                        sb.append(System.lineSeparator());
                                        for (int i = 0; i < indent; ++i) {
                                            sb.append(" ");
                                        }
                                    }
                                    sb.append(line);
                                }
                                data = new StringReader(sb.toString());
                            }
                            return data;
                        }
                    });
                }
            }
            return this.delegate.importData(support);
        }

        private boolean insideToken(final JTextComponent jtc, final JavaTokenId first, final JavaTokenId ... rest) {
            final Document doc = jtc.getDocument();
            final boolean[] result = new boolean[1];
            doc.render(new Runnable(){

                @Override
                public void run() {
                    int offset = jtc.getSelectionStart();
                    TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)offset);
                    if (ts == null || !ts.moveNext() && !ts.movePrevious() || offset == ts.offset()) {
                        result[0] = false;
                    } else {
                        EnumSet<JavaTokenId[]> tokenIds = EnumSet.of(first, rest);
                        result[0] = tokenIds.contains(ts.token().id());
                    }
                }
            });
            return result[0];
        }
    }

    public static final class ImportsWrapper {
        private final FileObject sourceFO;
        private final Map<String, String> simple2ImportFQN;
        private final List<int[]> identifiers;

        public ImportsWrapper(FileObject sourceFO, Map<String, String> simple2ImportFQN, List<int[]> identifiers) {
            this.sourceFO = sourceFO;
            this.simple2ImportFQN = simple2ImportFQN;
            this.identifiers = identifiers;
        }
    }

    public static class JavaCutToLineBeginOrEndAction
    extends ActionFactory.CutToLineBeginOrEndAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(final ActionEvent evt, final JTextComponent target) {
            boolean finished;
            Document doc = target.getDocument();
            JavaSource js = JavaSource.forDocument((Document)doc);
            final Object lock = new Object();
            final AtomicBoolean cancel = new AtomicBoolean();
            final AtomicBoolean alreadyRunning = new AtomicBoolean();
            if (js != null && !DocumentUtilities.isWriteLocked((Document)doc) && (finished = ClipboardHandler.runQuickly(js, new Task<CompilationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(CompilationController parameter) throws Exception {
                    Object object = lock;
                    synchronized (object) {
                        if (cancel.get()) {
                            return;
                        }
                        alreadyRunning.set(true);
                    }
                    try {
                        target.putClientProperty(RUN_SYNCHRONOUSLY, true);
                        JavaCutToLineBeginOrEndAction.super.actionPerformed(evt, target);
                    }
                    finally {
                        target.putClientProperty(RUN_SYNCHRONOUSLY, null);
                    }
                }
            }))) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                if (alreadyRunning.get()) {
                    return;
                }
                cancel.set(true);
            }
            try {
                target.putClientProperty(NO_IMPORTS, true);
                super.actionPerformed(evt, target);
            }
            finally {
                target.putClientProperty(NO_IMPORTS, null);
            }
        }
    }

    public static final class JavaCutAction
    extends BaseKit.CutAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(final ActionEvent evt, final JTextComponent target) {
            Document doc = target.getDocument();
            JavaSource js = JavaSource.forDocument((Document)doc);
            final Object lock = new Object();
            final AtomicBoolean cancel = new AtomicBoolean();
            final AtomicBoolean alreadyRunning = new AtomicBoolean();
            if (js != null) {
                Task<CompilationController> work = new Task<CompilationController>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController parameter) throws Exception {
                        Object object = lock;
                        synchronized (object) {
                            if (cancel.get()) {
                                return;
                            }
                            alreadyRunning.set(true);
                        }
                        try {
                            target.putClientProperty(RUN_SYNCHRONOUSLY, true);
                            JavaCutAction.super.actionPerformed(evt, target);
                        }
                        finally {
                            target.putClientProperty(RUN_SYNCHRONOUSLY, null);
                        }
                    }
                };
                if (target.getClientProperty(RUN_SYNCHRONOUSLY) == null) {
                    boolean finished;
                    if (!DocumentUtilities.isWriteLocked((Document)doc) && (finished = ClipboardHandler.runQuickly(js, work))) {
                        return;
                    }
                } else {
                    try {
                        js.runUserActionTask((Task)work, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return;
                }
            }
            Object object = lock;
            synchronized (object) {
                if (alreadyRunning.get()) {
                    return;
                }
                cancel.set(true);
            }
            try {
                target.putClientProperty(NO_IMPORTS, true);
                super.actionPerformed(evt, target);
            }
            finally {
                target.putClientProperty(NO_IMPORTS, null);
            }
        }
    }

    private static final class WrappedTransferable
    implements Transferable {
        private final Transferable delegate;
        private final ImportsWrapper importsData;
        private final boolean copiedFromString;
        private DataFlavor[] transferDataFlavorsCache;

        public WrappedTransferable(Transferable delegate, ImportsWrapper importsData, boolean copiedFromString) {
            this.delegate = delegate;
            this.importsData = importsData;
            this.copiedFromString = copiedFromString;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            if (this.transferDataFlavorsCache != null) {
                return this.transferDataFlavorsCache;
            }
            DataFlavor[] f = this.delegate.getTransferDataFlavors();
            DataFlavor[] result = Arrays.copyOf(f, f.length + (this.importsData != null ? 1 : 0) + (this.copiedFromString ? 1 : 0));
            if (this.importsData != null) {
                result[f.length] = IMPORT_FLAVOR;
            }
            if (this.copiedFromString) {
                result[result.length - 1] = COPY_FROM_STRING_FLAVOR;
            }
            this.transferDataFlavorsCache = result;
            return result;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return IMPORT_FLAVOR.equals(flavor) && this.importsData != null || COPY_FROM_STRING_FLAVOR.equals(flavor) && this.copiedFromString || this.delegate.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (IMPORT_FLAVOR.equals(flavor)) {
                return this.importsData;
            }
            if (COPY_FROM_STRING_FLAVOR.equals(flavor)) {
                return this.copiedFromString;
            }
            return this.delegate.getTransferData(flavor);
        }
    }
}

