/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.indices.streamingingestion.state.ShardIngestionState;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class GetIngestionStateResponse
extends BroadcastResponse {
    private static final String INGESTION_STATE = "ingestion_state";
    private static final String NEXT_PAGE_TOKEN = "next_page_token";
    private ShardIngestionState[] shardStates;
    @Nullable
    private String nextPageToken;

    public GetIngestionStateResponse(StreamInput in) throws IOException {
        super(in);
        this.shardStates = (ShardIngestionState[])in.readArray(ShardIngestionState::new, ShardIngestionState[]::new);
        this.nextPageToken = in.readOptionalString();
    }

    public GetIngestionStateResponse(ShardIngestionState[] shardStates, int totalShards, int successfulShards, int failedShards, @Nullable String nextPageToken, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardStates = shardStates;
        this.nextPageToken = nextPageToken;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray((Writeable[])this.shardStates);
        out.writeOptionalString(this.nextPageToken);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomXContentFields(builder, params);
        if (!Strings.isEmpty((CharSequence)this.nextPageToken)) {
            builder.field(NEXT_PAGE_TOKEN, this.nextPageToken);
        }
        Map<String, List<ShardIngestionState>> shardStateByIndex = ShardIngestionState.groupShardStateByIndex(this.shardStates);
        builder.startObject(INGESTION_STATE);
        for (Map.Entry<String, List<ShardIngestionState>> indexShardIngestionStateEntry : shardStateByIndex.entrySet()) {
            builder.startArray(indexShardIngestionStateEntry.getKey());
            indexShardIngestionStateEntry.getValue().sort(Comparator.comparingInt(ShardIngestionState::shardId));
            for (ShardIngestionState shardIngestionState : indexShardIngestionStateEntry.getValue()) {
                shardIngestionState.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public ShardIngestionState[] getShardStates() {
        return this.shardStates;
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this, (boolean)true, (boolean)false);
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }
}

