/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.opensearch.action.support.ContextPreservingActionListener;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.AutoExpandReplicas;
import org.opensearch.cluster.metadata.AutoExpandSearchReplicas;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.ValidationException;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexSettings;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.threadpool.ThreadPool;

public class MetadataUpdateSettingsService {
    private static final Logger logger = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;
    private final ClusterManagerTaskThrottler.ThrottlingKey updateSettingsTaskKey;
    private AwarenessReplicaBalance awarenessReplicaBalance;

    @Inject
    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool, AwarenessReplicaBalance awarenessReplicaBalance) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
        this.awarenessReplicaBalance = awarenessReplicaBalance;
        this.updateSettingsTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.UPDATE_SETTINGS, true);
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        final Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        MetadataCreateIndexService.validateRefreshIntervalSettings(normalizedSettings, this.clusterService.getClusterSettings());
        MetadataCreateIndexService.validateTranslogDurabilitySettings(normalizedSettings, this.clusterService.getClusterSettings(), this.clusterService.getSettings());
        MetadataUpdateSettingsService.validateIndexTotalPrimaryShardsPerNodeSetting(normalizedSettings, this.clusterService);
        final int defaultReplicaCount = this.clusterService.getClusterSettings().get(Metadata.DEFAULT_REPLICA_COUNT_SETTING);
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, false, true, true);
        for (String key : normalizedSettings.keySet()) {
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            boolean isArchived = key.startsWith("archived.");
            assert (setting != null || isArchived || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (!isArchived && (isWildcard || setting.isDynamic())) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        this.clusterService.submitStateUpdateTask("update-settings " + Arrays.toString(request.indices()), new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){
            final /* synthetic */ MetadataUpdateSettingsService this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.updateSettingsTaskKey;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                void var12_49;
                int updates3;
                Settings finalSettings;
                Optional<String> error;
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closeIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                ArrayList validationErrors = new ArrayList();
                for (int i2 = 0; i2 < request.indices().length; ++i2) {
                    Index index = request.indices()[i2];
                    actualIndices[i2] = index.getName();
                    IndexMetadata metadata = currentState.metadata().getIndexSafe(index);
                    if (metadata.getState() == IndexMetadata.State.OPEN) {
                        openIndices.add(index);
                    } else {
                        closeIndices.add(index);
                    }
                    if (metadata.context() != null) {
                        MetadataCreateIndexService.validateOverlap(normalizedSettings.keySet(), MetadataIndexTemplateService.findComponentTemplate(currentState.metadata(), metadata.context()).template().settings(), index.getName()).ifPresent(validationErrors::add);
                    }
                    MetadataCreateIndexService.validateTranslogFlushIntervalSettingsForCompositeIndex(normalizedSettings, this.this$0.clusterService.getClusterSettings(), metadata.getSettings()).ifPresent(validationErrors::add);
                }
                if (validationErrors.size() > 0) {
                    ValidationException exception = new ValidationException();
                    exception.addValidationErrors(validationErrors);
                    throw exception;
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
                    int updatedNumberOfReplicas = openSettings.getAsInt("index.number_of_replicas", defaultReplicaCount);
                    if (!preserveExisting) {
                        for (Index index : request.indices()) {
                            Optional<String> error2;
                            if (index.getName().charAt(0) == '.' || !(error2 = this.this$0.awarenessReplicaBalance.validate(updatedNumberOfReplicas, AutoExpandReplicas.SETTING.get(openSettings))).isPresent()) continue;
                            ValidationException ex = new ValidationException();
                            ex.addValidationError(error2.get());
                            throw ex;
                        }
                        int n = Arrays.stream(request.indices()).mapToInt(i -> this.this$0.getTotalNewShards((Index)i, currentState, updatedNumberOfReplicas)).sum();
                        error = this.this$0.shardLimitValidator.checkShardLimit(n, currentState);
                        if (error.isPresent()) {
                            ValidationException ex = new ValidationException();
                            ex.addValidationError(error.get());
                            throw ex;
                        }
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                    }
                }
                if (IndexMetadata.INDEX_NUMBER_OF_SEARCH_REPLICAS_SETTING.exists(openSettings)) {
                    this.this$0.validateSearchReplicaCountSettings(normalizedSettings, request.indices(), currentState);
                    int updatedNumberOfSearchReplicas = IndexMetadata.INDEX_NUMBER_OF_SEARCH_REPLICAS_SETTING.get(openSettings);
                    if (!preserveExisting) {
                        for (Index index : request.indices()) {
                            Optional<String> error2;
                            if (index.getName().charAt(0) == '.' || !(error2 = this.this$0.awarenessReplicaBalance.validate(updatedNumberOfSearchReplicas, AutoExpandSearchReplicas.SETTING.get(openSettings))).isPresent()) continue;
                            ValidationException ex = new ValidationException();
                            ex.addValidationError(error2.get());
                            throw ex;
                        }
                        int n = Arrays.stream(request.indices()).mapToInt(i -> this.this$0.getTotalNewShards((Index)i, currentState, updatedNumberOfSearchReplicas)).sum();
                        error = this.this$0.shardLimitValidator.checkShardLimit(n, currentState);
                        if (error.isPresent()) {
                            ValidationException ex = new ValidationException();
                            ex.addValidationError(error.get());
                            throw ex;
                        }
                        routingTableBuilder.updateNumberOfSearchReplicas(updatedNumberOfSearchReplicas, actualIndices);
                        metadataBuilder.updateNumberOfSearchReplicas(updatedNumberOfSearchReplicas, actualIndices);
                        logger.info("updating number_of_Search Replicas to [{}] for indices {}", (Object)updatedNumberOfSearchReplicas, (Object)actualIndices);
                    }
                }
                if (!openIndices.isEmpty()) {
                    for (Index index : openIndices) {
                        IndexMetadata indexMetadata = metadataBuilder.getSafe(index);
                        Settings.Builder updates2 = Settings.builder();
                        Settings.Builder builder = Settings.builder().put(indexMetadata.getSettings());
                        if (!this.this$0.indexScopedSettings.updateDynamicSettings(openSettings, builder, updates2, index.getName())) continue;
                        if (preserveExisting) {
                            builder.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(builder)) {
                            builder.put("index.number_of_replicas", defaultReplicaCount);
                        }
                        finalSettings = builder.build();
                        this.this$0.indexScopedSettings.validate(finalSettings.filter(k -> !this.this$0.indexScopedSettings.isPrivateSetting((String)k)), true, false, true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (!closeIndices.isEmpty()) {
                    for (Index index : closeIndices) {
                        IndexMetadata indexMetadata2 = metadataBuilder.getSafe(index);
                        Settings.Builder updates3 = Settings.builder();
                        Settings.Builder builder = Settings.builder().put(indexMetadata2.getSettings());
                        if (!this.this$0.indexScopedSettings.updateSettings(closedSettings, builder, updates3, index.getName())) continue;
                        if (preserveExisting) {
                            builder.put(indexMetadata2.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(builder)) {
                            builder.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = builder.build();
                        this.this$0.indexScopedSettings.validate(finalSettings.filter(k -> !this.this$0.indexScopedSettings.isPrivateSetting((String)k)), true, false, true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata2).settings(finalSettings));
                    }
                }
                if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(normalizedSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(normalizedSettings)) {
                    String[] stringArray = actualIndices;
                    int indexMetadata2 = stringArray.length;
                    for (updates3 = 0; updates3 < indexMetadata2; ++updates3) {
                        String string = stringArray[updates3];
                        Settings indexSettings2 = metadataBuilder.get(string).getSettings();
                        MetadataCreateIndexService.validateTranslogRetentionSettings(indexSettings2);
                        MetadataCreateIndexService.validateStoreTypeSettings(indexSettings2);
                    }
                }
                boolean changed = false;
                for (String string : actualIndices) {
                    if (IndexSettings.same(currentState.metadata().index(string).getSettings(), metadataBuilder.get(string).getSettings())) continue;
                    changed = true;
                    IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(string));
                    builder.settingsVersion(1L + builder.settingsVersion());
                    metadataBuilder.put(builder);
                }
                ClusterBlocks.Builder builder = ClusterBlocks.builder().blocks(currentState.blocks());
                IndexMetadata.APIBlock[] indexMetadata2 = IndexMetadata.APIBlock.values();
                updates3 = indexMetadata2.length;
                boolean bl = false;
                while (var12_49 < updates3) {
                    IndexMetadata.APIBlock block = indexMetadata2[var12_49];
                    changed |= MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, builder, block.block, block.setting, openSettings);
                    ++var12_49;
                }
                if (!changed) {
                    return currentState;
                }
                ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(builder).build();
                updatedState = this.this$0.allocationService.reroute(updatedState, "settings update");
                try {
                    IndexMetadata updatedMetadata;
                    IndexMetadata currentMetadata;
                    for (Index index : openIndices) {
                        currentMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        this.this$0.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                    }
                    for (Index index : closeIndices) {
                        currentMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        this.this$0.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                        this.this$0.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
                    }
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToOpenSearchException((Exception)ex);
                }
                return updatedState;
            }
        });
    }

    private int getTotalNewShards(Index index, ClusterState currentState, int updatedNumberOfReplicas) {
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        int shardsInIndex = indexMetadata.getNumberOfShards();
        int oldNumberOfReplicas = indexMetadata.getNumberOfReplicas();
        int replicaIncrease = updatedNumberOfReplicas - oldNumberOfReplicas;
        return replicaIncrease * shardsInIndex;
    }

    private static boolean maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        boolean changed = false;
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    if (blocks.hasIndexBlock(index, block)) continue;
                    blocks.addIndexBlock(index, block);
                    changed = true;
                    continue;
                }
                if (!blocks.hasIndexBlock(index, block)) continue;
                blocks.removeIndexBlock(index, block);
                changed = true;
            }
        }
        return changed;
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetadata indexMetadata = metadataBuilder.get(index);
                    if (indexMetadata == null || Version.CURRENT.equals((Object)indexMetadata.getCreationVersion())) continue;
                    metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", (Version)entry.getValue().v1())).settingsVersion(1L + indexMetadata.getSettingsVersion()));
                }
                return ClusterState.builder(currentState).metadata(metadataBuilder).build();
            }
        });
    }

    private void validateSearchReplicaCountSettings(Settings requestSettings, Index[] indices, ClusterState currentState) {
        int updatedNumberOfSearchReplicas = IndexMetadata.INDEX_NUMBER_OF_SEARCH_REPLICAS_SETTING.get(requestSettings);
        if (updatedNumberOfSearchReplicas > 0 && !Arrays.stream(indices).allMatch(index -> currentState.metadata().index(index.getName()).getSettings().getAsBoolean("index.remote_store.enabled", false))) {
            throw new IllegalArgumentException("To set index.number_of_search_replicas, index.remote_store.enabled must be set to true");
        }
    }

    public static void validateIndexTotalPrimaryShardsPerNodeSetting(Settings indexSettings, ClusterService clusterService) {
        int indexPrimaryShardsPerNode = ShardsLimitAllocationDecider.INDEX_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING.get(indexSettings);
        if (indexPrimaryShardsPerNode == -1) {
            return;
        }
        boolean isRemoteStoreEnabled = clusterService.state().nodes().getNodes().values().stream().allMatch(DiscoveryNode::isRemoteStoreNode);
        if (!isRemoteStoreEnabled) {
            throw new IllegalArgumentException("Setting [" + ShardsLimitAllocationDecider.INDEX_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING.getKey() + "] can only be used with remote store enabled clusters");
        }
    }
}

