/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.QueuedRequest;
import org.opensearch.timeseries.ratelimit.RequestPriority;

public abstract class ResultWriteRequest<ResultType extends IndexableResult>
extends QueuedRequest
implements Writeable {
    private final ResultType result;
    private final String resultIndex;
    private final String flattenResultIndex;

    public ResultWriteRequest(long expirationEpochMs, String configId, RequestPriority priority, ResultType result, String resultIndex, String flattenResultIndex) {
        super(expirationEpochMs, configId, priority);
        this.result = result;
        this.resultIndex = resultIndex;
        this.flattenResultIndex = flattenResultIndex;
    }

    public ResultWriteRequest(StreamInput in, Writeable.Reader<ResultType> resultReader) throws IOException {
        this.result = (IndexableResult)resultReader.read(in);
        this.resultIndex = in.readOptionalString();
        this.flattenResultIndex = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        ((IndexableResult)this.result).writeTo(out);
        out.writeOptionalString(this.resultIndex);
        out.writeOptionalString(this.flattenResultIndex);
    }

    public ResultType getResult() {
        return this.result;
    }

    public String getResultIndex() {
        return this.resultIndex;
    }

    public String getFlattenResultIndex() {
        return this.flattenResultIndex;
    }
}

