/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.example;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import java.util.ArrayList;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.classification.Label;
import org.tribuo.classification.example.DemoLabelDataSource;
import org.tribuo.impl.ArrayExample;

public final class CheckerboardDataSource
extends DemoLabelDataSource {
    @Config(description="The number of squares on each side.")
    private int numSquares = 5;
    @Config(description="The minimum feature value.")
    private double min = 0.0;
    @Config(description="The maximum feature value.")
    private double max = 10.0;
    private double range;
    private double tileWidth;

    private CheckerboardDataSource() {
    }

    public CheckerboardDataSource(int numSamples, long seed, int numSquares, double min, double max) {
        super(numSamples, seed);
        this.numSquares = numSquares;
        this.min = min;
        this.max = max;
        this.postConfig();
    }

    @Override
    public void postConfig() {
        if (this.max <= this.min) {
            throw new PropertyException("", "min", "min must be strictly less than max, min = " + this.min + ", max = " + this.max);
        }
        if (this.numSquares < 2) {
            throw new PropertyException("", "numSquares", "numSquares must be 2 or greater, found " + this.numSquares);
        }
        this.range = Math.abs(this.max - this.min);
        this.tileWidth = this.range / (double)this.numSquares;
        super.postConfig();
    }

    @Override
    protected List<Example<Label>> generate() {
        ArrayList<Example<Label>> list = new ArrayList<Example<Label>>();
        for (int i = 0; i < this.numSamples; ++i) {
            int modX2;
            double[] values = new double[]{this.rng.nextDouble() * this.range, this.rng.nextDouble() * this.range};
            int modX1 = (int)Math.floor(values[0] / this.tileWidth) % 2;
            Label label = modX1 == (modX2 = (int)Math.floor(values[1] / this.tileWidth) % 2) ? FIRST_CLASS : SECOND_CLASS;
            values[0] = values[0] + this.min;
            values[1] = values[1] + this.min;
            list.add((Example<Label>)new ArrayExample((Output)label, FEATURE_NAMES, values));
        }
        return list;
    }

    public String toString() {
        return "Checkerboard(numSamples=" + this.numSamples + ",seed=" + this.seed + ",numSquares=" + this.numSquares + ",min=" + this.min + ",max=" + this.max + ')';
    }
}

