/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Optional;
import java.util.logging.Logger;
import org.tribuo.data.columnar.extractors.SimpleFieldExtractor;

public class FloatExtractor
extends SimpleFieldExtractor<Float> {
    private static final Logger logger = Logger.getLogger(FloatExtractor.class.getName());

    public FloatExtractor(String fieldName) {
        super(fieldName);
    }

    public FloatExtractor(String fieldName, String metadataName) {
        super(fieldName, metadataName);
    }

    private FloatExtractor() {
    }

    @Override
    public Class<Float> getValueType() {
        return Float.class;
    }

    @Override
    protected Optional<Float> extractField(String value) {
        try {
            float f = Float.parseFloat(value);
            return Optional.of(Float.valueOf(f));
        }
        catch (NumberFormatException e) {
            logger.warning("Failed to parse value for field " + this.fieldName + ", expected a float, got " + value);
            return Optional.empty();
        }
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldExtractor");
    }
}

