/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class OptimizedFeatureSet
implements FeatureSet,
Accountable {
    private final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(StoredFeatureSet.class);
    private final String name;
    private final List<Feature> features;
    private final Map<String, Integer> featureMap;

    public OptimizedFeatureSet(String name, List<Feature> features, Map<String, Integer> featureMap) {
        this.name = name;
        this.features = features;
        this.featureMap = featureMap;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Query> toQueries(LtrQueryContext context, Map<String, Object> params) {
        ArrayList<Query> queries = new ArrayList<Query>(this.features.size());
        for (Feature feature : this.features) {
            if (context.isFeatureActive(feature.name())) {
                queries.add(feature.doToQuery(context, this, params));
                continue;
            }
            queries.add((Query)new MatchNoDocsQuery("Feature " + feature.name() + " deactivated"));
        }
        return queries;
    }

    @Override
    public int featureOrdinal(String featureName) {
        Integer ordinal = this.featureMap.get(featureName);
        if (ordinal == null) {
            throw new IllegalArgumentException("Unknown feature [" + featureName + "]");
        }
        return ordinal;
    }

    @Override
    public Feature feature(int ord) {
        return this.features.get(ord);
    }

    @Override
    public Feature feature(String featureName) {
        return this.features.get(this.featureOrdinal(featureName));
    }

    @Override
    public boolean hasFeature(String featureName) {
        return this.featureMap.containsKey(featureName);
    }

    @Override
    public int size() {
        return this.features.size();
    }

    @Override
    public void validate() {
        for (Feature feature : this.features) {
            feature.validate(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizedFeatureSet that = (OptimizedFeatureSet)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.features.equals(that.features);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.features.hashCode();
        return result;
    }

    public long ramBytesUsed() {
        return this.BASE_RAM_USED + (long)(this.featureMap.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.features.stream().mapToLong(f -> f instanceof Accountable ? ((Accountable)f).ramBytesUsed() : 1L).sum();
    }
}

